/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.client.model.baked;

import com.google.common.collect.Maps;
import com.ldtteam.domumornamentum.client.model.utils.ModelUVAdapter;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RetexturedBakedModelBuilder {
    private static final Random RANDOM = new Random();
    private final BakedModel sourceModel;
    private final BakedModel target;
    private final Map<ResourceLocation, BakedModel> retexturingMaps = Maps.newHashMap();

    public static RetexturedBakedModelBuilder createFor(BakedModel target) {
        return new RetexturedBakedModelBuilder(target, target);
    }

    public static RetexturedBakedModelBuilder createFor(BakedModel sourceModel, BakedModel target) {
        return new RetexturedBakedModelBuilder(sourceModel, target);
    }

    private RetexturedBakedModelBuilder(BakedModel sourceModel, BakedModel target) {
        this.sourceModel = sourceModel;
        this.target = target;
    }

    public RetexturedBakedModelBuilder with(ResourceLocation source, BakedModel target) {
        this.retexturingMaps.putIfAbsent(source, target);
        return this;
    }

    public RetexturedBakedModelBuilder with(ResourceLocation source, Block target) {
        BlockState defaultState = target.m_49966_();
        BakedModel bakedModel = Minecraft.m_91087_().m_91289_().m_110910_(defaultState);
        return this.with(source, bakedModel);
    }

    public BakedModel build() {
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(new IModelConfiguration(){

            @Nullable
            public UnbakedModel getOwnerModel() {
                return null;
            }

            public String getModelName() {
                return "Retextured DO Model.";
            }

            public boolean isTexturePresent(String name) {
                return false;
            }

            public Material resolveTexture(String name) {
                return null;
            }

            public boolean isShadedInGui() {
                return RetexturedBakedModelBuilder.this.sourceModel.m_7539_();
            }

            public boolean isSideLit() {
                return RetexturedBakedModelBuilder.this.sourceModel.m_7547_();
            }

            public boolean useSmoothLighting() {
                return RetexturedBakedModelBuilder.this.sourceModel.m_7541_();
            }

            public ItemTransforms getCameraTransforms() {
                return RetexturedBakedModelBuilder.this.sourceModel.m_7442_();
            }

            public ModelState getCombinedTransform() {
                return null;
            }
        }, this.target.m_7343_());
        this.target.getQuads(null, null, RANDOM, (IModelData)EmptyModelData.INSTANCE).forEach(quad -> {
            if (!this.retexturingMaps.containsKey(quad.m_173410_().m_118413_())) {
                builder.m_119526_(quad);
            } else {
                builder.m_119526_(this.retexture((BakedQuad)quad, null));
            }
        });
        for (Direction value : Direction.values()) {
            this.target.getQuads(null, value, RANDOM, (IModelData)EmptyModelData.INSTANCE).forEach(quad -> {
                if (this.retexturingMaps.containsKey(quad.m_173410_().m_118413_())) {
                    builder.m_119530_(value, this.retexture((BakedQuad)quad, value));
                } else {
                    builder.m_119530_(value, quad);
                }
            });
        }
        TextureAtlasSprite particleTexture = this.target.getParticleIcon((IModelData)EmptyModelData.INSTANCE);
        if (this.retexturingMaps.containsKey(particleTexture.m_118413_())) {
            BakedModel particleOverrideTextureModel = this.retexturingMaps.get(particleTexture.m_118413_());
            particleTexture = particleOverrideTextureModel.getParticleIcon((IModelData)EmptyModelData.INSTANCE);
        }
        builder.m_119528_(particleTexture);
        return builder.m_119533_();
    }

    private BakedQuad retexture(@NotNull BakedQuad quad, @Nullable Direction direction) {
        if (!this.retexturingMaps.containsKey(quad.m_173410_().m_118413_())) {
            return quad;
        }
        TextureAtlasSprite retexturingSprite = this.getTexture(quad, direction);
        ModelUVAdapter adapter = new ModelUVAdapter(quad, retexturingSprite);
        return adapter.build();
    }

    private TextureAtlasSprite getTexture(@NotNull BakedQuad quad, @Nullable Direction direction) {
        BakedModel targetModel = this.retexturingMaps.get(quad.m_173410_().m_118413_());
        List targetQuads = targetModel.getQuads(null, direction, RANDOM, (IModelData)EmptyModelData.INSTANCE);
        if (targetQuads.isEmpty()) {
            targetQuads = targetModel.getQuads(null, quad.m_111306_(), RANDOM, (IModelData)EmptyModelData.INSTANCE);
        }
        if (targetQuads.isEmpty()) {
            return quad.m_173410_();
        }
        return ((BakedQuad)targetQuads.get(0)).m_173410_();
    }
}

