/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.item.decoration;

import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.decorative.ShingleBlock;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.util.BlockUtils;
import com.ldtteam.domumornamentum.util.MaterialTextureDataUtil;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShingleBlockItem
extends BlockItem {
    private final ShingleBlock shingleBlock;

    public ShingleBlockItem(ShingleBlock blockIn, Item.Properties builder) {
        super((Block)blockIn, builder);
        this.shingleBlock = blockIn;
    }

    @NotNull
    public Component m_7626_(ItemStack stack) {
        CompoundTag dataNbt = stack.m_41698_("textureData");
        MaterialTextureData textureData = MaterialTextureData.deserializeFromNBT(dataNbt);
        IMateriallyTexturedBlockComponent coverComponent = (IMateriallyTexturedBlockComponent)this.shingleBlock.getComponents().get(0);
        Block centerBlock = textureData.getTexturedComponents().getOrDefault(coverComponent.getId(), coverComponent.getDefault());
        Component centerBlockName = BlockUtils.getHoverName(centerBlock);
        return new TranslatableComponent("domum_ornamentum.shingle.name.format", new Object[]{centerBlockName});
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)new TranslatableComponent("domum_ornamentum.origin.tooltip"));
        CompoundTag dataNbt = stack.m_41698_("textureData");
        MaterialTextureData textureData = MaterialTextureData.deserializeFromNBT(dataNbt);
        if (textureData.isEmpty()) {
            textureData = MaterialTextureDataUtil.generateRandomTextureDataFrom(stack);
        }
        IMateriallyTexturedBlockComponent supportComponent = (IMateriallyTexturedBlockComponent)this.shingleBlock.getComponents().get(1);
        Block supportBlock = textureData.getTexturedComponents().getOrDefault(supportComponent.getId(), supportComponent.getDefault());
        Component supportBlockName = BlockUtils.getHoverName(supportBlock);
        tooltip.add((Component)new TranslatableComponent("domum_ornamentum.shingle.support.format", new Object[]{supportBlockName}));
        IMateriallyTexturedBlockComponent mainComponent = (IMateriallyTexturedBlockComponent)this.shingleBlock.getComponents().get(0);
        Block mainBlock = textureData.getTexturedComponents().getOrDefault(mainComponent.getId(), mainComponent.getDefault());
        Component mainBlockName = BlockUtils.getHoverName(mainBlock);
        tooltip.add((Component)new TranslatableComponent("domum_ornamentum.shingle.main.format", new Object[]{mainBlockName}));
    }
}

