/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.reap;

import de.maxhenkel.reap.Main;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CropEvents {
    @SubscribeEvent
    public void onPlayerUse(PlayerInteractEvent.RightClickBlock event) {
        if (CropEvents.harvest(event.getPos(), event.getPlayer())) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    public static boolean harvest(BlockPos pos, Player player) {
        Level world = player.f_19853_;
        BlockState state = world.m_8055_(pos);
        Block blockClicked = state.m_60734_();
        if (Main.SERVER_CONFIG.reapWhitelist.stream().noneMatch(tag -> tag.m_8110_((Object)state.m_60734_()))) {
            return false;
        }
        BonemealableBlock growble = CropEvents.getGrowable(blockClicked);
        if (growble == null) {
            return false;
        }
        if (growble.m_7370_((BlockGetter)world, pos, state, world.f_46443_)) {
            return false;
        }
        if (world.f_46443_ || !(world instanceof ServerLevel)) {
            return true;
        }
        LootContext.Builder context = new LootContext.Builder((ServerLevel)world).m_78972_(LootContextParams.f_81460_, (Object)new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())).m_78972_(LootContextParams.f_81461_, (Object)state).m_78972_(LootContextParams.f_81455_, (Object)player);
        if (((Boolean)Main.SERVER_CONFIG.considerTool.get()).booleanValue()) {
            context.m_78972_(LootContextParams.f_81463_, (Object)player.m_21205_());
        } else {
            context.m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_);
        }
        List drops = state.m_60724_(context);
        BlockState newState = blockClicked.m_49966_();
        if (state.m_61147_().stream().anyMatch(p -> p.equals((Object)BlockStateProperties.f_61374_))) {
            newState = (BlockState)newState.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
        }
        if (state.m_61147_().stream().anyMatch(p -> p.equals((Object)BlockStateProperties.f_61409_))) {
            newState = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61409_, (Comparable)Integer.valueOf(0));
        }
        world.m_46597_(pos, newState);
        for (ItemStack stack : drops) {
            Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
        }
        return true;
    }

    private static BonemealableBlock getGrowable(Block block) {
        if (block instanceof BonemealableBlock) {
            return (BonemealableBlock)block;
        }
        if (block instanceof NetherWartBlock) {
            return new BonemealableBlock(){

                public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
                    return (Integer)state.m_61143_((Property)NetherWartBlock.f_54967_) < 3;
                }

                public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
                    return false;
                }

                public void m_7719_(ServerLevel world, Random random, BlockPos pos, BlockState state) {
                }
            };
        }
        return null;
    }
}

