/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.reap;

import de.maxhenkel.reap.corelib.config.ConfigBase;
import de.maxhenkel.reap.corelib.tag.TagUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.event.config.ModConfigEvent;

public class ServerConfig
extends ConfigBase {
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> reapWhitelistSpec;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> logTypesSpec;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> groundTypesSpec;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> allowedTreeToolsSpec;
    public final ForgeConfigSpec.BooleanValue considerTool;
    public final ForgeConfigSpec.BooleanValue treeHarvest;
    public final ForgeConfigSpec.IntValue treeHarvestMaxCount;
    public final ForgeConfigSpec.BooleanValue dynamicTreeBreakingEnabled;
    public final ForgeConfigSpec.DoubleValue dynamicTreeBreakingMinSpeed;
    public final ForgeConfigSpec.DoubleValue dynamicTreeBreakingPerLog;
    public List<Tag<Block>> reapWhitelist;
    public List<Tag<Block>> logTypes;
    public List<Tag<Block>> groundTypes;
    public List<Tag<Item>> allowedTreeTools;

    public ServerConfig(ForgeConfigSpec.Builder builder) {
        super(builder);
        this.reapWhitelistSpec = builder.comment("The blocks that should get harvested by right-clicking").defineList("crop_harvesting.whitelist", Arrays.asList("minecraft:nether_wart", "minecraft:potatoes", "minecraft:carrots", "minecraft:wheat", "minecraft:beetroots", "minecraft:cocoa"), Objects::nonNull);
        this.logTypesSpec = builder.comment("The log blocks that are allowed to get harvested by the tree harvester").comment("Examples: 'minecraft:oak_log', '#minecraft:logs'").defineList("tree_harvesting.log_types", Arrays.asList("minecraft:acacia_log", "minecraft:birch_log", "minecraft:dark_oak_log", "minecraft:jungle_log", "minecraft:oak_log", "minecraft:spruce_log", "minecraft:crimson_stem", "minecraft:warped_stem"), Objects::nonNull);
        this.groundTypesSpec = builder.comment("The blocks that are allowed below logs that can be harvested").comment("Examples: 'minecraft:dirt', '#forge:sand/colorless'").defineList("tree_harvesting.ground_types", Arrays.asList("minecraft:dirt", "minecraft:grass_block", "minecraft:coarse_dirt", "minecraft:podzol", "minecraft:mycelium", "minecraft:warped_nylium", "minecraft:crimson_nylium", "minecraft:netherrack"), Objects::nonNull);
        this.allowedTreeToolsSpec = builder.comment("The tools which the player is allowed to harvest trees").defineList("tree_harvesting.allowed_tree_tools", Arrays.asList("minecraft:wooden_axe", "minecraft:golden_axe", "minecraft:stone_axe", "minecraft:iron_axe", "minecraft:diamond_axe", "minecraft:netherite_axe"), Objects::nonNull);
        this.considerTool = builder.comment("If the held tool should be considered when right-click harvesting").define("crop_harvesting.consider_tool", true);
        this.treeHarvest = builder.comment("If the tree harvester should be enabled").define("tree_harvesting.enabled", true);
        this.treeHarvestMaxCount = builder.comment("The maximum amount of logs one harvest is allowed to do").defineInRange("tree_harvesting.max_harvesting_count", 128, 0, 1024);
        this.dynamicTreeBreakingEnabled = builder.comment("If bigger trees should be harder to break").define("tree_harvesting.dynamic_breaking_speed.enabled", true);
        this.dynamicTreeBreakingMinSpeed = builder.comment("The maximum amount of time a tree should take to harvest").defineInRange("tree_harvesting.dynamic_breaking_speed.min_speed", 10.0, 1.0, 100.0);
        this.dynamicTreeBreakingPerLog = builder.comment("The amount of breaking time that gets added per harvested log").defineInRange("tree_harvesting.dynamic_breaking_speed.per_log", 0.1, 0.0, 100.0);
    }

    @Override
    public void onReload(ModConfigEvent event) {
        super.onReload(event);
        this.reapWhitelist = ((List)this.reapWhitelistSpec.get()).stream().map(s -> TagUtils.getBlock(s, true)).filter(Objects::nonNull).collect(Collectors.toList());
        this.logTypes = ((List)this.logTypesSpec.get()).stream().map(s -> TagUtils.getBlock(s, true)).filter(Objects::nonNull).collect(Collectors.toList());
        this.groundTypes = ((List)this.groundTypesSpec.get()).stream().map(s -> TagUtils.getBlock(s, true)).filter(Objects::nonNull).collect(Collectors.toList());
        this.allowedTreeTools = ((List)this.allowedTreeToolsSpec.get()).stream().map(s -> TagUtils.getItem(s, true)).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

