/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips;

import com.anthonyhilyard.iceberg.events.GatherComponentsExtEvent;
import com.anthonyhilyard.iceberg.events.RenderTooltipExtEvent;
import com.anthonyhilyard.iceberg.util.ItemColor;
import com.anthonyhilyard.legendarytooltips.LegendaryTooltipsConfig;
import com.anthonyhilyard.legendarytooltips.render.TooltipDecor;
import java.awt.Color;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="legendarytooltips", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class LegendaryTooltips {
    public static final int STANDARD = -1;
    public static final int NO_BORDER = -2;
    public static final int NUM_FRAMES = 16;
    private static ItemStack lastTooltipItem = null;

    private static LegendaryTooltipsConfig.FrameDefinition getDefinitionColors(ItemStack item, int defaultStartBorder, int defaultEndBorder, int defaultBackground) {
        LegendaryTooltipsConfig.FrameDefinition result = LegendaryTooltipsConfig.INSTANCE.getFrameDefinition(item);
        switch (result.index()) {
            case -2: {
                result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), defaultStartBorder, defaultEndBorder, defaultBackground, LegendaryTooltipsConfig.FrameSource.NONE, 0);
                break;
            }
            case -1: {
                if (!((Boolean)LegendaryTooltipsConfig.INSTANCE.bordersMatchRarity.get()).booleanValue()) break;
                TextColor rarityColor = ItemColor.getColorForItem((ItemStack)item, (TextColor)TextColor.m_131270_((ChatFormatting)ChatFormatting.WHITE));
                float[] hsbVals = new float[3];
                Color.RGBtoHSB(rarityColor.m_131265_() >> 16 & 0xFF, rarityColor.m_131265_() >> 8 & 0xFF, rarityColor.m_131265_() >> 0 & 0xFF, hsbVals);
                boolean addHue = false;
                if (hsbVals[0] * 360.0f < 62.0f) {
                    addHue = false;
                } else if (hsbVals[0] * 360.0f <= 240.0f) {
                    addHue = true;
                }
                float startHue = addHue ? hsbVals[0] - 0.006f : hsbVals[0] + 0.006f;
                float endHue = addHue ? hsbVals[0] + 0.04f : hsbVals[0] - 0.04f;
                startHue = (startHue + 1.0f) % 1.0f;
                endHue = (endHue + 1.0f) % 1.0f;
                TextColor startColor = TextColor.m_131266_((int)Color.getHSBColor(startHue, hsbVals[1], hsbVals[2]).getRGB());
                TextColor endColor = TextColor.m_131266_((int)Color.getHSBColor(endHue, hsbVals[1], hsbVals[2]).getRGB());
                TextColor backgroundColor = TextColor.m_131266_((int)Color.getHSBColor(hsbVals[0], hsbVals[1] * 0.9f, 0.06f).getRGB());
                result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), startColor.m_131265_() & 0xAAFFFFFF, endColor.m_131265_() & 0x44FFFFFF, backgroundColor.m_131265_() & 0xF0FFFFFF, LegendaryTooltipsConfig.FrameSource.NONE, 0);
            }
        }
        if (result.startBorder() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), defaultStartBorder, result.endBorder(), result.background(), LegendaryTooltipsConfig.FrameSource.NONE, 0);
        }
        if (result.endBorder() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), result.startBorder(), defaultEndBorder, result.background(), LegendaryTooltipsConfig.FrameSource.NONE, 0);
        }
        if (result.background() == null) {
            result = new LegendaryTooltipsConfig.FrameDefinition(result.resource(), result.index(), result.startBorder(), result.endBorder(), defaultBackground, LegendaryTooltipsConfig.FrameSource.NONE, 0);
        }
        return result;
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        TooltipDecor.updateTimer();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null && mc.f_91080_ instanceof AbstractContainerScreen && ((AbstractContainerScreen)mc.f_91080_).getSlotUnderMouse() != null && ((AbstractContainerScreen)mc.f_91080_).getSlotUnderMouse().m_6657_() && lastTooltipItem != ((AbstractContainerScreen)mc.f_91080_).getSlotUnderMouse().m_7993_()) {
            TooltipDecor.resetTimer();
            lastTooltipItem = ((AbstractContainerScreen)mc.f_91080_).getSlotUnderMouse().m_7993_();
        }
    }

    @SubscribeEvent
    public static void onGatherComponentsEvent(RenderTooltipEvent.GatherComponents event) {
        if (LegendaryTooltipsConfig.INSTANCE.getFrameDefinition(event.getItemStack()).index() != -2) {
            int index = 0;
            if (event instanceof GatherComponentsExtEvent) {
                index = ((GatherComponentsExtEvent)event).getIndex();
            }
            TooltipDecor.setCachedLines(event.getTooltipElements(), index);
        }
    }

    @SubscribeEvent
    public static void onTooltipColorEvent(RenderTooltipEvent.Color event) {
        LegendaryTooltipsConfig.FrameDefinition frameDefinition = LegendaryTooltips.getDefinitionColors(event.getItemStack(), event.getBorderStart(), event.getBorderEnd(), event.getBackgroundStart());
        TooltipDecor.setCurrentTooltipBorderStart(frameDefinition.startBorder());
        TooltipDecor.setCurrentTooltipBorderEnd(frameDefinition.endBorder());
        boolean comparison = false;
        if (event instanceof RenderTooltipExtEvent.Color) {
            comparison = ((RenderTooltipExtEvent.Color)event).isComparison();
        }
        if (comparison) {
            event.setBorderStart(0);
            event.setBorderEnd(0);
        } else {
            event.setBorderStart(frameDefinition.startBorder().intValue());
            event.setBorderEnd(frameDefinition.endBorder().intValue());
        }
        event.setBackground(frameDefinition.background().intValue());
    }

    @SubscribeEvent
    public static void onPostTooltipEvent(RenderTooltipExtEvent.Post event) {
        if (LegendaryTooltipsConfig.INSTANCE.getFrameDefinition(event.getItemStack()).index() == -2) {
            return;
        }
        if (((Boolean)LegendaryTooltipsConfig.INSTANCE.tooltipShadow.get()).booleanValue()) {
            if (event.isComparison()) {
                TooltipDecor.drawShadow(event.getPoseStack(), event.getX(), event.getY() - 11, event.getWidth(), event.getHeight() + 11);
            } else {
                TooltipDecor.drawShadow(event.getPoseStack(), event.getX(), event.getY(), event.getWidth(), event.getHeight());
            }
        }
        if (event.isComparison()) {
            TooltipDecor.drawBorder(event.getPoseStack(), event.getX(), event.getY() - 11, event.getWidth(), event.getHeight() + 11, event.getItemStack(), event.getFont(), LegendaryTooltipsConfig.INSTANCE.getFrameDefinition(event.getItemStack()), event.isComparison(), event.getIndex());
        } else {
            TooltipDecor.drawBorder(event.getPoseStack(), event.getX(), event.getY(), event.getWidth(), event.getHeight(), event.getItemStack(), event.getFont(), LegendaryTooltipsConfig.INSTANCE.getFrameDefinition(event.getItemStack()), event.isComparison(), event.getIndex());
        }
    }
}

