/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureWaterloggedBlock;
import com.mrcrayfish.furniture.common.ModTags;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HedgeBlock
extends FurnitureWaterloggedBlock {
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;
    public final ImmutableMap<BlockState, VoxelShape> COLLISION_SHAPES;

    public HedgeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_(), false);
        this.COLLISION_SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_(), true);
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states, boolean collision) {
        VoxelShape POST = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        VoxelShape[] SIDE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            boolean north = (Boolean)state.m_61143_((Property)NORTH);
            boolean east = (Boolean)state.m_61143_((Property)EAST);
            boolean south = (Boolean)state.m_61143_((Property)SOUTH);
            boolean west = (Boolean)state.m_61143_((Property)WEST);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(this.applyCollision(POST, collision));
            if (north) {
                shapes.add(this.applyCollision(SIDE[Direction.NORTH.m_122416_()], collision));
            }
            if (east) {
                shapes.add(this.applyCollision(SIDE[Direction.EAST.m_122416_()], collision));
            }
            if (south) {
                shapes.add(this.applyCollision(SIDE[Direction.SOUTH.m_122416_()], collision));
            }
            if (west) {
                shapes.add(this.applyCollision(SIDE[Direction.WEST.m_122416_()], collision));
            }
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    private VoxelShape applyCollision(VoxelShape shape, boolean collision) {
        if (collision) {
            shape = VoxelShapeHelper.setMaxHeight(shape, 1.5);
            shape = VoxelShapeHelper.limitHorizontal(shape);
        }
        return shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.COLLISION_SHAPES.get((Object)state);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        return this.getHedgeState(state, level, pos);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getHedgeState(super.m_5573_(context), (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    private BlockState getHedgeState(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean north = this.canConnectToBlock(level, pos, Direction.NORTH);
        boolean east = this.canConnectToBlock(level, pos, Direction.EAST);
        boolean south = this.canConnectToBlock(level, pos, Direction.SOUTH);
        boolean west = this.canConnectToBlock(level, pos, Direction.WEST);
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west));
    }

    private boolean canConnectToBlock(LevelAccessor level, BlockPos pos, Direction direction) {
        BlockPos offsetPos = pos.m_142300_(direction);
        BlockState offsetState = level.m_8055_(offsetPos);
        return !HedgeBlock.m_152463_((BlockState)offsetState) && offsetState.m_60783_((BlockGetter)level, offsetPos, direction.m_122424_()) || offsetState.m_60620_(ModTags.Blocks.HEDGES);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NORTH});
        builder.m_61104_(new Property[]{EAST});
        builder.m_61104_(new Property[]{SOUTH});
        builder.m_61104_(new Property[]{WEST});
    }

    @Deprecated
    public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1;
    }
}

