/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.block.CabinetBlock;
import com.mrcrayfish.furniture.block.CrateBlock;
import com.mrcrayfish.furniture.core.ModBlockEntities;
import com.mrcrayfish.furniture.core.ModSounds;
import com.mrcrayfish.furniture.inventory.container.CrateMenu;
import com.mrcrayfish.furniture.tileentity.BasicLootBlockEntity;
import com.mrcrayfish.furniture.util.BlockEntityUtil;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class CrateBlockEntity
extends BasicLootBlockEntity {
    private UUID ownerUuid;
    private boolean locked;

    protected CrateBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public CrateBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CRATE.get(), pos, state);
    }

    @Override
    public int m_6643_() {
        return 27;
    }

    @Override
    protected Component m_6820_() {
        return new TranslatableComponent("container.cfm.crate");
    }

    @Override
    protected AbstractContainerMenu m_6555_(int windowId, Inventory playerInventory) {
        if (this.locked && !this.ownerUuid.equals(playerInventory.f_35978_.m_142081_())) {
            playerInventory.f_35978_.m_5661_((Component)new TranslatableComponent("container.isLocked", new Object[]{this.m_5446_()}), true);
            playerInventory.f_35978_.m_6330_(SoundEvents.f_11748_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return null;
        }
        return new CrateMenu(windowId, playerInventory, this, this.locked);
    }

    @Override
    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        CrateMenu crateMenu;
        return menu instanceof CrateMenu && (crateMenu = (CrateMenu)menu).getBlockEntity() == this;
    }

    public UUID getOwner() {
        return this.ownerUuid;
    }

    public void setOwner(UUID uuid) {
        this.ownerUuid = uuid;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        BlockEntityUtil.sendUpdatePacket((BlockEntity)this);
    }

    @Override
    public void onOpen(Level level, BlockPos pos, BlockState state) {
        this.playLidSound(state, (SoundEvent)ModSounds.BLOCK_CABINET_OPEN.get());
        this.setLidState(state, true);
    }

    @Override
    public void onClose(Level level, BlockPos pos, BlockState state) {
        this.playLidSound(state, (SoundEvent)ModSounds.BLOCK_CABINET_CLOSE.get());
        this.setLidState(state, false);
    }

    public void removeUnauthorisedPlayers() {
        if (this.locked) {
            int x = this.f_58858_.m_123341_();
            int y = this.f_58858_.m_123342_();
            int z = this.f_58858_.m_123343_();
            for (Player player : this.f_58857_.m_45976_(Player.class, new AABB((double)((float)x - 5.0f), (double)((float)y - 5.0f), (double)((float)z - 5.0f), (double)((float)(x + 1) + 5.0f), (double)((float)(y + 1) + 5.0f), (double)((float)(z + 1) + 5.0f)))) {
                CrateBlockEntity container;
                if (!(player.f_36096_ instanceof CrateMenu) || this != (container = ((CrateMenu)player.f_36096_).getBlockEntity()) || player.m_142081_().equals(this.ownerUuid)) continue;
                player.m_6915_();
            }
        }
    }

    private void playLidSound(BlockState state, SoundEvent event) {
        Vec3i directionVec = ((Direction)state.m_61143_((Property)CabinetBlock.DIRECTION)).m_122436_();
        double x = (double)this.f_58858_.m_123341_() + 0.5 + (double)directionVec.m_123341_() / 2.0;
        double y = (double)this.f_58858_.m_123342_() + 0.5 + (double)directionVec.m_123342_() / 2.0;
        double z = (double)this.f_58858_.m_123343_() + 0.5 + (double)directionVec.m_123343_() / 2.0;
        Level level = this.m_58904_();
        if (level != null) {
            level.m_6263_(null, x, y, z, event, SoundSource.BLOCKS, 0.75f, level.f_46441_.nextFloat() * 0.1f + 0.7f);
        }
    }

    private void setLidState(BlockState state, boolean open) {
        Level level = this.m_58904_();
        if (level != null) {
            level.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)CrateBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.readData(compound);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.writeData(tag);
    }

    public CompoundTag m_5995_() {
        return this.writeData(new CompoundTag());
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag compound = pkt.m_131708_();
        this.readData(compound);
    }

    private void readData(CompoundTag compound) {
        if (compound.m_128403_("OwnerUUID")) {
            this.ownerUuid = compound.m_128342_("OwnerUUID");
        }
        if (compound.m_128425_("Locked", 1)) {
            this.locked = compound.m_128471_("Locked");
        }
    }

    private CompoundTag writeData(CompoundTag compound) {
        if (this.ownerUuid != null) {
            compound.m_128362_("OwnerUUID", this.ownerUuid);
        }
        compound.m_128379_("Locked", this.locked);
        return compound;
    }

    @Override
    public boolean m_7155_(int i, ItemStack itemStack, @Nullable Direction direction) {
        return !this.locked;
    }

    @Override
    public boolean m_7157_(int i, ItemStack itemStack, Direction direction) {
        return !this.locked;
    }
}

