/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.google.common.collect.Maps;
import com.mrcrayfish.furniture.block.FreezerBlock;
import com.mrcrayfish.furniture.core.ModBlockEntities;
import com.mrcrayfish.furniture.core.ModSounds;
import com.mrcrayfish.furniture.event.FreezerFuelTimeEvent;
import com.mrcrayfish.furniture.inventory.container.FreezerMenu;
import com.mrcrayfish.furniture.item.crafting.ModRecipeType;
import com.mrcrayfish.furniture.tileentity.BasicLootBlockEntity;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class FreezerBlockEntity
extends BasicLootBlockEntity {
    private static final int[] SLOTS_SOURCE = new int[]{0};
    private static final int[] SLOTS_FUEL = new int[]{1};
    private static final int[] SLOTS_RESULT = new int[]{2};
    private int fuelTime;
    private int fuelTimeTotal;
    private int freezeTime;
    private int freezeTimeTotal;
    protected final SimpleContainerData freezerData = new SimpleContainerData(4){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return FreezerBlockEntity.this.fuelTime;
                }
                case 1: {
                    return FreezerBlockEntity.this.fuelTimeTotal;
                }
                case 2: {
                    return FreezerBlockEntity.this.freezeTime;
                }
                case 3: {
                    return FreezerBlockEntity.this.freezeTimeTotal;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    FreezerBlockEntity.this.fuelTime = value;
                    break;
                }
                case 1: {
                    FreezerBlockEntity.this.fuelTimeTotal = value;
                    break;
                }
                case 2: {
                    FreezerBlockEntity.this.freezeTime = value;
                    break;
                }
                case 3: {
                    FreezerBlockEntity.this.freezeTimeTotal = value;
                }
            }
        }
    };
    private final Map<ResourceLocation, Integer> usedRecipeCount = Maps.newHashMap();

    protected FreezerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public FreezerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.FREEZER.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, FreezerBlockEntity blockEntity) {
        boolean freezing = blockEntity.isFreezing();
        boolean shouldMarkDirty = false;
        if (blockEntity.isFreezing()) {
            --blockEntity.fuelTime;
        }
        ItemStack fuelStack = (ItemStack)blockEntity.items.get(1);
        if (blockEntity.isFreezing() || !fuelStack.m_41619_() && !((ItemStack)blockEntity.items.get(0)).m_41619_()) {
            Recipe recipe = level.m_7465_().m_44015_(ModRecipeType.FREEZER_SOLIDIFY, (Container)blockEntity, level).orElse(null);
            if (!blockEntity.isFreezing() && blockEntity.canFreeze(recipe)) {
                blockEntity.fuelTimeTotal = blockEntity.fuelTime = blockEntity.getFreezeTime(fuelStack);
                if (blockEntity.isFreezing()) {
                    shouldMarkDirty = true;
                    if (fuelStack.hasContainerItem()) {
                        blockEntity.items.set(1, (Object)fuelStack.getContainerItem());
                    } else if (!fuelStack.m_41619_()) {
                        fuelStack.m_41774_(1);
                        if (fuelStack.m_41619_()) {
                            blockEntity.items.set(1, (Object)fuelStack.getContainerItem());
                        }
                    }
                }
            }
            if (blockEntity.isFreezing() && blockEntity.canFreeze(recipe)) {
                ++blockEntity.freezeTime;
                if (blockEntity.freezeTime == blockEntity.freezeTimeTotal) {
                    blockEntity.freezeTime = 0;
                    blockEntity.freezeTimeTotal = blockEntity.getFreezeTime();
                    blockEntity.freeze(recipe);
                    shouldMarkDirty = true;
                }
            } else {
                blockEntity.freezeTime = 0;
            }
        } else if (blockEntity.freezeTime > 0) {
            blockEntity.freezeTime = Mth.m_14045_((int)(blockEntity.freezeTime - 2), (int)0, (int)blockEntity.freezeTimeTotal);
        }
        if (shouldMarkDirty) {
            blockEntity.m_6596_();
        }
    }

    private boolean isFreezing() {
        return this.fuelTime > 0;
    }

    public int getFreezeTime(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        if (stack.m_41720_() == Items.f_41980_) {
            return 2000;
        }
        if (stack.m_41720_() == Items.f_42363_) {
            return 162000;
        }
        if (stack.m_41720_() == Items.f_42201_) {
            return 18000;
        }
        FreezerFuelTimeEvent event = new FreezerFuelTimeEvent(stack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getFuelTime();
    }

    private boolean canFreeze(@Nullable Recipe<?> recipe) {
        if (!((ItemStack)this.items.get(0)).m_41619_() && recipe != null) {
            ItemStack outputStack = recipe.m_8043_();
            if (outputStack.m_41619_()) {
                return false;
            }
            ItemStack resultStack = (ItemStack)this.items.get(2);
            if (resultStack.m_41619_()) {
                return true;
            }
            if (!resultStack.m_41656_(outputStack)) {
                return false;
            }
            if (resultStack.m_41613_() + outputStack.m_41613_() <= this.m_6893_() && resultStack.m_41613_() + outputStack.m_41613_() <= resultStack.m_41741_()) {
                return true;
            }
            return resultStack.m_41613_() + outputStack.m_41613_() <= outputStack.m_41741_();
        }
        return false;
    }

    private void freeze(@Nullable Recipe<?> recipe) {
        if (recipe != null && this.canFreeze(recipe)) {
            ItemStack sourceStack = (ItemStack)this.items.get(0);
            ItemStack outputStack = recipe.m_8043_();
            ItemStack resultStack = (ItemStack)this.items.get(2);
            if (resultStack.m_41619_()) {
                this.items.set(2, (Object)outputStack.m_41777_());
            } else if (resultStack.m_41720_() == outputStack.m_41720_()) {
                resultStack.m_41769_(outputStack.m_41613_());
            }
            if (!this.f_58857_.f_46443_) {
                this.addRecipeUsed(recipe);
            }
            if (sourceStack.hasContainerItem()) {
                this.items.set(0, (Object)sourceStack.getContainerItem());
            } else {
                sourceStack.m_41774_(1);
            }
        }
    }

    @Override
    public int m_6643_() {
        return 3;
    }

    public void m_6836_(int index, ItemStack stack) {
        super.m_6836_(index, stack);
        if (index == 0) {
            this.freezeTimeTotal = this.getFreezeTime();
            this.freezeTime = 0;
            this.m_6596_();
        }
    }

    protected int getFreezeTime() {
        return this.f_58857_.m_7465_().m_44015_(ModRecipeType.FREEZER_SOLIDIFY, (Container)this, this.f_58857_).map(AbstractCookingRecipe::m_43753_).orElse(300);
    }

    @Override
    protected Component m_6820_() {
        return new TranslatableComponent("container.cfm.freezer");
    }

    @Override
    protected AbstractContainerMenu m_6555_(int windowId, Inventory playerInventory) {
        return new FreezerMenu(windowId, playerInventory, this);
    }

    @Override
    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        FreezerMenu freezerMenu;
        return menu instanceof FreezerMenu && (freezerMenu = (FreezerMenu)menu).getBlockEntity() == this;
    }

    @Override
    public int[] m_7071_(Direction direction) {
        switch (direction) {
            case UP: {
                return SLOTS_SOURCE;
            }
            case DOWN: {
                return SLOTS_RESULT;
            }
        }
        return SLOTS_FUEL;
    }

    private void addRecipeUsed(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            this.usedRecipeCount.compute(recipe.m_6423_(), (id, count) -> 1 + (count == null ? 0 : count));
        }
    }

    public void spawnExperience(Player player) {
        for (Map.Entry<ResourceLocation, Integer> entry : this.usedRecipeCount.entrySet()) {
            player.f_19853_.m_7465_().m_44043_(entry.getKey()).ifPresent(recipe -> FreezerBlockEntity.spawnExperienceOrbs(player, (Integer)entry.getValue(), ((AbstractCookingRecipe)recipe).m_43750_()));
        }
        this.usedRecipeCount.clear();
    }

    private static void spawnExperienceOrbs(Player player, int count, float exp) {
        if (exp == 0.0f) {
            count = 0;
        } else if (exp < 1.0f) {
            int totalExp = Mth.m_14143_((float)((float)count * exp));
            if (totalExp < Mth.m_14167_((float)((float)count * exp)) && Math.random() < (double)((float)count * exp - (float)totalExp)) {
                ++totalExp;
            }
            count = totalExp;
        }
        while (count > 0) {
            int splitExp = ExperienceOrb.m_20782_((int)count);
            count -= splitExp;
            player.f_19853_.m_7967_((Entity)new ExperienceOrb(player.f_19853_, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), splitExp));
        }
    }

    @Override
    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return this.m_7013_(index, stack);
    }

    @Override
    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return index == 2;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        return this.getFreezeTime(stack) > 0;
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.freezeTime = compound.m_128451_("FreezeTime");
        this.freezeTimeTotal = compound.m_128451_("FreezeTimeTotal");
        this.fuelTime = compound.m_128451_("FuelTime");
        this.fuelTimeTotal = this.getFreezeTime((ItemStack)this.items.get(1));
        int recipesUsedSize = compound.m_128448_("RecipesUsedSize");
        for (int i = 0; i < recipesUsedSize; ++i) {
            ResourceLocation resourcelocation = new ResourceLocation(compound.m_128461_("RecipeLocation" + i));
            int amount = compound.m_128451_("RecipeAmount" + i);
            this.usedRecipeCount.put(resourcelocation, amount);
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("FreezeTime", this.freezeTime);
        tag.m_128405_("FreezeTimeTotal", this.freezeTimeTotal);
        tag.m_128405_("FuelTime", this.fuelTime);
        tag.m_128376_("RecipesUsedSize", (short)this.usedRecipeCount.size());
        int i = 0;
        for (Map.Entry<ResourceLocation, Integer> entry : this.usedRecipeCount.entrySet()) {
            tag.m_128359_("RecipeLocation" + i, entry.getKey().toString());
            tag.m_128405_("RecipeAmount" + i, entry.getValue().intValue());
            ++i;
        }
    }

    public ContainerData getFreezerData() {
        return this.freezerData;
    }

    @Override
    public void onOpen(Level level, BlockPos pos, BlockState state) {
        this.playDoorSound(state, (SoundEvent)ModSounds.BLOCK_FRIDGE_OPEN.get());
        this.setDoorState(state, true);
    }

    @Override
    public void onClose(Level level, BlockPos pos, BlockState state) {
        this.playDoorSound(state, (SoundEvent)ModSounds.BLOCK_FRIDGE_CLOSE.get());
        this.setDoorState(state, false);
    }

    private void playDoorSound(BlockState state, SoundEvent event) {
        Vec3i directionVec = ((Direction)state.m_61143_((Property)FreezerBlock.DIRECTION)).m_122424_().m_122436_();
        double x = (double)this.f_58858_.m_123341_() + 0.5 + (double)directionVec.m_123341_() / 2.0;
        double y = (double)this.f_58858_.m_123342_() + 0.5 + (double)directionVec.m_123342_() / 2.0;
        double z = (double)this.f_58858_.m_123343_() + 0.5 + (double)directionVec.m_123343_() / 2.0;
        Level level = this.m_58904_();
        if (level != null) {
            level.m_6263_(null, x, y, z, event, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void setDoorState(BlockState state, boolean open) {
        Level level = this.m_58904_();
        if (level != null) {
            level.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)FreezerBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }
}

