/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.angelring.compat;

import dev.denismasterherobrine.angelring.config.Configuration;
import dev.denismasterherobrine.angelring.register.ItemRegistry;
import dev.denismasterherobrine.angelring.utils.ExperienceUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.InterModComms;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class ClassicAngelRingIntegration {
    private static int i;

    public static void sendImc() {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("angelring").build());
    }

    public static ICapabilityProvider initCapabilities() {
        final ICurio curio = new ICurio(){

            public ItemStack getStack() {
                return ItemRegistry.ItemRing.m_7968_();
            }

            public boolean canEquipFromUse(SlotContext slotContext) {
                return true;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                LivingEntity livingEntity = slotContext.entity();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    this.startFlying(player);
                }
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                LivingEntity livingEntity = slotContext.getWearer();
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    this.stopFlying(player);
                }
            }

            private void startFlying(Player player) {
                if (!player.m_7500_() && !player.m_5833_()) {
                    player.m_150110_().f_35936_ = true;
                    player.m_6885_();
                }
            }

            private void stopFlying(Player player) {
                if (!player.m_7500_() && !player.m_5833_()) {
                    player.m_150110_().f_35935_ = false;
                    player.m_150110_().f_35936_ = false;
                    player.m_6885_();
                }
            }

            public void curioTick(String identifier, int index, LivingEntity livingEntity) {
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    if (!player.m_150110_().f_35936_ && ExperienceUtils.getPlayerXP(player) > (Integer)Configuration.XPCost.get()) {
                        this.startFlying(player);
                    }
                    if (ExperienceUtils.getPlayerXP(player) <= (Integer)Configuration.XPCost.get() && (Integer)Configuration.XPCost.get() != 0) {
                        this.stopFlying(player);
                        if (player instanceof ServerPlayer) {
                            ((ServerPlayer)player).m_9146_((Component)new TextComponent("You need to have XP to fly. Get more XP to fly or take off Angel Ring."), ChatType.GAME_INFO, player.m_142081_());
                        }
                    }
                    if (player.m_150110_().f_35936_ && player.m_150110_().f_35935_ && ExperienceUtils.getPlayerXP(player) > (Integer)Configuration.XPCost.get() && (Integer)Configuration.XPCost.get() != 0 && ++i >= (Integer)Configuration.TicksPerDrain.get()) {
                        ExperienceUtils.addPlayerXP(player, -((Integer)Configuration.XPCost.get()).intValue());
                        i = 0;
                    }
                }
            }

            public boolean canEquip(String identifier, LivingEntity entityLivingBase) {
                return !CuriosApi.getCuriosHelper().findEquippedCurio(ItemRegistry.ItemRing, entityLivingBase).isPresent();
            }

            public void onEquipFromUse(SlotContext slotContext) {
                slotContext.entity().m_5496_(SoundEvents.f_11674_, 1.0f, 1.0f);
            }

            public boolean showAttributesTooltip(String identifier) {
                return true;
            }
        };
        return new ICapabilityProvider(){
            private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
            }
        };
    }

    public static boolean isRingInCuriosSlot(ItemStack angelRing, LivingEntity player) {
        return CuriosApi.getCuriosHelper().findEquippedCurio(angelRing.m_41720_(), player).isPresent();
    }
}

