/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.angelring.utils;

import net.minecraft.world.entity.player.Player;

public class ExperienceUtils {
    public static int getPlayerXP(Player player) {
        return (int)((float)ExperienceUtils.getExperienceForLevel(player.f_36078_) + player.f_36080_ * (float)player.m_36323_());
    }

    public static void addPlayerXP(Player player, int amount) {
        int experience;
        player.f_36079_ = experience = ExperienceUtils.getPlayerXP(player) + amount;
        player.f_36078_ = ExperienceUtils.getLevelForExperience(experience);
        int expForLevel = ExperienceUtils.getExperienceForLevel(player.f_36078_);
        player.f_36080_ = (float)(experience - expForLevel) / (float)player.m_36323_();
    }

    public static int xpBarCap(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    private static int sum(int n, int a0, int d) {
        return n * (2 * a0 + (n - 1) * d) / 2;
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level <= 15) {
            return ExperienceUtils.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315 + ExperienceUtils.sum(level - 15, 37, 5);
        }
        return 1395 + ExperienceUtils.sum(level - 30, 112, 9);
    }

    public static int getLevelForExperience(int targetXp) {
        int level = 0;
        int xpToNextLevel;
        while (targetXp >= (xpToNextLevel = ExperienceUtils.xpBarCap(level))) {
            ++level;
            targetXp -= xpToNextLevel;
        }
        return level;
    }

    public static float calculateStoredLevels(int storedXP) {
        float storedLevels = 0.0f;
        int xp = storedXP;
        while (xp > 0) {
            int xpToNextLevel = ExperienceUtils.xpBarCap((int)storedLevels);
            if (xp < xpToNextLevel) {
                storedLevels += (float)xp / (float)xpToNextLevel;
                break;
            }
            xp -= xpToNextLevel;
            storedLevels += 1.0f;
        }
        return storedLevels;
    }

    public static int getXPToNextLevel(int currentXP) {
        int level = ExperienceUtils.getLevelForExperience(currentXP);
        int nextLevelXP = ExperienceUtils.getExperienceForLevel(level + 1);
        return nextLevelXP - currentXP;
    }

    public static void decreaseXP(Player player, float amount) {
        if ((float)player.f_36079_ - amount <= 0.0f) {
            player.f_36078_ = 0;
            player.f_36080_ = 0.0f;
            player.f_36079_ = 0;
            return;
        }
        player.f_36079_ = (int)((float)player.f_36079_ - amount);
        if (player.f_36080_ * (float)ExperienceUtils.xpBarCap(player.f_36078_) <= amount) {
            amount -= player.f_36080_ * (float)ExperienceUtils.xpBarCap(player.f_36078_);
            player.f_36080_ = 1.0f;
            --player.f_36078_;
        }
        while ((float)ExperienceUtils.xpBarCap(player.f_36078_) < amount) {
            amount -= (float)ExperienceUtils.xpBarCap(player.f_36078_);
            --player.f_36078_;
        }
        player.f_36080_ -= amount / (float)ExperienceUtils.xpBarCap(player.f_36078_);
    }
}

