/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.block;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WoodButtonBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.HitResult;
import snownee.kiwi.block.IKiwiBlock;
import snownee.kiwi.block.entity.BaseBlockEntity;
import snownee.kiwi.mixin.BlockAccessor;
import snownee.kiwi.util.VanillaActions;

public class ModBlock
extends Block
implements IKiwiBlock {
    public ModBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    public static SoundType deduceSoundType(Material material) {
        if (material == Material.f_76320_ || material == Material.f_76285_) {
            return SoundType.f_56736_;
        }
        if (material == Material.f_76314_ || material == Material.f_76313_) {
            return SoundType.f_56739_;
        }
        if (material == Material.f_76300_ || material == Material.f_76315_ || material == Material.f_76302_ || material == Material.f_76274_ || material == Material.f_76318_ || material == Material.f_76273_) {
            return SoundType.f_56740_;
        }
        if (material == Material.f_76304_ || material == Material.f_76301_) {
            return SoundType.f_56752_;
        }
        if (material == Material.f_76279_) {
            return SoundType.f_56743_;
        }
        if (material == Material.f_76275_ || material == Material.f_76298_ || material == Material.f_76276_ || material == Material.f_76316_ || material == Material.f_76312_) {
            return SoundType.f_56744_;
        }
        if (material == Material.f_76272_ || material == Material.f_76299_ || material == Material.f_76277_ || material == Material.f_76287_ || material == Material.f_76309_) {
            return SoundType.f_56745_;
        }
        if (material == Material.f_76317_) {
            return SoundType.f_56746_;
        }
        if (material == Material.f_76280_ || material == Material.f_76308_) {
            return SoundType.f_56747_;
        }
        if (material == Material.f_76281_) {
            return SoundType.f_56749_;
        }
        return SoundType.f_56742_;
    }

    public static float deduceHardness(Material material) {
        if (material == Material.f_76300_ || material == Material.f_76296_ || material == Material.f_76309_) {
            return 0.0f;
        }
        if (material == Material.f_76278_) {
            return 2.5f;
        }
        if (material == Material.f_76320_) {
            return 2.0f;
        }
        if (material == Material.f_76315_) {
            return 0.6f;
        }
        if (material == Material.f_76317_ || material == Material.f_76314_ || material == Material.f_76313_) {
            return 0.5f;
        }
        if (material == Material.f_76275_) {
            return 0.3f;
        }
        if (material == Material.f_76277_) {
            return 0.4f;
        }
        if (material == Material.f_76279_ || material == Material.f_76281_) {
            return 5.0f;
        }
        if (material == Material.f_76311_) {
            return 4.0f;
        }
        if (material == Material.f_76272_) {
            return 0.8f;
        }
        if (material == Material.f_76305_ || material == Material.f_76307_) {
            return 100.0f;
        }
        return 1.0f;
    }

    public static ItemStack pick(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack stack = state.m_60734_().m_7397_(world, pos, state);
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof BaseBlockEntity && !tile.m_6326_() && ((BaseBlockEntity)tile).persistData) {
            CompoundTag data = tile.m_187480_();
            data.m_128473_("x");
            data.m_128473_("y");
            data.m_128473_("z");
            BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)tile.m_58903_(), (CompoundTag)data);
        }
        return stack;
    }

    public static void setFireInfo(Block block) {
        Material material = ((BlockAccessor)block).getMaterial();
        int fireSpreadSpeed = 0;
        int flammability = 0;
        if (material == Material.f_76320_) {
            if (!(block instanceof DoorBlock || block instanceof TrapDoorBlock || block instanceof WoodButtonBlock || block instanceof PressurePlateBlock)) {
                fireSpreadSpeed = 5;
                flammability = 20;
            }
        } else if (material == Material.f_76300_ || material == Material.f_76302_) {
            if (!(block instanceof SaplingBlock)) {
                fireSpreadSpeed = 30;
                flammability = 100;
            }
        } else if (material == Material.f_76299_) {
            fireSpreadSpeed = 60;
            flammability = 20;
        } else if (material == Material.f_76274_) {
            fireSpreadSpeed = 30;
            flammability = 60;
        } else if (material == Material.f_76272_) {
            fireSpreadSpeed = 30;
            flammability = 60;
        }
        if (fireSpreadSpeed != 0) {
            VanillaActions.setFireInfo(block, fireSpreadSpeed, flammability);
        }
    }
}

