/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.contributor;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.Calendar;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiClientConfig;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.config.ConfigHandler;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.contributor.ITierProvider;
import snownee.kiwi.contributor.client.CosmeticLayer;
import snownee.kiwi.contributor.client.gui.CosmeticScreen;
import snownee.kiwi.contributor.impl.KiwiTierProvider;
import snownee.kiwi.contributor.network.CSetCosmeticPacket;
import snownee.kiwi.contributor.network.SSyncCosmeticPacket;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.util.Util;

@KiwiModule(value="contributors")
@KiwiModule.Subscriber
public class Contributors
extends AbstractModule {
    public static final Map<String, ITierProvider> REWARD_PROVIDERS = Maps.newConcurrentMap();
    public static final Map<String, ResourceLocation> PLAYER_COSMETICS = Maps.newConcurrentMap();
    private static final Set<ResourceLocation> RENDERABLES = Sets.newLinkedHashSet();
    private static int DAY = Calendar.getInstance().get(5);
    private int hold;

    @Override
    protected void preInit() {
        if (Platform.isPhysicalClient()) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::addLayers);
        }
    }

    @Override
    protected void init(InitEvent event) {
        Contributors.registerTierProvider(new KiwiTierProvider());
    }

    public static boolean isContributor(String author, String playerName) {
        return REWARD_PROVIDERS.getOrDefault(author.toLowerCase(Locale.ENGLISH), ITierProvider.Empty.INSTANCE).isContributor(playerName);
    }

    public static boolean isContributor(String author, String playerName, String tier) {
        return REWARD_PROVIDERS.getOrDefault(author.toLowerCase(Locale.ENGLISH), ITierProvider.Empty.INSTANCE).isContributor(playerName, tier);
    }

    public static boolean isContributor(String author, Player player) {
        return Contributors.isContributor(author, player.m_36316_().getName());
    }

    public static boolean isContributor(String author, Player player, String tier) {
        return Contributors.isContributor(author, player.m_36316_().getName(), tier);
    }

    public static Set<ResourceLocation> getPlayerTiers(String playerName) {
        return REWARD_PROVIDERS.values().stream().flatMap(tp -> tp.getPlayerTiers(playerName).stream().map(s -> new ResourceLocation(tp.getAuthor().toLowerCase(Locale.ENGLISH), s))).collect(Collectors.toSet());
    }

    public static Set<ResourceLocation> getTiers() {
        return REWARD_PROVIDERS.values().stream().flatMap(tp -> tp.getTiers().stream().map(s -> new ResourceLocation(tp.getAuthor().toLowerCase(Locale.ENGLISH), s))).collect(Collectors.toSet());
    }

    public static void registerTierProvider(ITierProvider rewardProvider) {
        String namespace = rewardProvider.getAuthor().toLowerCase(Locale.ENGLISH);
        REWARD_PROVIDERS.put(namespace, rewardProvider);
        for (String tier : rewardProvider.getRenderableTiers()) {
            RENDERABLES.add(new ResourceLocation(namespace, tier));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.getEntity().f_19853_ instanceof ServerLevel)) {
            return;
        }
        Player player = event.getPlayer();
        if (!((ServerLevel)event.getEntity().f_19853_).m_142572_().m_7779_(player.m_36316_())) {
            SSyncCosmeticPacket.send(PLAYER_COSMETICS, (ServerPlayer)player, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientPlayerLoggedIn(ClientPlayerNetworkEvent.LoggedInEvent event) {
        Contributors.changeCosmetic();
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        PLAYER_COSMETICS.remove(event.getPlayer().m_36316_().getName());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientPlayerLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        PLAYER_COSMETICS.clear();
        CosmeticLayer.ALL_LAYERS.forEach(l -> l.getCache().invalidateAll());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addLayers(EntityRenderersEvent.AddLayers event) {
        for (String name : event.getSkins()) {
            LivingEntityRenderer o = event.getSkin(name);
            CosmeticLayer layer = new CosmeticLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)o);
            CosmeticLayer.ALL_LAYERS.add(layer);
            o.m_115326_((RenderLayer)layer);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void changeCosmetic() {
        ResourceLocation id = Util.RL(KiwiClientConfig.contributorCosmetic);
        if (id != null && id.m_135815_().isEmpty()) {
            id = null;
        }
        ResourceLocation cosmetic = id;
        Contributors.canPlayerUseCosmetic(Contributors.getPlayerName(), cosmetic).thenAccept(bl -> {
            if (!bl.booleanValue()) {
                ConfigHandler cfg = KiwiConfigManager.getHandler(KiwiClientConfig.class);
                ForgeConfigSpec.ConfigValue<?> val = cfg.getValueByPath("contributorEffect");
                val.set((Object)"");
                cfg.refresh();
                return;
            }
            CSetCosmeticPacket.send(cosmetic);
            if (cosmetic == null) {
                PLAYER_COSMETICS.remove(Contributors.getPlayerName());
            } else {
                PLAYER_COSMETICS.put(Contributors.getPlayerName(), cosmetic);
                Kiwi.logger.info("Enabled contributor effect: {}", (Object)cosmetic);
            }
            CosmeticLayer.ALL_LAYERS.forEach(l -> l.getCache().invalidate((Object)Contributors.getPlayerName()));
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void changeCosmetic(Map<String, ResourceLocation> changes) {
        changes.forEach((k, v) -> {
            if (v == null) {
                PLAYER_COSMETICS.remove(k);
            } else {
                PLAYER_COSMETICS.put((String)k, (ResourceLocation)v);
            }
        });
        CosmeticLayer.ALL_LAYERS.forEach(l -> l.getCache().invalidateAll(changes.keySet()));
    }

    public static void changeCosmetic(ServerPlayer player, ResourceLocation cosmetic) {
        String playerName = player.m_36316_().getName();
        Contributors.canPlayerUseCosmetic(playerName, cosmetic).thenAccept(bl -> {
            if (bl.booleanValue()) {
                if (cosmetic == null) {
                    PLAYER_COSMETICS.remove(playerName);
                } else {
                    PLAYER_COSMETICS.put(playerName, cosmetic);
                }
                SSyncCosmeticPacket.send((Map<String, ResourceLocation>)ImmutableMap.of((Object)playerName, (Object)cosmetic), player, true);
            }
        });
    }

    public static boolean isRenderable(ResourceLocation id) {
        Contributors.refreshRenderables();
        return RENDERABLES.contains(id);
    }

    public static Set<ResourceLocation> getRenderableTiers() {
        Contributors.refreshRenderables();
        return Collections.unmodifiableSet(RENDERABLES);
    }

    private static void refreshRenderables() {
        int current = Calendar.getInstance().get(5);
        if (current != DAY) {
            DAY = current;
            RENDERABLES.clear();
            for (Map.Entry<String, ITierProvider> entry : REWARD_PROVIDERS.entrySet()) {
                String namespace = entry.getKey();
                for (String tier : entry.getValue().getRenderableTiers()) {
                    RENDERABLES.add(new ResourceLocation(namespace, tier));
                }
            }
        }
    }

    public static CompletableFuture<Boolean> canPlayerUseCosmetic(String playerName, ResourceLocation cosmetic) {
        if (cosmetic == null || cosmetic.m_135815_().isEmpty()) {
            return CompletableFuture.completedFuture(Boolean.TRUE);
        }
        if (!Contributors.isRenderable(cosmetic)) {
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
        ITierProvider provider = REWARD_PROVIDERS.getOrDefault(cosmetic.m_135827_().toLowerCase(Locale.ENGLISH), ITierProvider.Empty.INSTANCE);
        if (!provider.isContributor(playerName, cosmetic.m_135815_())) {
            if (!Platform.isPhysicalClient()) {
                return provider.refresh().thenApply($ -> provider.isContributor(playerName, cosmetic.m_135815_()));
            }
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
        return CompletableFuture.completedFuture(Boolean.TRUE);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static String getPlayerName() {
        return Minecraft.m_91087_().m_91094_().m_92546_();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null || mc.f_91074_ == null || !mc.m_91302_()) {
            return;
        }
        if (event.getModifiers() != 0) {
            return;
        }
        InputConstants.Key input = InputConstants.m_84827_((int)event.getKey(), (int)event.getScanCode());
        if (input.m_84873_() != 75) {
            return;
        }
        if (event.getAction() != 2) {
            this.hold = 0;
        } else if (++this.hold == 30) {
            CosmeticScreen screen = new CosmeticScreen();
            mc.m_91152_((Screen)screen);
        }
    }
}

