/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.data.provider;

import com.google.common.collect.BiMap;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.UpgradeRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class KiwiRecipeProvider
implements DataProvider {
    protected static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator generator;

    public KiwiRecipeProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(HashCache hashCache) throws IOException {
        Path path = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        this.addRecipes(recipe -> {
            if (!set.add(recipe.m_6445_())) {
                throw new IllegalStateException("Duplicate recipe " + recipe.m_6445_());
            }
            this.save(hashCache, recipe.m_125966_(), path.resolve("data/" + recipe.m_6445_().m_135827_() + "/recipes/" + recipe.m_6445_().m_135815_() + ".json"));
            JsonObject jsonobject = recipe.m_5860_();
            if (jsonobject != null) {
                this.save(hashCache, jsonobject, path.resolve("data/" + recipe.m_6445_().m_135827_() + "/advancements/" + recipe.m_6448_().m_135815_() + ".json"));
            }
        });
    }

    protected abstract void addRecipes(Consumer<FinishedRecipe> var1);

    protected void save(HashCache hashCache, JsonObject json, Path path) {
        try {
            String s = GSON.toJson((JsonElement)json);
            String s1 = f_123918_.hashUnencodedChars((CharSequence)s).toString();
            if (!Objects.equals(hashCache.m_123938_(path), s1) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                    bufferedwriter.write(s);
                }
            }
            hashCache.m_123940_(path, s1);
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't save recipe {}", (Object)path, (Object)ioexception);
        }
    }

    public String m_6055_() {
        return this.getClass().getSimpleName();
    }

    public static void oneToOneConversionRecipe(Consumer<FinishedRecipe> collector, ItemLike to, ItemLike from, @Nullable String group) {
        KiwiRecipeProvider.oneToOneConversionRecipe(collector, to, from, group, 1);
    }

    public static void oneToOneConversionRecipe(Consumer<FinishedRecipe> collector, ItemLike to, ItemLike from, @Nullable String group, int count) {
        ShapelessRecipeBuilder.m_126191_((ItemLike)to, (int)count).m_126209_(from).m_142409_(group).m_142284_(KiwiRecipeProvider.getHasName(from), (CriterionTriggerInstance)KiwiRecipeProvider.has(from)).m_176500_(collector, KiwiRecipeProvider.getConversionRecipeName(to, from));
    }

    public static void oreSmelting(Consumer<FinishedRecipe> p_176592_, List<ItemLike> p_176593_, ItemLike p_176594_, float p_176595_, int p_176596_, String p_176597_) {
        KiwiRecipeProvider.oreCooking(p_176592_, RecipeSerializer.f_44091_, p_176593_, p_176594_, p_176595_, p_176596_, p_176597_, "_from_smelting");
    }

    public static void oreBlasting(Consumer<FinishedRecipe> p_176626_, List<ItemLike> p_176627_, ItemLike p_176628_, float p_176629_, int p_176630_, String p_176631_) {
        KiwiRecipeProvider.oreCooking(p_176626_, RecipeSerializer.f_44092_, p_176627_, p_176628_, p_176629_, p_176630_, p_176631_, "_from_blasting");
    }

    public static void oreCooking(Consumer<FinishedRecipe> p_176534_, SimpleCookingSerializer<?> p_176535_, List<ItemLike> p_176536_, ItemLike p_176537_, float p_176538_, int p_176539_, String p_176540_, String p_176541_) {
        for (ItemLike itemlike : p_176536_) {
            SimpleCookingRecipeBuilder.m_126248_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemlike}), (ItemLike)p_176537_, (float)p_176538_, (int)p_176539_, p_176535_).m_142409_(p_176540_).m_142284_(KiwiRecipeProvider.getHasName(itemlike), (CriterionTriggerInstance)KiwiRecipeProvider.has(itemlike)).m_176500_(p_176534_, KiwiRecipeProvider.getItemName(p_176537_) + p_176541_ + "_" + KiwiRecipeProvider.getItemName(itemlike));
        }
    }

    public static void netheriteSmithing(Consumer<FinishedRecipe> p_125995_, Item p_125996_, Item p_125997_) {
        UpgradeRecipeBuilder.m_126385_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{p_125996_}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_}), (Item)p_125997_).m_126389_("has_netherite_ingot", (CriterionTriggerInstance)KiwiRecipeProvider.has((ItemLike)Items.f_42418_)).m_126392_(p_125995_, KiwiRecipeProvider.getItemName((ItemLike)p_125997_) + "_smithing");
    }

    public static void planksFromLog(Consumer<FinishedRecipe> p_125999_, ItemLike p_126000_, Tag<Item> p_126001_) {
        ShapelessRecipeBuilder.m_126191_((ItemLike)p_126000_, (int)4).m_126182_(p_126001_).m_142409_("planks").m_142284_("has_log", (CriterionTriggerInstance)KiwiRecipeProvider.has(p_126001_)).m_176498_(p_125999_);
    }

    public static void planksFromLogs(Consumer<FinishedRecipe> p_126018_, ItemLike p_126019_, Tag<Item> p_126020_) {
        ShapelessRecipeBuilder.m_126191_((ItemLike)p_126019_, (int)4).m_126182_(p_126020_).m_142409_("planks").m_142284_("has_logs", (CriterionTriggerInstance)KiwiRecipeProvider.has(p_126020_)).m_176498_(p_126018_);
    }

    public static void woodFromLogs(Consumer<FinishedRecipe> p_126003_, ItemLike p_126004_, ItemLike p_126005_) {
        ShapedRecipeBuilder.m_126118_((ItemLike)p_126004_, (int)3).m_126127_(Character.valueOf('#'), p_126005_).m_126130_("##").m_126130_("##").m_142409_("bark").m_142284_("has_log", (CriterionTriggerInstance)KiwiRecipeProvider.has(p_126005_)).m_176498_(p_126003_);
    }

    public static void woodenBoat(Consumer<FinishedRecipe> p_126022_, ItemLike p_126023_, ItemLike p_126024_) {
        ShapedRecipeBuilder.m_126116_((ItemLike)p_126023_).m_126127_(Character.valueOf('#'), p_126024_).m_126130_("# #").m_126130_("###").m_142409_("boat").m_142284_("in_water", (CriterionTriggerInstance)KiwiRecipeProvider.insideOf(Blocks.f_49990_)).m_176498_(p_126022_);
    }

    public static RecipeBuilder buttonBuilder(ItemLike p_176659_, Ingredient p_176660_) {
        return ShapelessRecipeBuilder.m_126189_((ItemLike)p_176659_).m_126184_(p_176660_);
    }

    public static RecipeBuilder doorBuilder(ItemLike p_176671_, Ingredient p_176672_) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)p_176671_, (int)3).m_126124_(Character.valueOf('#'), p_176672_).m_126130_("##").m_126130_("##").m_126130_("##");
    }

    public static RecipeBuilder fenceBuilder(ItemLike p_176679_, Ingredient p_176680_) {
        int i = p_176679_ == Blocks.f_50198_ ? 6 : 3;
        Item item = p_176679_ == Blocks.f_50198_ ? Items.f_42691_ : Items.f_42398_;
        return ShapedRecipeBuilder.m_126118_((ItemLike)p_176679_, (int)i).m_126124_(Character.valueOf('W'), p_176680_).m_126127_(Character.valueOf('#'), (ItemLike)item).m_126130_("W#W").m_126130_("W#W");
    }

    public static RecipeBuilder fenceGateBuilder(ItemLike p_176685_, Ingredient p_176686_) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)p_176685_).m_126127_(Character.valueOf('#'), (ItemLike)Items.f_42398_).m_126124_(Character.valueOf('W'), p_176686_).m_126130_("#W#").m_126130_("#W#");
    }

    public static void pressurePlate(Consumer<FinishedRecipe> p_176691_, ItemLike p_176692_, ItemLike p_176693_) {
        KiwiRecipeProvider.pressurePlateBuilder(p_176692_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{p_176693_})).m_142284_(KiwiRecipeProvider.getHasName(p_176693_), (CriterionTriggerInstance)KiwiRecipeProvider.has(p_176693_)).m_176498_(p_176691_);
    }

    public static RecipeBuilder pressurePlateBuilder(ItemLike p_176695_, Ingredient p_176696_) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)p_176695_).m_126124_(Character.valueOf('#'), p_176696_).m_126130_("##");
    }

    public static void slab(Consumer<FinishedRecipe> p_176701_, ItemLike p_176702_, ItemLike p_176703_) {
        KiwiRecipeProvider.slabBuilder(p_176702_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{p_176703_})).m_142284_(KiwiRecipeProvider.getHasName(p_176703_), (CriterionTriggerInstance)KiwiRecipeProvider.has(p_176703_)).m_176498_(p_176701_);
    }

    public static RecipeBuilder slabBuilder(ItemLike p_176705_, Ingredient p_176706_) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)p_176705_, (int)6).m_126124_(Character.valueOf('#'), p_176706_).m_126130_("###");
    }

    public static RecipeBuilder stairBuilder(ItemLike p_176711_, Ingredient p_176712_) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)p_176711_, (int)4).m_126124_(Character.valueOf('#'), p_176712_).m_126130_("#  ").m_126130_("## ").m_126130_("###");
    }

    public static RecipeBuilder trapdoorBuilder(ItemLike p_176721_, Ingredient p_176722_) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)p_176721_, (int)2).m_126124_(Character.valueOf('#'), p_176722_).m_126130_("###").m_126130_("###");
    }

    public static RecipeBuilder signBuilder(ItemLike p_176727_, Ingredient p_176728_) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)p_176727_, (int)3).m_142409_("sign").m_126124_(Character.valueOf('#'), p_176728_).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_42398_).m_126130_("###").m_126130_("###").m_126130_(" X ");
    }

    public static void wall(Consumer<FinishedRecipe> p_176613_, ItemLike p_176614_, ItemLike p_176615_) {
        KiwiRecipeProvider.wallBuilder(p_176614_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{p_176615_})).m_142284_(KiwiRecipeProvider.getHasName(p_176615_), (CriterionTriggerInstance)KiwiRecipeProvider.has(p_176615_)).m_176498_(p_176613_);
    }

    public static RecipeBuilder wallBuilder(ItemLike p_176515_, Ingredient p_176516_) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)p_176515_, (int)6).m_126124_(Character.valueOf('#'), p_176516_).m_126130_("###").m_126130_("###");
    }

    public static void polished(Consumer<FinishedRecipe> p_176641_, ItemLike p_176642_, ItemLike p_176643_) {
        KiwiRecipeProvider.polishedBuilder(p_176642_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{p_176643_})).m_142284_(KiwiRecipeProvider.getHasName(p_176643_), (CriterionTriggerInstance)KiwiRecipeProvider.has(p_176643_)).m_176498_(p_176641_);
    }

    public static RecipeBuilder polishedBuilder(ItemLike p_176605_, Ingredient p_176606_) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)p_176605_, (int)4).m_126124_(Character.valueOf('S'), p_176606_).m_126130_("SS").m_126130_("SS");
    }

    public static void cut(Consumer<FinishedRecipe> p_176653_, ItemLike p_176654_, ItemLike p_176655_) {
        KiwiRecipeProvider.cutBuilder(p_176654_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{p_176655_})).m_142284_(KiwiRecipeProvider.getHasName(p_176655_), (CriterionTriggerInstance)KiwiRecipeProvider.has(p_176655_)).m_176498_(p_176653_);
    }

    public static ShapedRecipeBuilder cutBuilder(ItemLike p_176635_, Ingredient p_176636_) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)p_176635_, (int)4).m_126124_(Character.valueOf('#'), p_176636_).m_126130_("##").m_126130_("##");
    }

    public static void chiseled(Consumer<FinishedRecipe> p_176665_, ItemLike p_176666_, ItemLike p_176667_) {
        KiwiRecipeProvider.chiseledBuilder(p_176666_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{p_176667_})).m_142284_(KiwiRecipeProvider.getHasName(p_176667_), (CriterionTriggerInstance)KiwiRecipeProvider.has(p_176667_)).m_176498_(p_176665_);
    }

    public static ShapedRecipeBuilder chiseledBuilder(ItemLike p_176647_, Ingredient p_176648_) {
        return ShapedRecipeBuilder.m_126116_((ItemLike)p_176647_).m_126124_(Character.valueOf('#'), p_176648_).m_126130_("#").m_126130_("#");
    }

    public static void stonecutterResultFromBase(Consumer<FinishedRecipe> p_176736_, ItemLike p_176737_, ItemLike p_176738_) {
        KiwiRecipeProvider.stonecutterResultFromBase(p_176736_, p_176737_, p_176738_, 1);
    }

    public static void stonecutterResultFromBase(Consumer<FinishedRecipe> p_176547_, ItemLike p_176548_, ItemLike p_176549_, int p_176550_) {
        SingleItemRecipeBuilder.m_126316_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{p_176549_}), (ItemLike)p_176548_, (int)p_176550_).m_142284_(KiwiRecipeProvider.getHasName(p_176549_), (CriterionTriggerInstance)KiwiRecipeProvider.has(p_176549_)).m_176500_(p_176547_, KiwiRecipeProvider.getConversionRecipeName(p_176548_, p_176549_) + "_stonecutting");
    }

    public static void smeltingResultFromBase(Consumer<FinishedRecipe> p_176740_, ItemLike p_176741_, ItemLike p_176742_) {
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{p_176742_}), (ItemLike)p_176741_, (float)0.1f, (int)200).m_142284_(KiwiRecipeProvider.getHasName(p_176742_), (CriterionTriggerInstance)KiwiRecipeProvider.has(p_176742_)).m_176498_(p_176740_);
    }

    public static void nineBlockStorageRecipes(Consumer<FinishedRecipe> p_176744_, ItemLike p_176745_, ItemLike p_176746_) {
        KiwiRecipeProvider.nineBlockStorageRecipes(p_176744_, p_176745_, p_176746_, KiwiRecipeProvider.getSimpleRecipeName(p_176746_), null, KiwiRecipeProvider.getSimpleRecipeName(p_176745_), null);
    }

    public static void nineBlockStorageRecipesWithCustomPacking(Consumer<FinishedRecipe> p_176563_, ItemLike p_176564_, ItemLike p_176565_, String p_176566_, String p_176567_) {
        KiwiRecipeProvider.nineBlockStorageRecipes(p_176563_, p_176564_, p_176565_, p_176566_, p_176567_, KiwiRecipeProvider.getSimpleRecipeName(p_176564_), null);
    }

    public static void nineBlockStorageRecipesRecipesWithCustomUnpacking(Consumer<FinishedRecipe> p_176617_, ItemLike p_176618_, ItemLike p_176619_, String p_176620_, String p_176621_) {
        KiwiRecipeProvider.nineBlockStorageRecipes(p_176617_, p_176618_, p_176619_, KiwiRecipeProvider.getSimpleRecipeName(p_176619_), null, p_176620_, p_176621_);
    }

    public static void nineBlockStorageRecipes(Consumer<FinishedRecipe> p_176569_, ItemLike p_176570_, ItemLike p_176571_, String p_176572_, @Nullable String p_176573_, String p_176574_, @Nullable String p_176575_) {
        ShapelessRecipeBuilder.m_126191_((ItemLike)p_176570_, (int)9).m_126209_(p_176571_).m_142409_(p_176575_).m_142284_(KiwiRecipeProvider.getHasName(p_176571_), (CriterionTriggerInstance)KiwiRecipeProvider.has(p_176571_)).m_142700_(p_176569_, new ResourceLocation(p_176574_));
        ShapedRecipeBuilder.m_126116_((ItemLike)p_176571_).m_126127_(Character.valueOf('#'), p_176570_).m_126130_("###").m_126130_("###").m_126130_("###").m_142409_(p_176573_).m_142284_(KiwiRecipeProvider.getHasName(p_176570_), (CriterionTriggerInstance)KiwiRecipeProvider.has(p_176570_)).m_142700_(p_176569_, new ResourceLocation(p_176572_));
    }

    public static void simpleCookingRecipe(Consumer<FinishedRecipe> p_176584_, String p_176585_, SimpleCookingSerializer<?> p_176586_, int p_176587_, ItemLike p_176588_, ItemLike p_176589_, float p_176590_) {
        SimpleCookingRecipeBuilder.m_126248_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{p_176588_}), (ItemLike)p_176589_, (float)p_176590_, (int)p_176587_, p_176586_).m_142284_(KiwiRecipeProvider.getHasName(p_176588_), (CriterionTriggerInstance)KiwiRecipeProvider.has(p_176588_)).m_176500_(p_176584_, KiwiRecipeProvider.getItemName(p_176589_) + "_from_" + p_176585_);
    }

    public static void waxRecipes(Consumer<FinishedRecipe> p_176611_) {
        ((BiMap)HoneycombItem.f_150863_.get()).forEach((p_176578_, p_176579_) -> ShapelessRecipeBuilder.m_126189_((ItemLike)p_176579_).m_126209_((ItemLike)p_176578_).m_126209_((ItemLike)Items.f_42784_).m_142409_(KiwiRecipeProvider.getItemName((ItemLike)p_176579_)).m_142284_(KiwiRecipeProvider.getHasName((ItemLike)p_176578_), (CriterionTriggerInstance)KiwiRecipeProvider.has((ItemLike)p_176578_)).m_176500_(p_176611_, KiwiRecipeProvider.getConversionRecipeName((ItemLike)p_176579_, (ItemLike)Items.f_42784_)));
    }

    protected static EnterBlockTrigger.TriggerInstance insideOf(Block p_125980_) {
        return new EnterBlockTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, p_125980_, StatePropertiesPredicate.f_67658_);
    }

    public static InventoryChangeTrigger.TriggerInstance has(MinMaxBounds.Ints p_176521_, ItemLike p_176522_) {
        return KiwiRecipeProvider.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{p_176522_}).m_151443_(p_176521_).m_45077_());
    }

    protected static InventoryChangeTrigger.TriggerInstance has(ItemLike p_125978_) {
        return KiwiRecipeProvider.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{p_125978_}).m_45077_());
    }

    protected static InventoryChangeTrigger.TriggerInstance has(Tag<Item> p_125976_) {
        return KiwiRecipeProvider.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_45069_(p_125976_).m_45077_());
    }

    protected static InventoryChangeTrigger.TriggerInstance inventoryTrigger(ItemPredicate ... p_126012_) {
        return new InventoryChangeTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, p_126012_);
    }

    public static String getHasName(ItemLike p_176603_) {
        return "has_" + KiwiRecipeProvider.getItemName(p_176603_);
    }

    public static String getItemName(ItemLike p_176633_) {
        return Registry.f_122827_.m_7981_((Object)p_176633_.m_5456_()).m_135815_();
    }

    public static String getSimpleRecipeName(ItemLike p_176645_) {
        return KiwiRecipeProvider.getItemName(p_176645_);
    }

    public static String getConversionRecipeName(ItemLike p_176518_, ItemLike p_176519_) {
        return KiwiRecipeProvider.getItemName(p_176518_) + "_from_" + KiwiRecipeProvider.getItemName(p_176519_);
    }

    public static String getSmeltingRecipeName(ItemLike p_176657_) {
        return KiwiRecipeProvider.getItemName(p_176657_) + "_from_smelting";
    }

    public static String getBlastingRecipeName(ItemLike p_176669_) {
        return KiwiRecipeProvider.getItemName(p_176669_) + "_from_blasting";
    }
}

