/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import snownee.kiwi.Kiwi;

public enum AlternativesIngredientSerializer implements IIngredientSerializer<Ingredient>
{
    INSTANCE;

    private static Constructor<CompoundIngredient> constructor;

    public Ingredient parse(JsonObject json) {
        JsonArray list = GsonHelper.m_13933_((JsonObject)json, (String)"list");
        ArrayList ingredients = Lists.newArrayList();
        for (JsonElement e : list) {
            if (e.isJsonArray()) {
                JsonArray a = e.getAsJsonArray();
                if (a.size() == 0) {
                    return Ingredient.f_43901_;
                }
                for (JsonElement e2 : a) {
                    try {
                        ingredients.add(AlternativesIngredientSerializer.getIngredient(e2));
                    }
                    catch (Exception exception) {}
                }
            } else {
                try {
                    ingredients.add(AlternativesIngredientSerializer.getIngredient(e));
                }
                catch (Exception a) {
                    // empty catch block
                }
            }
            if (ingredients.isEmpty()) continue;
            if (ingredients.size() == 1) {
                return (Ingredient)ingredients.get(0);
            }
            try {
                return (Ingredient)constructor.newInstance(ingredients);
            }
            catch (Exception e1) {
                break;
            }
        }
        throw new JsonSyntaxException("Mismatched");
    }

    public static Ingredient getIngredient(JsonElement e) {
        ItemStack[] stacks;
        Ingredient ingredient = CraftingHelper.getIngredient((JsonElement)e);
        if (ingredient.m_43947_()) {
            throw new JsonSyntaxException("hasNoMatchingItems");
        }
        if (!((Boolean)ForgeConfig.SERVER.treatEmptyTagsAsAir.get()).booleanValue() && (stacks = ingredient.m_43908_()).length == 1 && stacks[0].m_41720_() == Items.f_42127_) {
            throw new JsonSyntaxException("hasNoMatchingItems");
        }
        return ingredient;
    }

    public Ingredient parse(FriendlyByteBuf buffer) {
        throw new IllegalStateException();
    }

    public void write(FriendlyByteBuf buffer, Ingredient ingredient) {
        throw new IllegalStateException();
    }

    static {
        try {
            constructor = CompoundIngredient.class.getDeclaredConstructor(List.class);
            constructor.setAccessible(true);
        }
        catch (Exception e) {
            Kiwi.logger.catching((Throwable)e);
        }
    }
}

