/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.framework.widgets;

import com.davenonymous.libnonymous.gui.framework.widgets.WidgetWithChoiceValue;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.GuiUtils;

public class WidgetSpriteSelect<T>
extends WidgetWithChoiceValue<T> {
    Map<T, SpriteData> spriteMap;

    public WidgetSpriteSelect() {
        this.setHeight(16);
        this.setWidth(16);
        this.spriteMap = new HashMap<T, SpriteData>();
        this.addClickListener();
    }

    public void mapChoiceToSprite(T choice, SpriteData sprite) {
        this.spriteMap.put(choice, sprite);
    }

    public void addChoiceWithSprite(T choice, SpriteData sprite) {
        this.addChoice(choice);
        this.mapChoiceToSprite(choice, sprite);
    }

    @Override
    public void draw(PoseStack pPoseStack, Screen screen) {
        SpriteData sprite = this.spriteMap.get(this.getValue());
        if (sprite == null) {
            return;
        }
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)sprite.sprite);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xOffset = (this.width - sprite.width) / 2;
        int yOffset = (this.height - sprite.height) / 2;
        GuiUtils.drawTexturedModalRect((PoseStack)pPoseStack, (int)xOffset, (int)yOffset, (int)sprite.u, (int)sprite.v, (int)sprite.width, (int)sprite.height, (float)10.0f);
    }

    public record SpriteData(ResourceLocation sprite, int u, int v, int width, int height) {
    }
}

