/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.crafting.recipe;

import com.google.gson.JsonObject;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class ExtendedShapedRecipe
extends ShapedRecipe {
    private static final RecipeSerializer<ShapedRecipe> BASE_SERIALIZER = RecipeSerializer.f_44076_;
    private final ShapedRecipe recipe;

    public ExtendedShapedRecipe(ShapedRecipe recipe) {
        super(recipe.m_6423_(), recipe.m_6076_(), recipe.getRecipeWidth(), recipe.getRecipeHeight(), recipe.m_7527_(), recipe.m_8043_());
        this.recipe = recipe;
    }

    public ShapedRecipe getBaseRecipe() {
        return this.recipe;
    }

    public abstract RecipeSerializer<?> m_7707_();

    public abstract boolean m_5818_(CraftingContainer var1, Level var2);

    public abstract ItemStack m_5874_(CraftingContainer var1);

    public static class Serializer<T extends ExtendedShapedRecipe>
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<T> {
        private final Function<ShapedRecipe, T> recipeFactory;
        @Nullable
        private final BiConsumer<JsonObject, T> readJson;
        @Nullable
        private final BiConsumer<FriendlyByteBuf, T> readBuffer;
        @Nullable
        private final BiConsumer<FriendlyByteBuf, T> writeBuffer;

        public Serializer(Function<ShapedRecipe, T> recipeFactory, @Nullable BiConsumer<JsonObject, T> readJson, @Nullable BiConsumer<FriendlyByteBuf, T> readBuffer, @Nullable BiConsumer<FriendlyByteBuf, T> writeBuffer) {
            this.recipeFactory = recipeFactory;
            this.readJson = readJson;
            this.readBuffer = readBuffer;
            this.writeBuffer = writeBuffer;
        }

        public static <S extends ExtendedShapedRecipe> Serializer<S> basic(Function<ShapedRecipe, S> recipeFactory) {
            return new Serializer<S>(recipeFactory, null, null, null);
        }

        @Deprecated
        public static <S extends ExtendedShapedRecipe> Serializer<S> basic(ResourceLocation serializerId, Function<ShapedRecipe, S> recipeFactory) {
            return new Serializer<S>(recipeFactory, null, null, null);
        }

        public T fromJson(ResourceLocation recipeId, JsonObject json) {
            ShapedRecipe recipe = (ShapedRecipe)BASE_SERIALIZER.m_6729_(recipeId, json);
            ExtendedShapedRecipe result = (ExtendedShapedRecipe)((Object)this.recipeFactory.apply(recipe));
            if (this.readJson != null) {
                this.readJson.accept(json, (JsonObject)result);
            }
            return (T)((Object)result);
        }

        public T fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ShapedRecipe recipe = (ShapedRecipe)BASE_SERIALIZER.m_8005_(recipeId, buffer);
            ExtendedShapedRecipe result = (ExtendedShapedRecipe)((Object)this.recipeFactory.apply(recipe));
            if (this.readBuffer != null) {
                this.readBuffer.accept(buffer, (FriendlyByteBuf)result);
            }
            return (T)((Object)result);
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            BASE_SERIALIZER.m_6178_(buffer, (Recipe)((ExtendedShapedRecipe)((Object)recipe)).getBaseRecipe());
            if (this.writeBuffer != null) {
                this.writeBuffer.accept(buffer, (FriendlyByteBuf)recipe);
            }
        }
    }
}

