/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.data.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.silentchaos512.lib.util.NameUtils;

public class ExtendedShapelessRecipeBuilder {
    private final RecipeSerializer<?> serializer;
    private final Collection<Consumer<JsonObject>> extraData = new ArrayList<Consumer<JsonObject>>();
    private final Item result;
    private final int count;
    private final List<Ingredient> ingredients = Lists.newArrayList();
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
    private boolean hasAdvancementCriterion = false;
    private String group = "";

    protected ExtendedShapelessRecipeBuilder(RecipeSerializer<?> serializer, ItemLike result, int count) {
        this.serializer = serializer;
        this.result = result.m_5456_();
        this.count = count;
    }

    public static ExtendedShapelessRecipeBuilder builder(RecipeSerializer<?> serializer, ItemLike result) {
        return ExtendedShapelessRecipeBuilder.builder(serializer, result, 1);
    }

    public static ExtendedShapelessRecipeBuilder builder(RecipeSerializer<?> serializer, ItemLike result, int count) {
        return new ExtendedShapelessRecipeBuilder(serializer, result, count);
    }

    public static ExtendedShapelessRecipeBuilder vanillaBuilder(ItemLike result) {
        return ExtendedShapelessRecipeBuilder.vanillaBuilder(result, 1);
    }

    public static ExtendedShapelessRecipeBuilder vanillaBuilder(ItemLike result, int count) {
        return new ExtendedShapelessRecipeBuilder(RecipeSerializer.f_44077_, result, count);
    }

    protected void serializeExtra(JsonObject json) {
        this.extraData.forEach(consumer -> consumer.accept(json));
    }

    public ExtendedShapelessRecipeBuilder addExtraData(Consumer<JsonObject> extraDataIn) {
        this.extraData.add(extraDataIn);
        return this;
    }

    public ExtendedShapelessRecipeBuilder addIngredient(Tag<Item> tag) {
        return this.addIngredient(tag, 1);
    }

    public ExtendedShapelessRecipeBuilder addIngredient(Tag<Item> tag, int quantity) {
        return this.addIngredient(Ingredient.m_43911_(tag), quantity);
    }

    public ExtendedShapelessRecipeBuilder addIngredient(ItemLike item) {
        return this.addIngredient(item, 1);
    }

    public ExtendedShapelessRecipeBuilder addIngredient(ItemLike item, int quantity) {
        return this.addIngredient(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), quantity);
    }

    public ExtendedShapelessRecipeBuilder addIngredient(Ingredient ingredient) {
        return this.addIngredient(ingredient, 1);
    }

    public ExtendedShapelessRecipeBuilder addIngredient(Ingredient ingredient, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public ExtendedShapelessRecipeBuilder addCriterion(String name, CriterionTriggerInstance criterion) {
        this.advancementBuilder.m_138386_(name, criterion);
        this.hasAdvancementCriterion = true;
        return this;
    }

    public ExtendedShapelessRecipeBuilder setGroup(String group) {
        this.group = group;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        this.build(consumer, NameUtils.from(this.result));
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        if (this.hasAdvancementCriterion && !this.advancementBuilder.m_138405_().isEmpty()) {
            this.advancementBuilder.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)new RecipeUnlockedTrigger.TriggerInstance(EntityPredicate.Composite.f_36667_, id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        }
        ResourceLocation advancementId = new ResourceLocation(id.m_135827_(), "recipes/" + this.result.m_41471_().m_40783_() + "/" + id.m_135815_());
        consumer.accept(new Result(id, this, advancementId));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final ExtendedShapelessRecipeBuilder builder;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, ExtendedShapelessRecipeBuilder builder, ResourceLocation advancementId) {
            this.id = id;
            this.builder = builder;
            this.advancementId = advancementId;
        }

        public void m_7917_(JsonObject json) {
            if (!this.builder.group.isEmpty()) {
                json.addProperty("group", this.builder.group);
            }
            JsonArray ingredients = new JsonArray();
            for (Ingredient ingredient : this.builder.ingredients) {
                ingredients.add(ingredient.m_43942_());
            }
            json.add("ingredients", (JsonElement)ingredients);
            JsonObject result = new JsonObject();
            result.addProperty("item", NameUtils.from(this.builder.result).toString());
            if (this.builder.count > 1) {
                result.addProperty("count", (Number)this.builder.count);
            }
            json.add("result", (JsonElement)result);
            this.builder.serializeExtra(json);
        }

        public RecipeSerializer<?> m_6637_() {
            return this.builder.serializer;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.builder.hasAdvancementCriterion ? this.builder.advancementBuilder.m_138400_() : null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.builder.hasAdvancementCriterion ? this.advancementId : null;
        }
    }
}

