/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.event;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.silentchaos512.lib.SilentLib;
import net.silentchaos512.lib.util.PlayerUtils;

@ParametersAreNonnullByDefault
public final class InitialSpawnItems {
    private static final InitialSpawnItems INSTANCE = new InitialSpawnItems();
    private static final String NBT_KEY = "silentlib.SpawnItemsGiven";
    private final Map<ResourceLocation, Function<Player, Collection<ItemStack>>> spawnItems = new HashMap<ResourceLocation, Function<Player, Collection<ItemStack>>>();

    private InitialSpawnItems() {
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerLoggedIn);
    }

    @Deprecated
    public static void add(ResourceLocation key, Supplier<ItemStack> stack) {
        InitialSpawnItems.INSTANCE.spawnItems.put(key, p -> {
            ItemStack s = (ItemStack)stack.get();
            return s.m_41619_() ? Collections.emptyList() : Collections.singleton(s);
        });
    }

    public static void add(ResourceLocation key, Function<Player, Collection<ItemStack>> itemFactory) {
        InitialSpawnItems.INSTANCE.spawnItems.put(key, itemFactory);
    }

    private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        CompoundTag givenItems = PlayerUtils.getPersistedDataSubcompound(player, NBT_KEY);
        this.spawnItems.forEach((key, factory) -> InitialSpawnItems.handleSpawnItems(player, givenItems, key, (Collection)factory.apply(player)));
    }

    private static void handleSpawnItems(Player player, CompoundTag givenItems, ResourceLocation key, Collection<ItemStack> items) {
        if (items.isEmpty()) {
            return;
        }
        String nbtKey = key.toString().replace(':', '.');
        if (!givenItems.m_128471_(nbtKey)) {
            items.forEach(stack -> {
                SilentLib.LOGGER.debug("Giving player {} spawn item \"{}\": {}", (Object)player.m_6302_(), (Object)nbtKey, stack);
                PlayerUtils.giveItem(player, stack);
                givenItems.m_128379_(nbtKey, true);
            });
        }
    }
}

