/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class NameUtils {
    private static final Pattern PATTERN = Pattern.compile("([a-z0-9._-]+:)?[a-z0-9/._-]+");

    private NameUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static boolean isValid(CharSequence name) {
        return PATTERN.matcher(name).matches();
    }

    public static ResourceLocation checkNotNull(@Nullable ResourceLocation name) {
        Preconditions.checkNotNull((Object)name, (Object)"Name is null, make sure the object has been registered correctly");
        return name;
    }

    public static ResourceLocation forgeId(String path) {
        return new ResourceLocation("forge", path);
    }

    public static ResourceLocation from(IForgeRegistryEntry<?> entry) {
        return NameUtils.checkNotNull(entry.getRegistryName());
    }

    public static ResourceLocation fromItem(ItemLike item) {
        Preconditions.checkNotNull((Object)item.m_5456_(), (Object)"asItem() is null, has object not been fully constructed?");
        return NameUtils.checkNotNull(item.m_5456_().getRegistryName());
    }

    public static ResourceLocation fromItem(ItemStack stack) {
        return NameUtils.checkNotNull(stack.m_41720_().getRegistryName());
    }
}

