/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;
import noobanidus.mods.lootr.api.LootFiller;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;

public class ChestData
extends SavedData {
    private String key;
    private BlockPos pos;
    private ResourceKey<Level> dimension;
    private UUID entityId;
    private UUID tileId;
    private UUID customId;
    private Map<UUID, SpecialChestInventory> inventories = new HashMap<UUID, SpecialChestInventory>();
    private NonNullList<ItemStack> reference;
    private boolean custom;

    protected ChestData(String key) {
        this.key = key;
    }

    public UUID getEntityId() {
        return this.entityId;
    }

    @Nullable
    public UUID getTileId() {
        if (this.entityId != null) {
            return this.entityId;
        }
        if (this.tileId != null) {
            return this.tileId;
        }
        if (this.customId != null) {
            return this.customId;
        }
        return null;
    }

    public static String REF_ID(ResourceKey<Level> dimension, UUID id) {
        return "Lootr-custom-" + dimension.m_135782_().m_135815_() + "-" + id.toString();
    }

    public static String OLD_ID(ResourceKey<Level> dimension, BlockPos pos) {
        return "Lootr-chests-" + dimension.m_135782_().m_135815_() + "-" + pos.m_121878_();
    }

    public static String ID(ResourceKey<Level> dimension, UUID id) {
        return "Lootr-chests-" + dimension.m_135782_().m_135815_() + "-" + id.toString();
    }

    public static String ENTITY(UUID entityId) {
        return "Lootr-entity-" + entityId.toString();
    }

    public static Supplier<ChestData> ref_id(ResourceKey<Level> dimension, UUID id, @Nullable UUID customId, @Nullable NonNullList<ItemStack> base) {
        return () -> {
            ChestData data = new ChestData(ChestData.REF_ID(dimension, id));
            data.pos = null;
            data.dimension = dimension;
            data.entityId = null;
            data.tileId = id;
            data.reference = base;
            data.custom = true;
            data.customId = customId;
            if (data.customId == null && data.reference == null) {
                throw new IllegalArgumentException("Both customId and inventory reference cannot be null.");
            }
            return data;
        };
    }

    public static Supplier<ChestData> id(ResourceKey<Level> dimension, UUID id) {
        return () -> {
            ChestData data = new ChestData(ChestData.ID(dimension, id));
            data.pos = null;
            data.dimension = dimension;
            data.entityId = null;
            data.tileId = id;
            data.reference = null;
            data.custom = false;
            data.customId = null;
            return data;
        };
    }

    public static Supplier<ChestData> entity(UUID entityId) {
        return () -> {
            ChestData data = new ChestData(ChestData.ENTITY(entityId));
            data.pos = null;
            data.dimension = null;
            data.tileId = null;
            data.entityId = entityId;
            data.reference = null;
            data.custom = false;
            data.customId = null;
            return data;
        };
    }

    public LootFiller customInventory() {
        return (player, inventory, table, seed) -> {
            for (int i = 0; i < this.reference.size(); ++i) {
                inventory.m_6836_(i, ((ItemStack)this.reference.get(i)).m_41777_());
            }
        };
    }

    public Map<UUID, SpecialChestInventory> getInventories() {
        return this.inventories;
    }

    public void setInventories(Map<UUID, SpecialChestInventory> inventories) {
        this.inventories = inventories;
    }

    public boolean clearInventory(UUID uuid) {
        return this.inventories.remove(uuid) != null;
    }

    @Nullable
    public SpecialChestInventory getInventory(ServerPlayer player, BlockPos pos) {
        SpecialChestInventory result = this.inventories.get(player.m_142081_());
        if (result != null) {
            result.setBlockPos(pos);
        }
        return result;
    }

    public SpecialChestInventory createInventory(ServerPlayer player, LootFiller filler, @Nullable RandomizableContainerBlockEntity tile) {
        SpecialChestInventory result;
        ServerLevel world = (ServerLevel)player.f_19853_;
        LootrChestMinecartEntity cart = null;
        long seed = -1L;
        ResourceLocation lootTable = null;
        if (this.entityId != null) {
            Entity initial = world.m_8791_(this.entityId);
            if (!(initial instanceof LootrChestMinecartEntity)) {
                return null;
            }
            cart = (LootrChestMinecartEntity)initial;
            NonNullList items = NonNullList.m_122780_((int)cart.m_6643_(), (Object)ItemStack.f_41583_);
            result = new SpecialChestInventory(this, (NonNullList<ItemStack>)items, cart.m_5446_(), this.pos);
            lootTable = cart.f_38204_;
        } else {
            if (world.m_46472_() != this.dimension) {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server == null) {
                    return null;
                }
                world = server.m_129880_(this.dimension);
            }
            if (world == null || tile == null) {
                return null;
            }
            lootTable = ((ILootBlockEntity)tile).getTable();
            NonNullList items = NonNullList.m_122780_((int)tile.m_6643_(), (Object)ItemStack.f_41583_);
            result = new SpecialChestInventory(this, (NonNullList<ItemStack>)items, tile.m_5446_(), this.pos);
        }
        filler.fillWithLoot((Player)player, result, lootTable, seed);
        this.inventories.put(player.m_142081_(), result);
        this.m_77762_();
        return result;
    }

    public static ChestData load(CompoundTag compound) {
        ChestData data = new ChestData(compound.m_128461_("key"));
        data.inventories.clear();
        data.pos = null;
        data.dimension = null;
        data.entityId = null;
        data.tileId = null;
        if (compound.m_128441_("position")) {
            data.pos = BlockPos.m_122022_((long)compound.m_128454_("position"));
        }
        if (compound.m_128441_("dimension")) {
            data.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(compound.m_128461_("dimension")));
        }
        if (compound.m_128403_("entityId")) {
            data.entityId = compound.m_128342_("entityId");
        }
        if (compound.m_128403_("tileId")) {
            data.tileId = compound.m_128342_("tileId");
        }
        if (compound.m_128441_("custom")) {
            data.custom = compound.m_128471_("custom");
        }
        if (compound.m_128403_("customId")) {
            data.customId = compound.m_128342_("customId");
        }
        if (compound.m_128441_("reference") && compound.m_128441_("referenceSize")) {
            int size = compound.m_128451_("referenceSize");
            data.reference = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)compound.m_128469_("reference"), data.reference);
        }
        ListTag compounds = compound.m_128437_("inventories", 10);
        for (int i = 0; i < compounds.size(); ++i) {
            CompoundTag thisTag = compounds.m_128728_(i);
            CompoundTag items = thisTag.m_128469_("chest");
            String name = thisTag.m_128461_("name");
            UUID uuid = thisTag.m_128342_("uuid");
            data.inventories.put(uuid, new SpecialChestInventory(data, items, name, data.pos));
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        if (this.key != null) {
            compound.m_128359_("key", this.key);
        }
        if (this.pos != null) {
            compound.m_128356_("position", this.pos.m_121878_());
        }
        if (this.dimension != null) {
            compound.m_128359_("dimension", this.dimension.m_135782_().toString());
        }
        if (this.entityId != null) {
            compound.m_128362_("entityId", this.entityId);
        }
        if (this.tileId != null) {
            compound.m_128362_("tileId", this.tileId);
        }
        if (this.customId != null) {
            compound.m_128362_("customId", this.customId);
        }
        compound.m_128379_("custom", this.custom);
        if (this.reference != null) {
            compound.m_128405_("referenceSize", this.reference.size());
            compound.m_128365_("reference", (Tag)ContainerHelper.m_18976_((CompoundTag)new CompoundTag(), this.reference, (boolean)true));
        }
        ListTag compounds = new ListTag();
        for (Map.Entry<UUID, SpecialChestInventory> entry : this.inventories.entrySet()) {
            CompoundTag thisTag = new CompoundTag();
            thisTag.m_128362_("uuid", entry.getKey());
            thisTag.m_128365_("chest", (Tag)entry.getValue().writeItems());
            thisTag.m_128359_("name", entry.getValue().writeName());
            compounds.add((Object)thisTag);
        }
        compound.m_128365_("inventories", (Tag)compounds);
        return compound;
    }

    public void clear() {
        this.inventories.clear();
    }
}

