/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.data;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.server.ServerLifecycleHooks;
import noobanidus.mods.lootr.Lootr;
import noobanidus.mods.lootr.api.LootFiller;
import noobanidus.mods.lootr.data.AdvancementData;
import noobanidus.mods.lootr.data.ChestData;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import noobanidus.mods.lootr.data.TickingData;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;

public class DataStorage {
    public static final String ID = "Lootr-AdvancementData";
    public static final String SCORED = "Lootr-ScoreData";
    public static final String DECAY = "Lootr-DecayData";
    public static final String REFRESH = "Lootr-RefreshData";

    public static DimensionDataStorage getDataStorage() {
        return ServerLifecycleHooks.getCurrentServer().m_129783_().m_8895_();
    }

    public static boolean isAwarded(UUID player, UUID tileId) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        AdvancementData data = (AdvancementData)manager.m_164861_(AdvancementData::load, AdvancementData::new, ID);
        return data.contains(player, tileId);
    }

    public static void award(UUID player, UUID tileId) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        AdvancementData data = (AdvancementData)manager.m_164861_(AdvancementData::load, AdvancementData::new, ID);
        data.add(player, tileId);
        data.m_77762_();
    }

    public static boolean isScored(UUID player, UUID tileId) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        AdvancementData data = (AdvancementData)manager.m_164861_(AdvancementData::load, AdvancementData::new, SCORED);
        return data.contains(player, tileId);
    }

    public static void score(UUID player, UUID tileId) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        AdvancementData data = (AdvancementData)manager.m_164861_(AdvancementData::load, AdvancementData::new, SCORED);
        data.add(player, tileId);
        data.m_77762_();
    }

    public static int getDecayValue(UUID id) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        TickingData data = (TickingData)manager.m_164861_(TickingData::load, TickingData::new, DECAY);
        return data.getValue(id);
    }

    public static boolean isDecayed(UUID id) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        TickingData data = (TickingData)manager.m_164861_(TickingData::load, TickingData::new, DECAY);
        return data.isComplete(id);
    }

    public static void setDecaying(UUID id, int decay) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        TickingData data = (TickingData)manager.m_164861_(TickingData::load, TickingData::new, DECAY);
        data.setValue(id, decay);
        data.m_77762_();
    }

    public static void removeDecayed(UUID id) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        TickingData data = (TickingData)manager.m_164861_(TickingData::load, TickingData::new, DECAY);
        if (data.remove(id) != -1) {
            data.m_77762_();
        }
    }

    public static void doDecay() {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        TickingData data = (TickingData)manager.m_164861_(TickingData::load, TickingData::new, DECAY);
        if (data.tick()) {
            data.m_77762_();
        }
    }

    public static int getRefreshValue(UUID id) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        TickingData data = (TickingData)manager.m_164861_(TickingData::load, TickingData::new, REFRESH);
        return data.getValue(id);
    }

    public static boolean isRefreshed(UUID id) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        TickingData data = (TickingData)manager.m_164861_(TickingData::load, TickingData::new, REFRESH);
        return data.isComplete(id);
    }

    public static void setRefreshing(UUID id, int decay) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        TickingData data = (TickingData)manager.m_164861_(TickingData::load, TickingData::new, REFRESH);
        data.setValue(id, decay);
        data.m_77762_();
    }

    public static void removeRefreshed(UUID id) {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        TickingData data = (TickingData)manager.m_164861_(TickingData::load, TickingData::new, REFRESH);
        if (data.remove(id) != -1) {
            data.m_77762_();
        }
    }

    public static void doRefresh() {
        DimensionDataStorage manager = DataStorage.getDataStorage();
        TickingData data = (TickingData)manager.m_164861_(TickingData::load, TickingData::new, REFRESH);
        if (data.tick()) {
            data.m_77762_();
        }
    }

    public static ChestData getInstanceUuid(ServerLevel world, UUID id) {
        ResourceKey dimension = world.m_46472_();
        return (ChestData)DataStorage.getDataStorage().m_164861_(ChestData::load, ChestData.id((ResourceKey<Level>)dimension, id), DataStorage.ID((ResourceKey<Level>)dimension, id));
    }

    public static ChestData getInstance(ServerLevel world, UUID id) {
        return (ChestData)DataStorage.getDataStorage().m_164861_(ChestData::load, ChestData.entity(id), DataStorage.ENTITY(id));
    }

    public static ChestData getInstanceInventory(ServerLevel world, UUID id, @Nullable UUID customId, @Nullable NonNullList<ItemStack> base) {
        ResourceKey dimension = world.m_46472_();
        return (ChestData)DataStorage.getDataStorage().m_164861_(ChestData::load, ChestData.ref_id((ResourceKey<Level>)dimension, id, customId, base), DataStorage.REF_ID((ResourceKey<Level>)dimension, id));
    }

    @Nullable
    public static SpecialChestInventory getInventory(Level world, UUID uuid, BlockPos pos, ServerPlayer player, RandomizableContainerBlockEntity tile, LootFiller filler) {
        if (world.f_46443_ || !(world instanceof ServerLevel)) {
            return null;
        }
        ChestData data = DataStorage.getInstanceUuid((ServerLevel)world, uuid);
        SpecialChestInventory inventory = data.getInventory(player, pos);
        if (inventory == null) {
            inventory = data.createInventory(player, filler, tile);
            inventory.setBlockPos(pos);
        }
        return inventory;
    }

    @Nullable
    public static SpecialChestInventory getInventory(Level world, UUID uuid, NonNullList<ItemStack> base, ServerPlayer player, BlockPos pos, RandomizableContainerBlockEntity tile) {
        if (world.f_46443_ || !(world instanceof ServerLevel)) {
            return null;
        }
        ChestData data = DataStorage.getInstanceInventory((ServerLevel)world, uuid, null, base);
        SpecialChestInventory inventory = data.getInventory(player, pos);
        if (inventory == null) {
            inventory = data.createInventory(player, data.customInventory(), tile);
            inventory.setBlockPos(pos);
        }
        return inventory;
    }

    public static boolean clearInventories(ServerPlayer player) {
        return DataStorage.clearInventories(player.m_142081_());
    }

    public static boolean clearInventories(UUID uuid) {
        ServerLevel world = ServerLifecycleHooks.getCurrentServer().m_129783_();
        DimensionDataStorage data = world.m_8895_();
        Path dataPath = world.m_142572_().m_129843_(new LevelResource("data"));
        ArrayList ids = new ArrayList();
        try (Stream<Path> paths = Files.walk(dataPath, new FileVisitOption[0]);){
            paths.forEach(o -> {
                String name;
                if (Files.isRegularFile(o, new LinkOption[0]) && (name = o.getFileName().toString()).startsWith("Lootr-")) {
                    ids.add(name.replace(".dat", ""));
                }
            });
        }
        catch (IOException e) {
            return false;
        }
        int cleared = 0;
        for (String id : ids) {
            ChestData chestData = (ChestData)data.m_164858_(ChestData::load, id);
            if (chestData == null || !chestData.clearInventory(uuid)) continue;
            ++cleared;
            chestData.m_77762_();
        }
        Lootr.LOG.info("Cleared " + cleared + " inventories for play UUID " + uuid.toString());
        return cleared != 0;
    }

    @Nullable
    public static SpecialChestInventory getInventory(Level world, LootrChestMinecartEntity cart, ServerPlayer player, LootFiller filler) {
        if (world.f_46443_ || !(world instanceof ServerLevel)) {
            return null;
        }
        ChestData data = DataStorage.getInstance((ServerLevel)world, cart.m_142081_());
        SpecialChestInventory inventory = data.getInventory(player, null);
        if (inventory == null) {
            inventory = data.createInventory(player, filler, null);
        }
        return inventory;
    }

    public static void refreshInventory(Level level, UUID uuid, ServerPlayer player) {
        if (level.m_5776_() || !(level instanceof ServerLevel)) {
            return;
        }
        ChestData data = DataStorage.getInstanceUuid((ServerLevel)level, uuid);
        data.clear();
        data.m_77762_();
    }

    public static void refreshInventory(Level world, UUID uuid, NonNullList<ItemStack> base, ServerPlayer player) {
        if (world.m_5776_() || !(world instanceof ServerLevel)) {
            return;
        }
        ChestData data = DataStorage.getInstanceInventory((ServerLevel)world, uuid, null, base);
        data.clear();
        data.m_77762_();
    }

    public static void refreshInventory(Level world, LootrChestMinecartEntity cart, ServerPlayer player) {
        if (world.m_5776_() || !(world instanceof ServerLevel)) {
            return;
        }
        ChestData data = DataStorage.getInstance((ServerLevel)world, cart.m_142081_());
        data.clear();
        data.m_77762_();
    }

    public static String REF_ID(ResourceKey<Level> dimension, UUID id) {
        return "Lootr-custom-" + dimension.m_135782_().m_135815_() + "-" + id.toString();
    }

    public static String ID(ResourceKey<Level> dimension, UUID id) {
        return "Lootr-chests-" + dimension.m_135782_().m_135815_() + "-" + id.toString();
    }

    public static String ENTITY(UUID entityId) {
        return "Lootr-entity-" + entityId.toString();
    }
}

