/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.data;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import noobanidus.mods.lootr.api.blockentity.ILootBlockEntity;
import noobanidus.mods.lootr.api.inventory.ILootrInventory;
import noobanidus.mods.lootr.data.ChestData;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;

public class SpecialChestInventory
implements ILootrInventory {
    private ChestData newChestData;
    private final NonNullList<ItemStack> contents;
    private final Component name;
    @Nullable
    private BlockPos pos;

    public SpecialChestInventory(ChestData newChestData, NonNullList<ItemStack> contents, Component name, @Nullable BlockPos pos) {
        this.newChestData = newChestData;
        this.contents = !contents.isEmpty() ? contents : NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
        this.name = name;
        this.pos = pos;
    }

    public SpecialChestInventory(ChestData newChestData, CompoundTag items, String componentAsJSON, BlockPos pos) {
        this.newChestData = newChestData;
        this.name = Component.Serializer.m_130701_((String)componentAsJSON);
        this.contents = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)items, this.contents);
        this.pos = pos;
    }

    public void setBlockPos(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    @Nullable
    public RandomizableContainerBlockEntity getTile(Level world) {
        if (world == null || world.m_5776_() || this.pos == null) {
            return null;
        }
        BlockEntity te = world.m_7702_(this.pos);
        if (te instanceof ILootBlockEntity) {
            return (RandomizableContainerBlockEntity)te;
        }
        return null;
    }

    @Override
    @Nullable
    public LootrChestMinecartEntity getEntity(Level world) {
        if (world == null || world.m_5776_() || this.newChestData.getEntityId() == null) {
            return null;
        }
        if (!(world instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        Entity entity = serverWorld.m_8791_(this.newChestData.getEntityId());
        if (entity instanceof LootrChestMinecartEntity) {
            return (LootrChestMinecartEntity)entity;
        }
        return null;
    }

    public int m_6643_() {
        return 27;
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.contents) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.contents.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.contents, (int)index, (int)count);
        if (!itemstack.m_41619_()) {
            this.m_6596_();
        }
        return itemstack;
    }

    public ItemStack m_8016_(int index) {
        ItemStack result = ContainerHelper.m_18966_(this.contents, (int)index);
        if (!result.m_41619_()) {
            this.m_6596_();
        }
        return result;
    }

    public void m_6836_(int index, ItemStack stack) {
        this.contents.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public void m_6596_() {
        this.newChestData.m_77762_();
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_6211_() {
        this.contents.clear();
        this.m_6596_();
    }

    public Component m_5446_() {
        return this.name;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return ChestMenu.m_39237_((int)id, (Inventory)inventory, (Container)this);
    }

    public void m_5856_(Player player) {
        LootrChestMinecartEntity entity;
        Level world = player.f_19853_;
        RandomizableContainerBlockEntity tile = this.getTile(world);
        if (tile != null) {
            tile.m_5856_(player);
        }
        if (this.newChestData.getEntityId() != null && (entity = this.getEntity(world)) != null) {
            entity.m_5856_(player);
        }
    }

    public void m_5785_(Player player) {
        LootrChestMinecartEntity entity;
        RandomizableContainerBlockEntity tile;
        this.m_6596_();
        Level world = player.f_19853_;
        if (this.pos != null && (tile = this.getTile(world)) != null) {
            tile.m_5785_(player);
        }
        if (this.newChestData.getEntityId() != null && (entity = this.getEntity(world)) != null) {
            entity.m_5785_(player);
        }
    }

    @Nullable
    public UUID getTileId() {
        if (this.newChestData == null) {
            return null;
        }
        return this.newChestData.getTileId();
    }

    public CompoundTag writeItems() {
        CompoundTag result = new CompoundTag();
        return ContainerHelper.m_18973_((CompoundTag)result, this.contents);
    }

    public String writeName() {
        return Component.Serializer.m_130703_((Component)this.name);
    }

    @Override
    @Nullable
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public NonNullList<ItemStack> getContents() {
        return this.contents;
    }
}

