/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.init;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import noobanidus.mods.lootr.block.LootrBarrelBlock;
import noobanidus.mods.lootr.block.LootrChestBlock;
import noobanidus.mods.lootr.block.LootrInventoryBlock;
import noobanidus.mods.lootr.block.LootrShulkerBlock;
import noobanidus.mods.lootr.block.LootrTrappedChestBlock;
import noobanidus.mods.lootr.block.TrophyBlock;
import noobanidus.mods.lootr.block.entities.LootrShulkerBlockEntity;

@Mod.EventBusSubscriber(modid="lootr", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModBlocks {
    public static LootrBarrelBlock BARREL = new LootrBarrelBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50087_).m_60978_(2.5f));
    public static LootrChestBlock CHEST = new LootrChestBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_).m_60978_(2.5f));
    public static LootrTrappedChestBlock TRAPPED_CHEST = new LootrTrappedChestBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50325_).m_60978_(2.5f));
    public static LootrInventoryBlock INVENTORY = new LootrInventoryBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(2.5f).m_60918_(SoundType.f_56736_));
    private static final BlockBehaviour.StatePredicate posPredicate = (state, level, pos) -> {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof LootrShulkerBlockEntity) {
            LootrShulkerBlockEntity shulkerboxblockentity = (LootrShulkerBlockEntity)blockentity;
            return shulkerboxblockentity.isClosed();
        }
        return false;
    };
    public static LootrShulkerBlock SHULKER = new LootrShulkerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76319_).m_60978_(2.5f).m_60988_().m_60955_().m_60960_(posPredicate).m_60971_(posPredicate));
    public static Block TROPHY = new TrophyBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(15.0f).m_60918_(SoundType.f_56743_).m_60955_().m_60953_(o -> 15));
    public static Set<Block> specialLootChests;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        specialLootChests.forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
        event.getRegistry().register((IForgeRegistryEntry)TROPHY);
    }

    static {
        BARREL.setRegistryName("lootr", "lootr_barrel");
        CHEST.setRegistryName("lootr", "lootr_chest");
        TRAPPED_CHEST.setRegistryName("lootr", "lootr_trapped_chest");
        INVENTORY.setRegistryName("lootr", "lootr_inventory");
        SHULKER.setRegistryName("lootr", "lootr_shulker");
        TROPHY.setRegistryName("lootr", "trophy");
        specialLootChests = Sets.newHashSet((Object[])new Block[]{CHEST, BARREL, TRAPPED_CHEST, SHULKER, INVENTORY});
    }
}

