/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.common.item;

import com.progwml6.ironchest.common.block.IronChestsBlocks;
import com.progwml6.ironchest.common.block.IronChestsTypes;
import com.progwml6.ironchest.common.block.regular.AbstractIronChestBlock;
import com.progwml6.ironchest.common.block.regular.CopperChestBlock;
import com.progwml6.ironchest.common.block.regular.entity.AbstractIronChestBlockEntity;
import com.progwml6.ironchest.common.block.trapped.entity.AbstractTrappedIronChestBlockEntity;
import com.progwml6.ironchest.common.item.IronChestsUpgradeType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.TrappedChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ChestUpgradeItem
extends Item {
    private final IronChestsUpgradeType type;

    public ChestUpgradeItem(IronChestsUpgradeType type, Item.Properties properties) {
        super(properties);
        this.type = type;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player entityPlayer = context.m_43723_();
        BlockPos blockPos = context.m_8083_();
        Level world = context.m_43725_();
        ItemStack itemStack = context.m_43722_();
        boolean passed = false;
        if (world.f_46443_) {
            return InteractionResult.PASS;
        }
        if (entityPlayer == null) {
            return InteractionResult.PASS;
        }
        if (this.type.canUpgrade(IronChestsTypes.WOOD)) {
            if (world.m_8055_(blockPos).m_60734_() instanceof ChestBlock) {
                passed = true;
            }
        } else {
            for (Block block : IronChestsTypes.get(this.type.source)) {
                if (passed) continue;
                passed = world.m_8055_(blockPos).m_60734_().m_49966_() == block.m_49966_();
            }
        }
        if (!passed) {
            return InteractionResult.PASS;
        }
        BlockEntity tileEntity = world.m_7702_(blockPos);
        if (this.type.canUpgrade(IronChestsTypes.WOOD) && !(tileEntity instanceof ChestBlockEntity)) {
            return InteractionResult.PASS;
        }
        AbstractIronChestBlockEntity newChest = null;
        Component customName = null;
        NonNullList chestContents = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
        Direction chestFacing = Direction.NORTH;
        BlockState iBlockState = ((CopperChestBlock)IronChestsBlocks.COPPER_CHEST.get()).m_49966_();
        if (tileEntity != null) {
            if (tileEntity instanceof AbstractIronChestBlockEntity) {
                AbstractIronChestBlockEntity chest = (AbstractIronChestBlockEntity)tileEntity;
                BlockState chestState = world.m_8055_(blockPos);
                if (AbstractIronChestBlockEntity.getOpenCount((BlockGetter)world, blockPos) > 0) {
                    return InteractionResult.PASS;
                }
                if (!chest.m_7525_(entityPlayer)) {
                    return InteractionResult.PASS;
                }
                boolean trapped = tileEntity instanceof AbstractTrappedIronChestBlockEntity;
                iBlockState = trapped ? IronChestsTypes.get(this.type.target).get(1).m_49966_() : IronChestsTypes.get(this.type.target).get(0).m_49966_();
                chestContents = chest.m_7086_();
                chestFacing = (Direction)chestState.m_61143_((Property)AbstractIronChestBlock.FACING);
                customName = chest.m_7770_();
                iBlockState = (BlockState)iBlockState.m_61124_((Property)AbstractIronChestBlock.FACING, (Comparable)chestFacing);
                newChest = this.type.target.makeEntity(blockPos, iBlockState, trapped);
            } else if (tileEntity instanceof ChestBlockEntity) {
                ChestBlockEntity chest = (ChestBlockEntity)tileEntity;
                BlockState chestState = world.m_8055_(blockPos);
                chestFacing = (Direction)chestState.m_61143_((Property)ChestBlock.f_51478_);
                if (ChestBlockEntity.m_59086_((BlockGetter)world, (BlockPos)blockPos) > 0) {
                    return InteractionResult.PASS;
                }
                if (!chest.m_7525_(entityPlayer)) {
                    return InteractionResult.PASS;
                }
                if (!this.type.canUpgrade(IronChestsTypes.WOOD)) {
                    return InteractionResult.PASS;
                }
                chestContents = NonNullList.m_122780_((int)chest.m_6643_(), (Object)ItemStack.f_41583_);
                for (int slot = 0; slot < chestContents.size(); ++slot) {
                    chestContents.set(slot, (Object)chest.m_8020_(slot));
                }
                customName = chest.m_7770_();
                boolean trapped = tileEntity instanceof TrappedChestBlockEntity;
                iBlockState = trapped ? IronChestsTypes.get(this.type.target).get(1).m_49966_() : IronChestsTypes.get(this.type.target).get(0).m_49966_();
                iBlockState = (BlockState)iBlockState.m_61124_((Property)AbstractIronChestBlock.FACING, (Comparable)chestFacing);
                newChest = this.type.target.makeEntity(blockPos, iBlockState, trapped);
            }
        }
        if (newChest == null) {
            return InteractionResult.PASS;
        }
        world.m_46747_(blockPos);
        world.m_7471_(blockPos, false);
        world.m_7731_(blockPos, iBlockState, 3);
        world.m_151523_(newChest);
        world.m_7260_(blockPos, iBlockState, iBlockState, 3);
        BlockEntity tileEntity2 = world.m_7702_(blockPos);
        if (tileEntity2 instanceof AbstractIronChestBlockEntity) {
            if (customName != null) {
                ((AbstractIronChestBlockEntity)tileEntity2).m_58638_(customName);
            }
            ((AbstractIronChestBlockEntity)tileEntity2).m_6520_((NonNullList<ItemStack>)chestContents);
        }
        if (!entityPlayer.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }
}

