/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.network;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.util.ItemUtils;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class CompassSearchPacket {
    private ResourceLocation structureKey;
    private int x;
    private int y;
    private int z;

    public CompassSearchPacket() {
    }

    public CompassSearchPacket(ResourceLocation structureKey, BlockPos pos) {
        this.structureKey = structureKey;
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
    }

    public CompassSearchPacket(FriendlyByteBuf buf) {
        this.structureKey = buf.m_130281_();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.structureKey);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack stack = ItemUtils.getHeldItem((Player)((NetworkEvent.Context)ctx.get()).getSender(), ExplorersCompass.explorersCompass);
            if (!stack.m_41619_()) {
                ExplorersCompassItem explorersCompass = (ExplorersCompassItem)stack.m_41720_();
                ServerLevel level = ((NetworkEvent.Context)ctx.get()).getSender().m_183503_();
                explorersCompass.searchForStructure((Level)level, (Player)((NetworkEvent.Context)ctx.get()).getSender(), this.structureKey, new BlockPos(this.x, this.y, this.z), stack);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

