/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.network;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraftforge.network.NetworkEvent;

public class SyncPacket {
    private boolean canTeleport;
    private List<StructureFeature<?>> allowedStructures;
    private Map<StructureFeature<?>, List<ResourceLocation>> dimensionsForAllowedStructures;

    public SyncPacket() {
    }

    public SyncPacket(boolean canTeleport, List<StructureFeature<?>> allowedStructures, Map<StructureFeature<?>, List<ResourceLocation>> dimensionsForAllowedStructures) {
        this.canTeleport = canTeleport;
        this.allowedStructures = allowedStructures;
        this.dimensionsForAllowedStructures = dimensionsForAllowedStructures;
    }

    public SyncPacket(FriendlyByteBuf buf) {
        this.canTeleport = buf.readBoolean();
        this.allowedStructures = new ArrayList();
        this.dimensionsForAllowedStructures = new HashMap();
        int numStructures = buf.readInt();
        for (int i = 0; i < numStructures; ++i) {
            StructureFeature<?> structure = StructureUtils.getStructureForKey(buf.m_130281_());
            this.allowedStructures.add(structure);
            int numDimensions = buf.readInt();
            ArrayList<ResourceLocation> dimensions = new ArrayList<ResourceLocation>();
            for (int j = 0; j < numDimensions; ++j) {
                dimensions.add(buf.m_130281_());
            }
            this.dimensionsForAllowedStructures.put(structure, dimensions);
        }
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.canTeleport);
        buf.writeInt(this.allowedStructures.size());
        for (StructureFeature<?> structure : this.allowedStructures) {
            buf.m_130085_(StructureUtils.getKeyForStructure(structure));
            List<ResourceLocation> dimensions = this.dimensionsForAllowedStructures.get(structure);
            buf.writeInt(dimensions.size());
            for (ResourceLocation dimensionKey : dimensions) {
                buf.m_130085_(dimensionKey);
            }
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ExplorersCompass.canTeleport = this.canTeleport;
            ExplorersCompass.allowedStructures = this.allowedStructures;
            ExplorersCompass.dimensionsForAllowedStructures = this.dimensionsForAllowedStructures;
        });
        ctx.get().setPacketHandled(true);
    }
}

