/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.util;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.config.ConfigHandler;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.FeatureAccess;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraftforge.common.WorldWorkerManager;
import net.minecraftforge.registries.ForgeRegistries;

public class StructureSearchWorker
implements WorldWorkerManager.IWorker {
    public ServerLevel level;
    public StructureFeature<?> structure;
    public ResourceLocation structureKey;
    public StructureFeatureConfiguration structureConfig;
    public BlockPos startPos;
    public int samples;
    public int nextLength;
    public Direction direction;
    public ItemStack stack;
    public Player player;
    public int chunkX;
    public int chunkZ;
    public int length;
    public boolean finished;
    public int x;
    public int z;
    public int lastRadiusThreshold;

    public StructureSearchWorker(ServerLevel world, Player player, ItemStack stack, StructureFeature<?> structure, BlockPos startPos) {
        this.level = world;
        this.player = player;
        this.stack = stack;
        this.structure = structure;
        this.startPos = startPos;
        this.chunkX = startPos.m_123341_() >> 4;
        this.chunkZ = startPos.m_123343_() >> 4;
        this.x = startPos.m_123341_();
        this.z = startPos.m_123343_();
        this.nextLength = 1;
        this.length = 0;
        this.samples = 0;
        this.direction = Direction.UP;
        this.structureKey = ForgeRegistries.STRUCTURE_FEATURES.getKey(structure);
        this.lastRadiusThreshold = 0;
        this.structureConfig = world.m_7726_().m_8481_().m_62205_().m_64593_(structure);
        this.finished = !world.m_142572_().m_129910_().m_5961_().m_64657_() || world.m_7726_().m_8481_().m_62205_().m_189371_(structure).isEmpty() || this.structureConfig == null;
    }

    public void start() {
        if (!this.stack.m_41619_() && this.stack.m_41720_() == ExplorersCompass.explorersCompass) {
            if ((Integer)ConfigHandler.GENERAL.maxRadius.get() > 0) {
                ExplorersCompass.LOGGER.info("Starting search: " + ConfigHandler.GENERAL.maxRadius.get() + " max radius, " + ConfigHandler.GENERAL.maxSamples.get() + " max samples");
                WorldWorkerManager.addWorker((WorldWorkerManager.IWorker)this);
            } else {
                this.finish(false);
            }
        }
    }

    public boolean hasWork() {
        return !this.finished && this.getRadius() < (Integer)ConfigHandler.GENERAL.maxRadius.get() && this.samples < (Integer)ConfigHandler.GENERAL.maxSamples.get();
    }

    public boolean doWork() {
        if (this.hasWork()) {
            int radius;
            if (this.direction == Direction.NORTH) {
                --this.chunkZ;
            } else if (this.direction == Direction.EAST) {
                ++this.chunkX;
            } else if (this.direction == Direction.SOUTH) {
                ++this.chunkZ;
            } else if (this.direction == Direction.WEST) {
                --this.chunkX;
            }
            this.x = this.chunkX << 4;
            this.z = this.chunkZ << 4;
            ChunkPos chunkPos = this.structure.m_191122_(this.structureConfig, this.level.m_7328_(), this.chunkX, this.chunkZ);
            ChunkAccess chunk = this.level.m_46819_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62315_);
            StructureStart structureStart = this.level.m_8595_().m_47297_(SectionPos.m_175562_((ChunkAccess)chunk), this.structure, (FeatureAccess)chunk);
            if (structureStart != null && structureStart.m_73603_()) {
                this.x = this.getLocatePos(structureStart.m_163625_()).m_123341_();
                this.z = this.getLocatePos(structureStart.m_163625_()).m_123343_();
                this.finish(true);
                return true;
            }
            ++this.samples;
            ++this.length;
            if (this.length >= this.nextLength) {
                if (this.direction != Direction.UP) {
                    ++this.nextLength;
                    this.direction = this.direction.m_122427_();
                } else {
                    this.direction = Direction.NORTH;
                }
                this.length = 0;
            }
            if ((radius = this.getRadius()) > 250 && radius / 250 > this.lastRadiusThreshold) {
                if (!this.stack.m_41619_() && this.stack.m_41720_() == ExplorersCompass.explorersCompass) {
                    ((ExplorersCompassItem)this.stack.m_41720_()).setSearchRadius(this.stack, this.roundRadius(radius, 250), this.player);
                }
                this.lastRadiusThreshold = radius / 250;
            }
        }
        if (this.hasWork()) {
            return true;
        }
        this.finish(false);
        return false;
    }

    private void finish(boolean found) {
        if (!this.stack.m_41619_() && this.stack.m_41720_() == ExplorersCompass.explorersCompass) {
            if (found) {
                ExplorersCompass.LOGGER.info("Search succeeded: " + this.getRadius() + " radius, " + this.samples + " samples");
                ((ExplorersCompassItem)this.stack.m_41720_()).setFound(this.stack, this.x, this.z, this.samples, this.player);
                ((ExplorersCompassItem)this.stack.m_41720_()).setDisplayCoordinates(this.stack, (Boolean)ConfigHandler.GENERAL.displayCoordinates.get());
            } else {
                ExplorersCompass.LOGGER.info("Search failed: " + this.getRadius() + " radius, " + this.samples + " samples");
                ((ExplorersCompassItem)this.stack.m_41720_()).setNotFound(this.stack, this.player, this.roundRadius(this.getRadius(), 250), this.samples);
            }
        } else {
            ExplorersCompass.LOGGER.error("Invalid compass after search");
        }
        this.finished = true;
    }

    private int getRadius() {
        return StructureUtils.getDistanceToStructure(this.startPos, this.x, this.z);
    }

    private int roundRadius(int radius, int roundTo) {
        return radius / roundTo * roundTo;
    }

    private BlockPos getLocatePos(ChunkPos p_191115_) {
        return new BlockPos(p_191115_.m_45604_(), 0, p_191115_.m_45605_());
    }
}

