/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.util;

import com.chaosthedude.explorerscompass.config.ConfigHandler;
import com.chaosthedude.explorerscompass.util.StructureSearchWorker;
import com.google.common.collect.ImmutableMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.text.WordUtils;

public class StructureUtils {
    public static ResourceLocation getKeyForStructure(StructureFeature<?> structure) {
        return ForgeRegistries.STRUCTURE_FEATURES.getKey(structure);
    }

    public static StructureFeature<?> getStructureForKey(ResourceLocation key) {
        return (StructureFeature)ForgeRegistries.STRUCTURE_FEATURES.getValue(key);
    }

    public static List<StructureFeature<?>> getAllowedStructures() {
        ArrayList structures = new ArrayList();
        for (StructureFeature structure : ForgeRegistries.STRUCTURE_FEATURES) {
            if (structure == null || StructureUtils.getStructureForKey(structure.getRegistryName()) == null || StructureUtils.getKeyForStructure(structure) == null || StructureUtils.structureIsBlacklisted(structure)) continue;
            structures.add(structure);
        }
        return structures;
    }

    public static void searchForStructure(ServerLevel serverLevel, Player player, ItemStack stack, StructureFeature<?> structure, BlockPos startPos) {
        StructureSearchWorker worker = new StructureSearchWorker(serverLevel, player, stack, structure, startPos);
        worker.start();
    }

    public static int getDistanceToStructure(Player player, int biomeX, int biomeZ) {
        return StructureUtils.getDistanceToStructure(player.m_142538_(), biomeX, biomeZ);
    }

    public static int getDistanceToStructure(BlockPos startPos, int structureX, int structureZ) {
        return (int)Mth.m_14116_((float)((float)startPos.m_123331_((Vec3i)new BlockPos(structureX, startPos.m_123342_(), structureZ))));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getStructureName(StructureFeature<?> structure) {
        if (StructureUtils.getKeyForStructure(structure) == null) {
            return "";
        }
        String name = StructureUtils.getKeyForStructure(structure).toString();
        if (((Boolean)ConfigHandler.CLIENT.translateStructureNames.get()).booleanValue()) {
            name = I18n.m_118938_((String)Util.m_137492_((String)"structure", (ResourceLocation)StructureUtils.getKeyForStructure(structure)), (Object[])new Object[0]);
        }
        if (name.equals(Util.m_137492_((String)"structure", (ResourceLocation)StructureUtils.getKeyForStructure(structure))) || !((Boolean)ConfigHandler.CLIENT.translateStructureNames.get()).booleanValue()) {
            name = StructureUtils.getKeyForStructure(structure).toString();
            if (name.contains(":")) {
                name = name.substring(name.indexOf(":") + 1);
            }
            name = WordUtils.capitalize((String)name.replace('_', ' '));
        }
        return name;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getStructureName(ResourceLocation key) {
        return StructureUtils.getStructureName(StructureUtils.getStructureForKey(key));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String getStructureSource(StructureFeature<?> structure) {
        if (StructureUtils.getKeyForStructure(structure) == null) {
            return "";
        }
        String registryEntry = StructureUtils.getKeyForStructure(structure).toString();
        String modid = registryEntry.substring(0, registryEntry.indexOf(":"));
        if (modid.equals("minecraft")) {
            return "Minecraft";
        }
        Optional sourceContainer = ModList.get().getModContainerById(modid);
        if (sourceContainer.isPresent()) {
            return ((ModContainer)sourceContainer.get()).getModInfo().getDisplayName();
        }
        return modid;
    }

    public static List<ResourceLocation> getStructureDimensions(ServerLevel serverLevel, StructureFeature<?> structure) {
        ArrayList<ResourceLocation> dimensions = new ArrayList<ResourceLocation>();
        for (ServerLevel level : serverLevel.m_142572_().m_129785_()) {
            ChunkGenerator chunkGenerator = level.m_7726_().m_8481_();
            ImmutableMultimap multimap = chunkGenerator.m_62205_().m_189371_(structure);
            if (chunkGenerator.m_62205_().m_64593_(structure) == null || multimap.isEmpty()) continue;
            Registry registry = serverLevel.m_5962_().m_175515_(Registry.f_122885_);
            Set set = chunkGenerator.m_62218_().m_196676_().stream().flatMap(biome -> registry.m_7854_(biome).stream()).collect(Collectors.toSet());
            if (multimap.values().stream().noneMatch(set::contains)) continue;
            dimensions.add(level.m_46472_().m_135782_());
        }
        if (structure == StructureFeature.f_67022_ && dimensions.isEmpty()) {
            dimensions.add(new ResourceLocation("minecraft:overworld"));
        }
        return dimensions;
    }

    public static Map<StructureFeature<?>, List<ResourceLocation>> getDimensionsForAllowedStructures(ServerLevel serverLevel) {
        HashMap dimensionsForAllowedStructures = new HashMap();
        for (StructureFeature<?> structure : StructureUtils.getAllowedStructures()) {
            dimensionsForAllowedStructures.put(structure, StructureUtils.getStructureDimensions(serverLevel, structure));
        }
        return dimensionsForAllowedStructures;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String structureDimensionsToString(List<ResourceLocation> dimensions) {
        Object str = "";
        if (dimensions != null && dimensions.size() > 0) {
            str = StructureUtils.getDimensionName(dimensions.get(0));
            for (int i = 1; i < dimensions.size(); ++i) {
                str = (String)str + ", " + StructureUtils.getDimensionName(dimensions.get(i));
            }
        }
        return str;
    }

    public static boolean structureIsBlacklisted(StructureFeature<?> structure) {
        List structureBlacklist = (List)ConfigHandler.GENERAL.structureBlacklist.get();
        for (String structureKey : structureBlacklist) {
            if (!StructureUtils.getKeyForStructure(structure).toString().matches(StructureUtils.convertToRegex(structureKey))) continue;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static String getDimensionName(ResourceLocation dimensionKey) {
        String name = I18n.m_118938_((String)Util.m_137492_((String)"dimension", (ResourceLocation)dimensionKey), (Object[])new Object[0]);
        if (name.equals(Util.m_137492_((String)"dimension", (ResourceLocation)dimensionKey))) {
            name = dimensionKey.toString();
            if (name.contains(":")) {
                name = name.substring(name.indexOf(":") + 1);
            }
            name = WordUtils.capitalize((String)name.replace('_', ' '));
        }
        return name;
    }

    private static String convertToRegex(String glob) {
        Object regex = "^";
        for (int i = 0; i < glob.length(); i = (int)((char)(i + 1))) {
            char c = glob.charAt(i);
            regex = c == '*' ? (String)regex + ".*" : (c == '?' ? (String)regex + "." : (c == '.' ? (String)regex + "\\." : (String)regex + c));
        }
        regex = (String)regex + "$";
        return regex;
    }
}

