/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinygates.gates;

import com.dannyandson.tinygates.RenderHelper;
import com.dannyandson.tinygates.gates.AbstractGate;
import com.dannyandson.tinygates.gui.ClockGUI;
import com.dannyandson.tinygates.network.ModNetworkHandler;
import com.dannyandson.tinyredstone.api.IOverlayBlockInfo;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellSegment;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PanelTileRenderer;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.network.PanelCellSync;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class Clock
extends AbstractGate {
    public static ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("tinygates", "block/clock_1"), new ResourceLocation("tinygates", "block/clock_2"), new ResourceLocation("tinygates", "block/clock_3"), new ResourceLocation("tinygates", "block/clock_4"), new ResourceLocation("tinygates", "block/clock_5"), new ResourceLocation("tinygates", "block/clock_6"), new ResourceLocation("tinygates", "block/clock_7"), new ResourceLocation("tinygates", "block/clock_8"), new ResourceLocation("tinygates", "block/clock_9")};
    private int ticks = 20;
    private int tick = 0;
    private boolean input = false;

    public void render(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, float alpha) {
        VertexConsumer builder = buffer.m_6299_((double)alpha == 1.0 ? RenderType.m_110451_() : RenderType.m_110466_());
        TextureAtlasSprite sprite = com.dannyandson.tinyredstone.blocks.RenderHelper.getSprite((ResourceLocation)PanelTileRenderer.TEXTURE);
        TextureAtlasSprite sprite_gate = com.dannyandson.tinyredstone.blocks.RenderHelper.getSprite((ResourceLocation)(this.output ? TEXTURES[TEXTURES.length - 1] : TEXTURES[Math.min(Math.floorDiv(this.tick * (TEXTURES.length - 1), this.ticks), TEXTURES.length - 1)]));
        RenderHelper.drawQuarterSlab(poseStack, builder, sprite_gate, sprite, combinedLight, alpha);
    }

    public boolean neighborChanged(PanelCellPos cellPos) {
        PanelCellNeighbor backNeighbor = cellPos.getNeighbor(Side.BACK);
        this.input = backNeighbor != null && backNeighbor.getWeakRsOutput() > 0;
        return false;
    }

    public boolean tick(PanelCellPos cellPos) {
        if (!this.input) {
            ++this.tick;
            if (this.tick >= this.ticks) {
                this.output = true;
                this.tick = 0;
                return true;
            }
            if (this.output) {
                this.output = false;
                return true;
            }
            ModNetworkHandler.sendToClient(new PanelCellSync(cellPos.getPanelTile().m_58899_(), cellPos.getIndex(), this.writeNBT()), cellPos.getPanelTile());
        }
        return false;
    }

    public boolean hasActivation() {
        return true;
    }

    public boolean onBlockActivated(PanelCellPos cellPos, PanelCellSegment segmentClicked, Player player) {
        PanelTile panelTile = cellPos.getPanelTile();
        if (panelTile.m_58904_().f_46443_) {
            ClockGUI.open(panelTile, cellPos.getIndex(), this);
        }
        return false;
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag compoundTag = super.writeNBT();
        compoundTag.m_128405_("ticks", this.ticks);
        compoundTag.m_128405_("tick", this.tick);
        compoundTag.m_128379_("input", this.input);
        return compoundTag;
    }

    @Override
    public void readNBT(CompoundTag compoundTag) {
        super.readNBT(compoundTag);
        this.ticks = compoundTag.m_128451_("ticks");
        this.tick = compoundTag.m_128451_("tick");
        this.input = compoundTag.m_128471_("input");
    }

    public Integer getTicks() {
        return this.ticks;
    }

    public void setTicks(Integer ticks) {
        if (ticks < this.tick) {
            this.tick = 0;
        }
        this.ticks = ticks < 2 ? 2 : (ticks > 200 ? 200 : ticks);
    }

    @Override
    public void addInfo(IOverlayBlockInfo overlayBlockInfo, PanelTile panelTile, PosInPanelCell posInPanelCell) {
        overlayBlockInfo.addText("Rate", this.ticks / 2 + " ticks");
        if (this.input) {
            overlayBlockInfo.addInfo("Locked");
        }
    }
}

