/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinygates.network;

import com.dannyandson.tinygates.gates.Clock;
import com.dannyandson.tinyredstone.api.IPanelCell;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ClockTickSync {
    private final BlockPos pos;
    private final int cellIndex;
    private final int ticks;

    public ClockTickSync(BlockPos pos, int cellIndex, int ticks) {
        this.pos = pos;
        this.cellIndex = cellIndex;
        this.ticks = ticks;
    }

    public ClockTickSync(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.cellIndex = buffer.readInt();
        this.ticks = buffer.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.cellIndex);
        buf.writeInt(this.ticks);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity te = ((NetworkEvent.Context)ctx.get()).getSender().m_183503_().m_7702_(this.pos);
            if (te instanceof PanelTile) {
                PanelTile panelTile = (PanelTile)te;
                PanelCellPos cellPos = PanelCellPos.fromIndex((PanelTile)((PanelTile)te), (Integer)this.cellIndex);
                IPanelCell cell = cellPos.getIPanelCell();
                if (cell instanceof Clock) {
                    Clock clockCell = (Clock)cell;
                    clockCell.setTicks(this.ticks);
                    panelTile.flagSync();
                }
            }
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        });
        return true;
    }
}

