/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.Tags;
import vectorwing.farmersdelight.common.tag.ModTags;

public class MushroomColonyBlock
extends BushBlock
implements BonemealableBlock {
    public static final int GROWING_LIGHT_LEVEL = 12;
    public static final int PLACING_LIGHT_LEVEL = 13;
    public final Supplier<Item> mushroomType;
    public static final IntegerProperty COLONY_AGE = BlockStateProperties.f_61407_;
    protected static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0)};

    public MushroomColonyBlock(BlockBehaviour.Properties properties, Supplier<Item> mushroomType) {
        super(properties);
        this.mushroomType = mushroomType;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)COLONY_AGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)this.getAgeProperty())];
    }

    public IntegerProperty getAgeProperty() {
        return COLONY_AGE;
    }

    protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.m_60804_(worldIn, pos);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos floorPos = pos.m_7495_();
        BlockState floorState = worldIn.m_8055_(floorPos);
        if (floorState.m_60620_((Tag)BlockTags.f_13057_)) {
            return true;
        }
        return worldIn.m_45524_(pos, 0) < 13 && floorState.canSustainPlant((BlockGetter)worldIn, floorPos, Direction.UP, (IPlantable)this);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        int age = (Integer)state.m_61143_((Property)COLONY_AGE);
        ItemStack heldStack = player.m_21120_(handIn);
        if (age > 0 && Tags.Items.SHEARS.m_8110_((Object)heldStack.m_41720_())) {
            MushroomColonyBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)this.m_7397_((BlockGetter)worldIn, pos, state));
            worldIn.m_5594_(null, pos, SoundEvents.f_12075_, SoundSource.BLOCKS, 1.0f, 1.0f);
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)COLONY_AGE, (Comparable)Integer.valueOf(age - 1)), 2);
            if (!worldIn.f_46443_) {
                heldStack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(handIn));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return false;
    }

    public int getMaxAge() {
        return 3;
    }

    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        return false;
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        int age = (Integer)state.m_61143_((Property)COLONY_AGE);
        Block groundState = level.m_8055_(pos.m_7495_()).m_60734_();
        if (age < this.getMaxAge() && ModTags.MUSHROOM_COLONY_GROWABLE_ON.m_8110_((Object)groundState) && level.m_45524_(pos.m_7494_(), 0) <= 12 && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (rand.nextInt(5) == 0 ? 1 : 0) != 0)) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)COLONY_AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.mushroomType.get());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{COLONY_AGE});
    }

    public void m_7719_(ServerLevel worldIn, Random rand, BlockPos pos, BlockState state) {
        int age = Math.min(3, (Integer)state.m_61143_((Property)COLONY_AGE) + 1);
        worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)COLONY_AGE, (Comparable)Integer.valueOf(age)), 2);
    }
}

