/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.itemcollectors;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.itemcollectors.CollectorTile;
import com.supermartijn642.itemcollectors.CollectorTileRenderer;
import com.supermartijn642.itemcollectors.ItemCollectors;
import com.supermartijn642.itemcollectors.screen.AdvancedCollectorContainer;
import com.supermartijn642.itemcollectors.screen.AdvancedCollectorScreen;
import com.supermartijn642.itemcollectors.screen.BasicCollectorScreen;
import java.util.Random;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientProxy {
    @SubscribeEvent
    public static void onSetup(FMLClientSetupEvent e) {
        MenuScreens.m_96206_(ItemCollectors.advanced_collector_container, (container, inventory, title) -> new AdvancedCollectorScreen((AdvancedCollectorContainer)container));
        BlockEntityRenderers.m_173590_(ItemCollectors.basic_collector_tile, context -> new CollectorTileRenderer());
        BlockEntityRenderers.m_173590_(ItemCollectors.advanced_collector_tile, context -> new CollectorTileRenderer());
    }

    public static void openBasicCollectorScreen(BlockPos pos) {
        ClientUtils.displayScreen((Screen)new BasicCollectorScreen(pos));
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class Events {
        @SubscribeEvent
        public static void onBlockHighlight(DrawSelectionEvent.HighlightBlock e) {
            Level world = ClientUtils.getWorld();
            BlockEntity tile = world.m_7702_(e.getTarget().m_82425_());
            if (tile instanceof CollectorTile) {
                e.getPoseStack().m_85836_();
                Vec3 camera = RenderUtils.getCameraPosition();
                e.getPoseStack().m_85837_(-camera.f_82479_, -camera.f_82480_, -camera.f_82481_);
                AABB area = ((CollectorTile)tile).getAffectedArea().m_82400_((double)0.05f);
                Random random = new Random(tile.m_58899_().hashCode());
                float red = random.nextFloat();
                float green = random.nextFloat();
                float blue = random.nextFloat();
                float alpha = 0.3f;
                RenderUtils.renderBox((PoseStack)e.getPoseStack(), (AABB)area, (float)red, (float)green, (float)blue);
                RenderUtils.renderBoxSides((PoseStack)e.getPoseStack(), (AABB)area, (float)red, (float)green, (float)blue, (float)alpha);
                e.getPoseStack().m_85849_();
            }
        }
    }
}

