/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.itemcollectors.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.TileEntityBaseScreen;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.itemcollectors.CollectorTile;
import com.supermartijn642.itemcollectors.ItemCollectors;
import com.supermartijn642.itemcollectors.packet.PacketDecreaseXRange;
import com.supermartijn642.itemcollectors.packet.PacketDecreaseYRange;
import com.supermartijn642.itemcollectors.packet.PacketDecreaseZRange;
import com.supermartijn642.itemcollectors.packet.PacketIncreaseXRange;
import com.supermartijn642.itemcollectors.packet.PacketIncreaseYRange;
import com.supermartijn642.itemcollectors.packet.PacketIncreaseZRange;
import com.supermartijn642.itemcollectors.packet.PacketToggleShowArea;
import com.supermartijn642.itemcollectors.screen.ArrowButton;
import com.supermartijn642.itemcollectors.screen.ShowAreaButton;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.BlockState;

public class BasicCollectorScreen
extends TileEntityBaseScreen<CollectorTile> {
    private ShowAreaButton showAreaButton;

    public BasicCollectorScreen(BlockPos pos) {
        super((Component)TextComponents.empty().get(), pos);
    }

    protected float sizeX(CollectorTile tile) {
        return 202.0f;
    }

    protected float sizeY(CollectorTile tile) {
        return 82.0f;
    }

    protected void addWidgets(CollectorTile tile) {
        this.addWidget((Widget)new ArrowButton(30, 37, false, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketIncreaseXRange(this.tilePos))));
        this.addWidget((Widget)new ArrowButton(30, 63, true, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketDecreaseXRange(this.tilePos))));
        this.addWidget((Widget)new ArrowButton(73, 37, false, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketIncreaseYRange(this.tilePos))));
        this.addWidget((Widget)new ArrowButton(73, 63, true, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketDecreaseYRange(this.tilePos))));
        this.addWidget((Widget)new ArrowButton(116, 37, false, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketIncreaseZRange(this.tilePos))));
        this.addWidget((Widget)new ArrowButton(116, 63, true, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketDecreaseZRange(this.tilePos))));
        this.showAreaButton = (ShowAreaButton)this.addWidget((Widget)new ShowAreaButton(160, 45, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketToggleShowArea(this.tilePos))));
        this.showAreaButton.update(tile.showArea);
    }

    protected void tick(CollectorTile tile) {
        this.showAreaButton.update(tile.showArea);
    }

    protected void render(PoseStack matrixStack, int mouseX, int mouseY, CollectorTile tile) {
        this.drawScreenBackground(matrixStack);
        ScreenUtils.drawCenteredString((PoseStack)matrixStack, (Component)TextComponents.blockState((BlockState)tile.m_58900_()).get(), (float)(this.sizeX(tile) / 2.0f), (float)6.0f);
        ScreenUtils.drawString((PoseStack)matrixStack, (Component)TextComponents.translation((String)"gui.itemcollectors.basic_collector.range", (Object[])new Object[]{tile.rangeX * 2 + 1, tile.rangeY * 2 + 1, tile.rangeZ * 2 + 1}).get(), (float)8.0f, (float)26.0f);
        ScreenUtils.drawCenteredString((PoseStack)matrixStack, (Component)TextComponents.string((String)"x:").get(), (float)25.0f, (float)51.0f);
        ScreenUtils.drawCenteredString((PoseStack)matrixStack, (Component)TextComponents.string((String)("" + tile.rangeX)).get(), (float)39.0f, (float)52.0f);
        ScreenUtils.drawCenteredString((PoseStack)matrixStack, (Component)TextComponents.string((String)"y:").get(), (float)68.0f, (float)51.0f);
        ScreenUtils.drawCenteredString((PoseStack)matrixStack, (Component)TextComponents.string((String)("" + tile.rangeY)).get(), (float)82.0f, (float)52.0f);
        ScreenUtils.drawCenteredString((PoseStack)matrixStack, (Component)TextComponents.string((String)"z:").get(), (float)111.0f, (float)51.0f);
        ScreenUtils.drawCenteredString((PoseStack)matrixStack, (Component)TextComponents.string((String)("" + tile.rangeZ)).get(), (float)125.0f, (float)52.0f);
    }
}

