/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.psd;

import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.plugins.psd.PSDImageResource;
import com.twelvemonkeys.lang.StringUtil;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

abstract class PSDDirectoryResource
extends PSDImageResource {
    byte[] data;
    private Directory directory;

    PSDDirectoryResource(short s, ImageInputStream imageInputStream) throws IOException {
        super(s, imageInputStream);
    }

    @Override
    protected void readData(ImageInputStream imageInputStream) throws IOException {
        this.data = new byte[(int)this.size];
        imageInputStream.readFully(this.data);
    }

    abstract Directory parseDirectory() throws IOException;

    final void initDirectory() throws IOException {
        if (this.directory == null) {
            this.directory = this.parseDirectory();
        }
    }

    Directory getDirectory() {
        return this.directory;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = this.toStringBuilder();
        int n = Math.min(256, this.data.length);
        String string = StringUtil.decode(this.data, 0, n, "UTF-8").replace('\n', ' ').replaceAll("\\s+", " ");
        stringBuilder.append(", data: \"").append(string);
        if (n < this.data.length) {
            stringBuilder.append("...");
        }
        stringBuilder.append("\"]");
        return stringBuilder.toString();
    }
}

