/*
 * Decompiled with CFR 0.152.
 */
package glm_.mat2x2;

import glm_.ExtensionsKt;
import glm_.ToFloatBuffer;
import glm_.glm;
import glm_.mat2x2.Mat2d;
import glm_.mat2x2.Mat2x2t;
import glm_.mat2x2.operators.mat2x2_operators;
import glm_.mat2x3.Mat2x3t;
import glm_.mat2x4.Mat2x4t;
import glm_.mat3x2.Mat3x2;
import glm_.mat3x2.Mat3x2t;
import glm_.mat3x3.Mat3;
import glm_.mat3x3.Mat3d;
import glm_.mat4x2.Mat4x2;
import glm_.mat4x2.Mat4x2t;
import glm_.mat4x4.Mat4;
import glm_.mat4x4.Mat4d;
import glm_.vec2.Vec2;
import glm_.vec2.Vec2bool;
import glm_.vec2.Vec2t;
import glm_.vec3.Vec3;
import glm_.vec4.Vec4;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Arrays;
import kool.Buffers_operatorsKt;
import kool.PointersKt;
import kool.UtilsKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00e8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u000b\n\u0002\b&\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u0090\u00012\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\u0090\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B'\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\fB'\b\u0016\u0012\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000e\u0012\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000e\u00a2\u0006\u0002\u0010\u0010B\u001b\b\u0016\u0012\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00060\u0012\u00a2\u0006\u0002\u0010\u0014B!\b\u0016\u0012\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00060\u0015\u00a2\u0006\u0002\u0010\u0016B\u001d\b\u0016\u0012\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u001aB\u0019\b\u0016\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u001dB\u0012\b\u0016\u0012\u0006\u0010\u001e\u001a\u00020\u001f\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 B\u000f\b\u0016\u0012\u0006\u0010!\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\"B\u000f\b\u0016\u0012\u0006\u0010!\u001a\u00020#\u00a2\u0006\u0002\u0010$B\u000f\b\u0016\u0012\u0006\u0010%\u001a\u00020&\u00a2\u0006\u0002\u0010'B\u000f\b\u0016\u0012\u0006\u0010(\u001a\u00020)\u00a2\u0006\u0002\u0010*B\u0013\b\u0016\u0012\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,\u00a2\u0006\u0002\u0010-B\u0013\b\u0016\u0012\n\u0010.\u001a\u0006\u0012\u0002\b\u00030/\u00a2\u0006\u0002\u00100B\u0013\b\u0016\u0012\n\u00101\u001a\u0006\u0012\u0002\b\u000302\u00a2\u0006\u0002\u00103B\u0013\b\u0016\u0012\n\u00104\u001a\u0006\u0012\u0002\b\u000305\u00a2\u0006\u0002\u00106B\u0019\b\u0017\u0012\u0006\u00107\u001a\u000208\u0012\b\b\u0002\u00109\u001a\u00020:\u00a2\u0006\u0002\u0010;B\u0017\b\u0002\u0012\u0006\u0010<\u001a\u00020\u0013\u0012\u0006\u0010=\u001a\u000208\u00a2\u0006\u0002\u0010>J\u0018\u0010Z\u001a\u00020:2\u0006\u0010[\u001a\u00020\u00002\b\b\u0002\u0010\\\u001a\u00020\u0002J\u0018\u0010]\u001a\u00020:2\u0006\u0010[\u001a\u00020\u00002\b\b\u0002\u0010\\\u001a\u00020\u0002J\u0011\u0010^\u001a\u00020\u00002\u0006\u0010[\u001a\u00020\u0000H\u0086\u0006J\u0016\u0010^\u001a\u00020\u00002\u0006\u0010[\u001a\u00020\u00002\u0006\u0010_\u001a\u00020\u0000J\u0011\u0010^\u001a\u00020\u00002\u0006\u0010[\u001a\u00020\u0002H\u0086\u0006J\u0016\u0010^\u001a\u00020\u00002\u0006\u0010[\u001a\u00020\u00022\u0006\u0010_\u001a\u00020\u0000J\u0011\u0010`\u001a\u00020a2\u0006\u0010[\u001a\u00020\u0000H\u0086\u0006J\u0011\u0010`\u001a\u00020a2\u0006\u0010[\u001a\u00020\u0002H\u0086\u0006J\b\u0010b\u001a\u00020\u0013H\u0016J \u0010c\u001a\u00020d2\u0006\u0010[\u001a\u00020\u00002\u0006\u0010\\\u001a\u00020e2\b\b\u0002\u0010_\u001a\u00020dJ \u0010c\u001a\u00020d2\u0006\u0010[\u001a\u00020\u00002\u0006\u0010\\\u001a\u00020\u00022\b\b\u0002\u0010_\u001a\u00020dJ\u0013\u0010f\u001a\u00020:2\b\u0010g\u001a\u0004\u0018\u00010hH\u0096\u0002J\u0011\u0010i\u001a\u00020e2\u0006\u0010\u0019\u001a\u00020\u0013H\u0096\u0002J\u001e\u0010i\u001a\u00020\u00022\u0006\u0010j\u001a\u00020\u00132\u0006\u0010k\u001a\u00020\u0013H\u0096\u0002\u00a2\u0006\u0002\u0010lJ\b\u0010m\u001a\u00020\u0013H\u0016J\u0006\u0010n\u001a\u00020\u0000J\u0010\u0010o\u001a\u00020\u00002\b\b\u0002\u0010_\u001a\u00020\u0000J\u0006\u0010p\u001a\u00020\u0000J\u0011\u0010q\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0000H\u0086\u0006J\u0011\u0010q\u001a\u00020\u00002\u0006\u0010!\u001a\u00020#H\u0086\u0006J\u0011\u0010q\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&H\u0086\u0006J\u0011\u0010q\u001a\u00020\u00002\u0006\u0010%\u001a\u00020rH\u0086\u0006J\u0011\u0010q\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)H\u0086\u0006J\u0011\u0010q\u001a\u00020\u00002\u0006\u0010(\u001a\u00020sH\u0086\u0006J\u0011\u0010q\u001a\u00020\u00002\u0006\u0010?\u001a\u00020eH\u0086\u0006J\u0011\u0010q\u001a\u00020\u00002\u0006\u0010?\u001a\u00020tH\u0086\u0006J\u0011\u0010q\u001a\u00020\u00002\u0006\u0010?\u001a\u00020uH\u0086\u0006J\u0011\u0010q\u001a\u00020\u00002\u0006\u0010v\u001a\u00020\u0002H\u0086\u0006J\u0019\u0010q\u001a\u00020\u00002\u0006\u0010w\u001a\u00020\u00022\u0006\u0010x\u001a\u00020\u0002H\u0086\u0002J)\u0010q\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u00022\u0006\u0010E\u001a\u00020\u00022\u0006\u0010L\u001a\u00020\u00022\u0006\u0010O\u001a\u00020\u0002H\u0086\u0002J\u0011\u0010q\u001a\u00020\u00002\u0006\u00107\u001a\u000208H\u0086\u0006J\u0019\u0010q\u001a\u00020\u00002\u0006\u0010w\u001a\u00020\u00062\u0006\u0010x\u001a\u00020\u0006H\u0086\u0002J)\u0010q\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u00062\u0006\u0010E\u001a\u00020\u00062\u0006\u0010L\u001a\u00020\u00062\u0006\u0010O\u001a\u00020\u0006H\u0086\u0002J\u0011\u0010y\u001a\u00020\u00002\u0006\u0010[\u001a\u00020\u0000H\u0086\u0006J\u0016\u0010y\u001a\u00020\u00002\u0006\u0010[\u001a\u00020\u00002\u0006\u0010_\u001a\u00020\u0000J\u0011\u0010y\u001a\u00020\u00002\u0006\u0010[\u001a\u00020\u0002H\u0086\u0006J\u0016\u0010y\u001a\u00020\u00002\u0006\u0010[\u001a\u00020\u00022\u0006\u0010_\u001a\u00020\u0000J\u0011\u0010z\u001a\u00020a2\u0006\u0010[\u001a\u00020\u0000H\u0086\u0006J\u0011\u0010z\u001a\u00020a2\u0006\u0010[\u001a\u00020\u0002H\u0086\u0006J \u0010{\u001a\u00020d2\u0006\u0010[\u001a\u00020\u00002\u0006\u0010\\\u001a\u00020e2\b\b\u0002\u0010_\u001a\u00020dJ \u0010{\u001a\u00020d2\u0006\u0010[\u001a\u00020\u00002\u0006\u0010\\\u001a\u00020\u00022\b\b\u0002\u0010_\u001a\u00020dJ\u0011\u0010|\u001a\u00020\u00002\u0006\u0010[\u001a\u00020\u0000H\u0086\u0006J\u0016\u0010|\u001a\u00020\u00002\u0006\u0010[\u001a\u00020\u00002\u0006\u0010_\u001a\u00020\u0000J\u0011\u0010|\u001a\u00020\u00002\u0006\u0010[\u001a\u00020\u0002H\u0086\u0006J\u0016\u0010|\u001a\u00020\u00002\u0006\u0010[\u001a\u00020\u00022\u0006\u0010_\u001a\u00020\u0000J\u0011\u0010}\u001a\u00020a2\u0006\u0010[\u001a\u00020\u0000H\u0086\u0006J\u0011\u0010}\u001a\u00020a2\u0006\u0010[\u001a\u00020\u0002H\u0086\u0006J\u0011\u0010~\u001a\u00020a2\u0006\u0010!\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010~\u001a\u00020a2\u0006\u0010?\u001a\u00020eH\u0086\u0004J\u0011\u0010~\u001a\u00020a2\u0006\u0010?\u001a\u00020tH\u0086\u0004J\u0011\u0010~\u001a\u00020a2\u0006\u0010?\u001a\u00020uH\u0086\u0004J\u0011\u0010~\u001a\u00020a2\u0006\u0010v\u001a\u00020\u0002H\u0086\u0004J\u0016\u0010~\u001a\u00020a2\u0006\u0010w\u001a\u00020\u00022\u0006\u0010x\u001a\u00020\u0002J&\u0010~\u001a\u00020a2\u0006\u0010@\u001a\u00020\u00022\u0006\u0010E\u001a\u00020\u00022\u0006\u0010L\u001a\u00020\u00022\u0006\u0010O\u001a\u00020\u0002J\u0011\u0010~\u001a\u00020a2\u0006\u00107\u001a\u000208H\u0086\u0004J\u001a\u0010\u007f\u001a\u00020a2\u0006\u0010\u0019\u001a\u00020\u00132\u0007\u0010\u0080\u0001\u001a\u00020eH\u0086\u0002J\"\u0010\u007f\u001a\u00020a2\u0006\u0010\u0019\u001a\u00020\u00132\u000f\u0010\u0080\u0001\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u000eH\u0096\u0002J\"\u0010\u007f\u001a\u00020a2\u0006\u0010j\u001a\u00020\u00132\u0006\u0010k\u001a\u00020\u00132\u0007\u0010\u0080\u0001\u001a\u00020\u0002H\u0096\u0002J\b\u0010W\u001a\u00020\u0013H\u0016J\u0012\u0010\u0081\u0001\u001a\u00020\u00002\u0006\u0010[\u001a\u00020\u0000H\u0086\u0006J\u0017\u0010\u0081\u0001\u001a\u00020\u00002\u0006\u0010[\u001a\u00020\u00002\u0006\u0010_\u001a\u00020\u0000J\u0014\u0010\u0081\u0001\u001a\u00030\u0082\u00012\u0007\u0010[\u001a\u00030\u0083\u0001H\u0086\u0006J\u0014\u0010\u0081\u0001\u001a\u00030\u0082\u00012\u0007\u0010[\u001a\u00030\u0084\u0001H\u0086\u0006J\u0012\u0010\u0081\u0001\u001a\u00020e2\u0006\u0010[\u001a\u00020eH\u0086\u0006J\u0019\u0010\u0081\u0001\u001a\u00020e2\u0006\u0010[\u001a\u00020e2\b\b\u0002\u0010_\u001a\u00020eJ\u0012\u0010\u0081\u0001\u001a\u00020\u00002\u0006\u0010[\u001a\u00020\u0002H\u0086\u0006J\u0017\u0010\u0081\u0001\u001a\u00020\u00002\u0006\u0010[\u001a\u00020\u00022\u0006\u0010_\u001a\u00020\u0000J\u0012\u0010\u0085\u0001\u001a\u00020a2\u0006\u0010[\u001a\u00020\u0000H\u0086\u0006J\u0012\u0010\u0085\u0001\u001a\u00020a2\u0006\u0010[\u001a\u00020eH\u0086\u0006J\u0012\u0010\u0085\u0001\u001a\u00020a2\u0006\u0010[\u001a\u00020\u0002H\u0086\u0006J\u001d\u0010\u0086\u0001\u001a\u00030\u0087\u00012\b\u0010\u0088\u0001\u001a\u00030\u0087\u00012\u0007\u0010\u0089\u0001\u001a\u00020\u0013H\u0016J\u001b\u0010\u0086\u0001\u001a\u00020\u001c2\u0007\u0010\u0088\u0001\u001a\u00020\u001c2\u0007\u0010\u0089\u0001\u001a\u00020\u0013H\u0016J\u001f\u0010\u0086\u0001\u001a\u00020a2\f\u0010\u001e\u001a\b0\u008a\u0001j\u0003`\u008b\u00012\b\b\u0002\u00109\u001a\u00020:J\u0012\u0010\u0086\u0001\u001a\u0002082\u0006\u00107\u001a\u000208H\u0086\u0004J\u0017\u0010\u0086\u0001\u001a\u0002082\u0006\u00107\u001a\u0002082\u0006\u0010\u0019\u001a\u00020\u0013J\u0007\u0010\u008c\u0001\u001a\u000208J\u0010\u00109\u001a\u00020\u00002\b\b\u0002\u0010_\u001a\u00020\u0000J\u0007\u0010\u008d\u0001\u001a\u00020\u0000J\n\u0010\u008e\u0001\u001a\u00020\u0000H\u0086\u0002J\n\u0010\u008f\u0001\u001a\u00020\u0000H\u0086\u0002R$\u0010@\u001a\u00020\u00022\u0006\u0010?\u001a\u00020\u00028V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bA\u0010B\"\u0004\bC\u0010DR$\u0010E\u001a\u00020\u00022\u0006\u0010?\u001a\u00020\u00028V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bF\u0010B\"\u0004\bG\u0010DR\u001a\u0010=\u001a\u000208X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR$\u0010L\u001a\u00020\u00022\u0006\u0010?\u001a\u00020\u00028V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bM\u0010B\"\u0004\bN\u0010DR$\u0010O\u001a\u00020\u00022\u0006\u0010?\u001a\u00020\u00028V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bP\u0010B\"\u0004\bQ\u0010DR\u0011\u0010R\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\bS\u0010TR\u0014\u0010U\u001a\u00020:8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bU\u0010VR\u0014\u0010W\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bX\u0010Y\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0091\u0001"}, d2={"Lglm_/mat2x2/Mat2;", "Lglm_/mat2x2/Mat2x2t;", "", "Lglm_/ToFloatBuffer;", "()V", "scalar", "", "(Ljava/lang/Number;)V", "x0", "y0", "x1", "y1", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "v0", "Lglm_/vec2/Vec2t;", "v1", "(Lglm_/vec2/Vec2t;Lglm_/vec2/Vec2t;)V", "block", "Lkotlin/Function1;", "", "(Lkotlin/jvm/functions/Function1;)V", "Lkotlin/Function2;", "(Lkotlin/jvm/functions/Function2;)V", "list", "", "index", "(Ljava/lang/Iterable;I)V", "buffer", "Ljava/nio/FloatBuffer;", "(Ljava/nio/FloatBuffer;I)V", "ptr", "Lkool/FloatPtr;", "(JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "mat2", "(Lglm_/mat2x2/Mat2;)V", "Lglm_/mat2x2/Mat2d;", "(Lglm_/mat2x2/Mat2d;)V", "mat3", "Lglm_/mat3x3/Mat3;", "(Lglm_/mat3x3/Mat3;)V", "mat4", "Lglm_/mat4x4/Mat4;", "(Lglm_/mat4x4/Mat4;)V", "mat2x3", "Lglm_/mat2x3/Mat2x3t;", "(Lglm_/mat2x3/Mat2x3t;)V", "mat3x2", "Lglm_/mat3x2/Mat3x2t;", "(Lglm_/mat3x2/Mat3x2t;)V", "mat2x4", "Lglm_/mat2x4/Mat2x4t;", "(Lglm_/mat2x4/Mat2x4t;)V", "mat4x2", "Lglm_/mat4x2/Mat4x2t;", "(Lglm_/mat4x2/Mat4x2t;)V", "floats", "", "transpose", "", "([FZ)V", "dummy", "array", "(I[F)V", "v", "a0", "getA0", "()Ljava/lang/Float;", "setA0", "(F)V", "a1", "getA1", "setA1", "getArray", "()[F", "setArray", "([F)V", "b0", "getB0", "setB0", "b1", "getB1", "setB1", "det", "getDet", "()F", "isIdentity", "()Z", "size", "getSize", "()I", "allEqual", "b", "epsilon", "anyNotEqual", "div", "res", "divAssign", "", "elementCount", "equal", "Lglm_/vec2/Vec2bool;", "Lglm_/vec2/Vec2;", "equals", "other", "", "get", "column", "row", "(II)Ljava/lang/Float;", "hashCode", "identity", "inverse", "inverseAssign", "invoke", "Lglm_/mat3x3/Mat3d;", "Lglm_/mat4x4/Mat4d;", "Lglm_/vec3/Vec3;", "Lglm_/vec4/Vec4;", "s", "x", "y", "minus", "minusAssign", "notEqual", "plus", "plusAssign", "put", "set", "value", "times", "", "Lglm_/mat3x2/Mat3x2;", "Lglm_/mat4x2/Mat4x2;", "timesAssign", "to", "Ljava/nio/ByteBuffer;", "buf", "offset", "", "Lkool/Ptr;", "toFloatArray", "transposeAssign", "unaryMinus", "unaryPlus", "Companion", "glm-jdk8"})
public final class Mat2
extends Mat2x2t<Float>
implements ToFloatBuffer {
    @NotNull
    private float[] array;
    public static final int length = 4;
    @JvmField
    public static final int size;
    public static final Companion Companion;

    @NotNull
    public Vec2 get(int index) {
        return new Vec2(index * 2, this.array);
    }

    @Override
    @NotNull
    public Float get(int column, int row) {
        return Float.valueOf(this.array[column * 2 + row]);
    }

    @Override
    public void set(int column, int row, float value) {
        this.array[column * 2 + row] = value;
    }

    @Override
    public void set(int index, @NotNull Vec2t<? extends Number> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.array[index * 2] = ExtensionsKt.getF(value.getX());
        this.array[index * 2 + 1] = ExtensionsKt.getF(value.getY());
    }

    public final void set(int index, @NotNull Vec2 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        value.to(this.array, index * 2);
    }

    @NotNull
    public final Mat2 invoke(float s) {
        return this.invoke(s, s);
    }

    @NotNull
    public final Mat2 invoke(@NotNull Vec2 v2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        return this.invoke(v2.getX().floatValue(), v2.getY().floatValue());
    }

    @NotNull
    public final Mat2 invoke(@NotNull Vec3 v2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        return this.invoke(v2.getX().floatValue(), v2.getY().floatValue());
    }

    @NotNull
    public final Mat2 invoke(@NotNull Vec4 v2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        return this.invoke(v2.getX().floatValue(), v2.getY().floatValue());
    }

    @NotNull
    public final Mat2 invoke(@NotNull float[] floats) {
        Intrinsics.checkNotNullParameter((Object)floats, (String)"floats");
        return this.invoke(floats[0], floats[1], floats[2], floats[3]);
    }

    @NotNull
    public final Mat2 invoke(@NotNull Mat2 mat2) {
        Intrinsics.checkNotNullParameter((Object)mat2, (String)"mat2");
        return this.invoke((float[])mat2.array.clone());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Mat2 invoke(@NotNull Mat2d mat2) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)mat2, (String)"mat2");
        int n = 4;
        Mat2 mat22 = this;
        float[] fArray2 = new float[n];
        int n2 = 0;
        while (n2 < n) {
            void it;
            float f2;
            int n3 = n2;
            int n4 = n2++;
            fArray = fArray2;
            boolean bl = false;
            fArray[n4] = f2 = ExtensionsKt.getF(mat2.getArray()[it]);
        }
        fArray = fArray2;
        return mat22.invoke(fArray);
    }

    @NotNull
    public final Mat2 invoke(@NotNull Mat3 mat3) {
        Intrinsics.checkNotNullParameter((Object)mat3, (String)"mat3");
        return this.invoke(mat3.get(0, 0).floatValue(), mat3.get(0, 1).floatValue(), mat3.get(1, 0).floatValue(), mat3.get(1, 1).floatValue());
    }

    @NotNull
    public final Mat2 invoke(@NotNull Mat3d mat3) {
        Intrinsics.checkNotNullParameter((Object)mat3, (String)"mat3");
        return this.invoke(ExtensionsKt.getF(mat3.get(0, 0)), ExtensionsKt.getF(mat3.get(0, 1)), ExtensionsKt.getF(mat3.get(1, 0)), ExtensionsKt.getF(mat3.get(1, 1)));
    }

    @NotNull
    public final Mat2 invoke(@NotNull Mat4 mat4) {
        Intrinsics.checkNotNullParameter((Object)mat4, (String)"mat4");
        return this.invoke(mat4.get(0, 0).floatValue(), mat4.get(0, 1).floatValue(), mat4.get(1, 0).floatValue(), mat4.get(1, 1).floatValue());
    }

    @NotNull
    public final Mat2 invoke(@NotNull Mat4d mat4) {
        Intrinsics.checkNotNullParameter((Object)mat4, (String)"mat4");
        return this.invoke(ExtensionsKt.getF(mat4.get(0, 0)), ExtensionsKt.getF(mat4.get(0, 1)), ExtensionsKt.getF(mat4.get(1, 0)), ExtensionsKt.getF(mat4.get(1, 1)));
    }

    @NotNull
    public final Mat2 invoke(float x, float y) {
        return this.invoke(x, 0.0f, 0.0f, y);
    }

    @NotNull
    public final Mat2 invoke(@NotNull Number x, @NotNull Number y) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        return this.invoke(ExtensionsKt.getF(x), 0.0f, 0.0f, ExtensionsKt.getF(y));
    }

    @NotNull
    public final Mat2 invoke(float a0, float a1, float b0, float b1) {
        this.put(a0, a1, b0, b1);
        return this;
    }

    @NotNull
    public final Mat2 invoke(@NotNull Number a0, @NotNull Number a1, @NotNull Number b0, @NotNull Number b1) {
        Intrinsics.checkNotNullParameter((Object)a0, (String)"a0");
        Intrinsics.checkNotNullParameter((Object)a1, (String)"a1");
        Intrinsics.checkNotNullParameter((Object)b0, (String)"b0");
        Intrinsics.checkNotNullParameter((Object)b1, (String)"b1");
        this.put(ExtensionsKt.getF(a0), ExtensionsKt.getF(a1), ExtensionsKt.getF(b0), ExtensionsKt.getF(b1));
        return this;
    }

    public final void put(@NotNull Mat2 mat2) {
        Intrinsics.checkNotNullParameter((Object)mat2, (String)"mat2");
        System.arraycopy(mat2.array.clone(), 0, this.array, 0, 4);
    }

    @NotNull
    public final Mat2 identity() {
        return this.invoke(1.0f);
    }

    public final void put(float s) {
        this.put(s, s);
    }

    public final void put(@NotNull Vec2 v2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        this.put(v2.getX().floatValue(), v2.getY().floatValue());
    }

    public final void put(@NotNull Vec3 v2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        this.put(v2.getX().floatValue(), v2.getY().floatValue());
    }

    public final void put(@NotNull Vec4 v2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        this.put(v2.getX().floatValue(), v2.getY().floatValue());
    }

    public final void put(@NotNull float[] floats) {
        Intrinsics.checkNotNullParameter((Object)floats, (String)"floats");
        this.put(floats[0], floats[1], floats[2], floats[3]);
    }

    public final void put(float x, float y) {
        this.put(x, 0.0f, 0.0f, y);
    }

    public final void put(float a0, float a1, float b0, float b1) {
        this.array[0] = a0;
        this.array[1] = a1;
        this.array[4] = b0;
        this.array[5] = b1;
    }

    public final float getDet() {
        return glm.INSTANCE.determinant(this);
    }

    @NotNull
    public final Mat2 inverse(@NotNull Mat2 res2) {
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return glm.INSTANCE.inverse(res2, this);
    }

    public static /* synthetic */ Mat2 inverse$default(Mat2 mat2, Mat2 mat22, int n, Object object) {
        if ((n & 1) != 0) {
            mat22 = new Mat2();
        }
        return mat2.inverse(mat22);
    }

    @NotNull
    public final Mat2 inverseAssign() {
        return glm.INSTANCE.inverse(this, this);
    }

    @NotNull
    public final Mat2 transpose(@NotNull Mat2 res2) {
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return glm.INSTANCE.transpose(res2, this);
    }

    public static /* synthetic */ Mat2 transpose$default(Mat2 mat2, Mat2 mat22, int n, Object object) {
        if ((n & 1) != 0) {
            mat22 = new Mat2();
        }
        return mat2.transpose(mat22);
    }

    @NotNull
    public final Mat2 transposeAssign() {
        return glm.INSTANCE.transpose(this, this);
    }

    @NotNull
    public final float[] toFloatArray() {
        return this.to(new float[4], 0);
    }

    @NotNull
    public final float[] to(@NotNull float[] floats) {
        Intrinsics.checkNotNullParameter((Object)floats, (String)"floats");
        return this.to(floats, 0);
    }

    @NotNull
    public final float[] to(@NotNull float[] floats, int index) {
        Intrinsics.checkNotNullParameter((Object)floats, (String)"floats");
        System.arraycopy(this.array, 0, floats, index, 4);
        return floats;
    }

    @Override
    @NotNull
    public ByteBuffer to(@NotNull ByteBuffer buf, int offset) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        ByteBuffer byteBuffer = buf.putFloat(offset + 0 * UtilsKt.getBYTES(FloatCompanionObject.INSTANCE), this.array[0]).putFloat(offset + 1 * UtilsKt.getBYTES(FloatCompanionObject.INSTANCE), this.array[1]).putFloat(offset + 2 * UtilsKt.getBYTES(FloatCompanionObject.INSTANCE), this.array[2]).putFloat(offset + 3 * UtilsKt.getBYTES(FloatCompanionObject.INSTANCE), this.array[3]);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"buf\n                .put\u2026 * Float.BYTES, array[3])");
        return byteBuffer;
    }

    @Override
    @NotNull
    public FloatBuffer to(@NotNull FloatBuffer buf, int offset) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Buffers_operatorsKt.set(buf, offset + 0, this.array[0]);
        Buffers_operatorsKt.set(buf, offset + 1, this.array[1]);
        Buffers_operatorsKt.set(buf, offset + 2, this.array[2]);
        Buffers_operatorsKt.set(buf, offset + 3, this.array[3]);
        return buf;
    }

    public final void to(long ptr, boolean transpose) {
        if (transpose) {
            MemoryUtil.memPutFloat((long)ptr, (float)this.get(0, 0).floatValue());
            MemoryUtil.memPutFloat((long)(ptr + (long)UtilsKt.getBYTES(FloatCompanionObject.INSTANCE)), (float)this.get(1, 0).floatValue());
            MemoryUtil.memPutFloat((long)(ptr + (long)(UtilsKt.getBYTES(FloatCompanionObject.INSTANCE) * 2)), (float)this.get(0, 1).floatValue());
            MemoryUtil.memPutFloat((long)(ptr + (long)(UtilsKt.getBYTES(FloatCompanionObject.INSTANCE) * 3)), (float)this.get(1, 1).floatValue());
        } else {
            MemoryUtil.memPutFloat((long)ptr, (float)this.get(0, 0).floatValue());
            MemoryUtil.memPutFloat((long)(ptr + (long)UtilsKt.getBYTES(FloatCompanionObject.INSTANCE)), (float)this.get(0, 1).floatValue());
            MemoryUtil.memPutFloat((long)(ptr + (long)(UtilsKt.getBYTES(FloatCompanionObject.INSTANCE) * 2)), (float)this.get(1, 0).floatValue());
            MemoryUtil.memPutFloat((long)(ptr + (long)(UtilsKt.getBYTES(FloatCompanionObject.INSTANCE) * 3)), (float)this.get(1, 1).floatValue());
        }
    }

    public static /* synthetic */ void to$default(Mat2 mat2, long l, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        mat2.to(l, bl);
    }

    @NotNull
    public final Mat2 unaryPlus() {
        return this;
    }

    @NotNull
    public final Mat2 unaryMinus() {
        return new Mat2(Float.valueOf(-this.array[0]), Float.valueOf(-this.array[1]), Float.valueOf(-this.array[3]), Float.valueOf(-this.array[4]));
    }

    @NotNull
    public final Mat2 plus(@NotNull Mat2 b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.plus(new Mat2(), this, b);
    }

    @NotNull
    public final Mat2 plus(float b) {
        return Companion.plus(new Mat2(), this, b);
    }

    @NotNull
    public final Mat2 plus(@NotNull Mat2 b, @NotNull Mat2 res2) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return Companion.plus(res2, this, b);
    }

    @NotNull
    public final Mat2 plus(float b, @NotNull Mat2 res2) {
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return Companion.plus(res2, this, b);
    }

    public final void plusAssign(@NotNull Mat2 b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Companion.plus(this, this, b);
    }

    public final void plusAssign(float b) {
        Companion.plus(this, this, b);
    }

    @NotNull
    public final Mat2 minus(@NotNull Mat2 b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.minus(new Mat2(), this, b);
    }

    @NotNull
    public final Mat2 minus(float b) {
        return Companion.minus(new Mat2(), this, b);
    }

    @NotNull
    public final Mat2 minus(@NotNull Mat2 b, @NotNull Mat2 res2) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return Companion.minus(res2, this, b);
    }

    @NotNull
    public final Mat2 minus(float b, @NotNull Mat2 res2) {
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return Companion.minus(res2, this, b);
    }

    public final void minusAssign(@NotNull Mat2 b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Companion.minus(this, this, b);
    }

    public final void minusAssign(float b) {
        Companion.minus(this, this, b);
    }

    @NotNull
    public final Mat2 times(@NotNull Mat2 b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.times(new Mat2(), this, b);
    }

    @NotNull
    public final Void times(@NotNull Mat3x2 b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        boolean bl = false;
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Void times(@NotNull Mat4x2 b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        boolean bl = false;
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final Vec2 times(@NotNull Vec2 b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.times(new Vec2(), this, b);
    }

    @NotNull
    public final Mat2 times(float b) {
        return Companion.times(new Mat2(), this, b);
    }

    @NotNull
    public final Mat2 times(@NotNull Mat2 b, @NotNull Mat2 res2) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return Companion.times(res2, this, b);
    }

    @NotNull
    public final Mat2 times(float b, @NotNull Mat2 res2) {
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return Companion.times(res2, this, b);
    }

    @NotNull
    public final Vec2 times(@NotNull Vec2 b, @NotNull Vec2 res2) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return Companion.times(res2, this, b);
    }

    public static /* synthetic */ Vec2 times$default(Mat2 mat2, Vec2 vec2, Vec2 vec22, int n, Object object) {
        if ((n & 2) != 0) {
            vec22 = new Vec2();
        }
        return mat2.times(vec2, vec22);
    }

    public final void timesAssign(@NotNull Mat2 b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Companion.times(this, this, b);
    }

    public final void timesAssign(float b) {
        Companion.times(this, this, b);
    }

    public final void timesAssign(@NotNull Vec2 b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Companion.times(b, this, b);
    }

    @NotNull
    public final Mat2 div(@NotNull Mat2 b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.div(new Mat2(), this, b);
    }

    @NotNull
    public final Mat2 div(float b) {
        return Companion.div(new Mat2(), this, b);
    }

    @NotNull
    public final Mat2 div(@NotNull Mat2 b, @NotNull Mat2 res2) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return Companion.div(res2, this, b);
    }

    @NotNull
    public final Mat2 div(float b, @NotNull Mat2 res2) {
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return Companion.div(res2, this, b);
    }

    public final void divAssign(@NotNull Mat2 b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Companion.div(this, this, b);
    }

    public final void divAssign(float b) {
        Companion.div(this, this, b);
    }

    @Override
    @NotNull
    public Float getA0() {
        return Float.valueOf(this.array[0]);
    }

    @Override
    public void setA0(float v2) {
        this.array[0] = v2;
    }

    @Override
    @NotNull
    public Float getA1() {
        return Float.valueOf(this.array[1]);
    }

    @Override
    public void setA1(float v2) {
        this.array[1] = v2;
    }

    @Override
    @NotNull
    public Float getB0() {
        return Float.valueOf(this.array[2]);
    }

    @Override
    public void setB0(float v2) {
        this.array[2] = v2;
    }

    @Override
    @NotNull
    public Float getB1() {
        return Float.valueOf(this.array[3]);
    }

    @Override
    public void setB1(float v2) {
        this.array[3] = v2;
    }

    @Override
    public boolean isIdentity() {
        return this.get(0, 0).floatValue() == 1.0f && this.get(1, 0).floatValue() == 0.0f && this.get(0, 1).floatValue() == 0.0f && this.get(1, 1).floatValue() == 1.0f;
    }

    @Override
    public int size() {
        return this.getSize();
    }

    @Override
    public int getSize() {
        return size;
    }

    @Override
    public int elementCount() {
        return 4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Mat2)) return false;
        float[] fArray = this.array;
        float[] fArray2 = ((Mat2)other).array;
        boolean bl = false;
        if (!Arrays.equals(fArray, fArray2)) return false;
        return true;
    }

    public int hashCode() {
        return 31 * this.get(0).hashCode() + this.get(1).hashCode();
    }

    @NotNull
    public final Vec2bool equal(@NotNull Mat2 b, float epsilon2, @NotNull Vec2bool res2) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return glm.INSTANCE.equal(this, b, epsilon2, res2);
    }

    public static /* synthetic */ Vec2bool equal$default(Mat2 mat2, Mat2 mat22, float f2, Vec2bool vec2bool, int n, Object object) {
        if ((n & 4) != 0) {
            vec2bool = new Vec2bool(false, false, 3, null);
        }
        return mat2.equal(mat22, f2, vec2bool);
    }

    @NotNull
    public final Vec2bool equal(@NotNull Mat2 b, @NotNull Vec2 epsilon2, @NotNull Vec2bool res2) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)epsilon2, (String)"epsilon");
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return glm.INSTANCE.equal(this, b, epsilon2, res2);
    }

    public static /* synthetic */ Vec2bool equal$default(Mat2 mat2, Mat2 mat22, Vec2 vec2, Vec2bool vec2bool, int n, Object object) {
        if ((n & 4) != 0) {
            vec2bool = new Vec2bool(false, false, 3, null);
        }
        return mat2.equal(mat22, vec2, vec2bool);
    }

    @NotNull
    public final Vec2bool notEqual(@NotNull Mat2 b, float epsilon2, @NotNull Vec2bool res2) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return glm.INSTANCE.notEqual(this, b, epsilon2, res2);
    }

    public static /* synthetic */ Vec2bool notEqual$default(Mat2 mat2, Mat2 mat22, float f2, Vec2bool vec2bool, int n, Object object) {
        if ((n & 4) != 0) {
            vec2bool = new Vec2bool(false, false, 3, null);
        }
        return mat2.notEqual(mat22, f2, vec2bool);
    }

    @NotNull
    public final Vec2bool notEqual(@NotNull Mat2 b, @NotNull Vec2 epsilon2, @NotNull Vec2bool res2) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)epsilon2, (String)"epsilon");
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return glm.INSTANCE.notEqual(this, b, epsilon2, res2);
    }

    public static /* synthetic */ Vec2bool notEqual$default(Mat2 mat2, Mat2 mat22, Vec2 vec2, Vec2bool vec2bool, int n, Object object) {
        if ((n & 4) != 0) {
            vec2bool = new Vec2bool(false, false, 3, null);
        }
        return mat2.notEqual(mat22, vec2, vec2bool);
    }

    public final boolean allEqual(@NotNull Mat2 b, float epsilon2) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return glm.INSTANCE.allEqual(this, b, epsilon2);
    }

    public static /* synthetic */ boolean allEqual$default(Mat2 mat2, Mat2 mat22, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            f2 = glm.INSTANCE.get\u03b5f();
        }
        return mat2.allEqual(mat22, f2);
    }

    public final boolean anyNotEqual(@NotNull Mat2 b, float epsilon2) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return glm.INSTANCE.anyNotEqual(this, b, epsilon2);
    }

    public static /* synthetic */ boolean anyNotEqual$default(Mat2 mat2, Mat2 mat22, float f2, int n, Object object) {
        if ((n & 2) != 0) {
            f2 = glm.INSTANCE.get\u03b5f();
        }
        return mat2.anyNotEqual(mat22, f2);
    }

    @NotNull
    public final float[] getArray() {
        return this.array;
    }

    public final void setArray(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.array = fArray;
    }

    private Mat2(int dummy, float[] array) {
        this.array = array;
    }

    public Mat2() {
        this(1, (Number)0, (Number)0, 1);
    }

    public Mat2(@NotNull Number scalar) {
        Intrinsics.checkNotNullParameter((Object)scalar, (String)"scalar");
        this(scalar, (Number)0, (Number)0, scalar);
    }

    public Mat2(@NotNull Number x0, @NotNull Number y0, @NotNull Number x1, @NotNull Number y1) {
        Intrinsics.checkNotNullParameter((Object)x0, (String)"x0");
        Intrinsics.checkNotNullParameter((Object)y0, (String)"y0");
        Intrinsics.checkNotNullParameter((Object)x1, (String)"x1");
        Intrinsics.checkNotNullParameter((Object)y1, (String)"y1");
        this(0, new float[]{ExtensionsKt.getF(x0), ExtensionsKt.getF(y0), ExtensionsKt.getF(x1), ExtensionsKt.getF(y1)});
    }

    public Mat2(@NotNull Vec2t<? extends Number> v0, @NotNull Vec2t<? extends Number> v1) {
        Intrinsics.checkNotNullParameter(v0, (String)"v0");
        Intrinsics.checkNotNullParameter(v1, (String)"v1");
        this(v0.getX(), v0.getY(), v1.getX(), v1.getY());
    }

    public Mat2(@NotNull Function1<? super Integer, ? extends Number> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this(Float.valueOf(ExtensionsKt.getF((Number)block.invoke((Object)0))), Float.valueOf(ExtensionsKt.getF((Number)block.invoke((Object)1))), Float.valueOf(ExtensionsKt.getF((Number)block.invoke((Object)2))), Float.valueOf(ExtensionsKt.getF((Number)block.invoke((Object)3))));
    }

    public Mat2(@NotNull Function2<? super Integer, ? super Integer, ? extends Number> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this(Float.valueOf(ExtensionsKt.getF((Number)block.invoke((Object)0, (Object)0))), Float.valueOf(ExtensionsKt.getF((Number)block.invoke((Object)0, (Object)1))), Float.valueOf(ExtensionsKt.getF((Number)block.invoke((Object)1, (Object)0))), Float.valueOf(ExtensionsKt.getF((Number)block.invoke((Object)1, (Object)1))));
    }

    public Mat2(@NotNull Iterable<?> list2, int index) {
        Intrinsics.checkNotNullParameter(list2, (String)"list");
        Object object = CollectionsKt.elementAt(list2, (int)index);
        Intrinsics.checkNotNull((Object)object);
        Number number = Float.valueOf(ExtensionsKt.getToFloat(object));
        Object object2 = CollectionsKt.elementAt(list2, (int)(index + 1));
        Intrinsics.checkNotNull((Object)object2);
        Number number2 = Float.valueOf(ExtensionsKt.getToFloat(object2));
        Object object3 = CollectionsKt.elementAt(list2, (int)(index + 2));
        Intrinsics.checkNotNull((Object)object3);
        Number number3 = Float.valueOf(ExtensionsKt.getToFloat(object3));
        Object object4 = CollectionsKt.elementAt(list2, (int)(index + 3));
        Intrinsics.checkNotNull((Object)object4);
        this(number, number2, number3, Float.valueOf(ExtensionsKt.getToFloat(object4)));
    }

    public /* synthetic */ Mat2(Iterable iterable, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(iterable, n);
    }

    public Mat2(@NotNull FloatBuffer buffer2, int index) {
        Intrinsics.checkNotNullParameter((Object)buffer2, (String)"buffer");
        this(Float.valueOf(buffer2.get(index)), Float.valueOf(buffer2.get(index + 1)), Float.valueOf(buffer2.get(index + 2)), Float.valueOf(buffer2.get(index + 3)));
    }

    public /* synthetic */ Mat2(FloatBuffer floatBuffer, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            Buffer $this$pos$iv = floatBuffer;
            boolean $i$f$getPos = false;
            n = $this$pos$iv.position();
        }
        this(floatBuffer, n);
    }

    private Mat2(final long ptr) {
        this((Function1<? super Integer, ? extends Number>)((Function1)new Function1<Integer, Number>(){

            @NotNull
            public final Number invoke(int i2) {
                long $this$iv = ptr;
                boolean $i$f$get = false;
                return Float.valueOf(PointersKt.getUNSAFE().getFloat(null, $this$iv + (long)(i2 * UtilsKt.getBYTES(FloatCompanionObject.INSTANCE))));
            }
        }));
    }

    public Mat2(@NotNull Mat2 mat2) {
        Intrinsics.checkNotNullParameter((Object)mat2, (String)"mat2");
        this(0, (float[])mat2.array.clone());
    }

    /*
     * WARNING - void declaration
     */
    public Mat2(@NotNull Mat2d mat2) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)mat2, (String)"mat2");
        int n = 4;
        int n2 = 0;
        Mat2 mat22 = this;
        float[] fArray2 = new float[n];
        int n3 = 0;
        while (n3 < n) {
            void it;
            float f2;
            int n4 = n3;
            int n5 = n3++;
            fArray = fArray2;
            boolean bl = false;
            fArray[n5] = f2 = ExtensionsKt.getF(mat2.getArray()[it]);
        }
        fArray = fArray2;
        mat22(n2, fArray);
    }

    public Mat2(@NotNull Mat3 mat3) {
        Intrinsics.checkNotNullParameter((Object)mat3, (String)"mat3");
        this(mat3.get(0, 0), mat3.get(0, 1), mat3.get(1, 0), mat3.get(1, 1));
    }

    public Mat2(@NotNull Mat4 mat4) {
        Intrinsics.checkNotNullParameter((Object)mat4, (String)"mat4");
        this(mat4.get(0, 0), mat4.get(0, 1), mat4.get(1, 0), mat4.get(1, 1));
    }

    public Mat2(@NotNull Mat2x3t<?> mat2x3) {
        Intrinsics.checkNotNullParameter(mat2x3, (String)"mat2x3");
        this((Number)mat2x3.get(0, 0), (Number)mat2x3.get(0, 1), (Number)mat2x3.get(1, 0), (Number)mat2x3.get(1, 1));
    }

    public Mat2(@NotNull Mat3x2t<?> mat3x2) {
        Intrinsics.checkNotNullParameter(mat3x2, (String)"mat3x2");
        this((Number)mat3x2.get(0, 0), (Number)mat3x2.get(0, 1), (Number)mat3x2.get(1, 0), (Number)mat3x2.get(1, 1));
    }

    public Mat2(@NotNull Mat2x4t<?> mat2x4) {
        Intrinsics.checkNotNullParameter(mat2x4, (String)"mat2x4");
        this((Number)mat2x4.get(0, 0), (Number)mat2x4.get(0, 1), (Number)mat2x4.get(1, 0), (Number)mat2x4.get(1, 1));
    }

    public Mat2(@NotNull Mat4x2t<?> mat4x2) {
        Intrinsics.checkNotNullParameter(mat4x2, (String)"mat4x2");
        this((Number)mat4x2.get(0, 0), (Number)mat4x2.get(0, 1), (Number)mat4x2.get(1, 0), (Number)mat4x2.get(1, 1));
    }

    @JvmOverloads
    public Mat2(@NotNull float[] floats, boolean transpose) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)floats, (String)"floats");
        if (transpose) {
            float[] fArray2 = new float[4];
            fArray2[0] = floats[0];
            fArray2[1] = floats[3];
            fArray2[2] = floats[1];
            fArray = fArray2;
            fArray2[3] = floats[4];
        } else {
            fArray = (float[])floats.clone();
        }
        this(0, fArray);
    }

    public /* synthetic */ Mat2(float[] fArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(fArray, bl);
    }

    @JvmOverloads
    public Mat2(@NotNull float[] floats) {
        this(floats, false, 2, null);
    }

    static {
        Companion = new Companion(null);
        size = 4 * UtilsKt.getBYTES(FloatCompanionObject.INSTANCE);
    }

    @Override
    @NotNull
    public FloatBuffer to(@NotNull FloatBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return ToFloatBuffer.DefaultImpls.to((ToFloatBuffer)this, buf);
    }

    @Override
    @NotNull
    public FloatBuffer toFloatBufferStack() {
        return ToFloatBuffer.DefaultImpls.toFloatBufferStack(this);
    }

    @Override
    @NotNull
    public FloatBuffer toFloatBuffer(@NotNull MemoryStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return ToFloatBuffer.DefaultImpls.toFloatBuffer(this, stack);
    }

    @Override
    @NotNull
    public FloatBuffer toFloatBuffer() {
        return ToFloatBuffer.DefaultImpls.toFloatBuffer(this);
    }

    public /* synthetic */ Mat2(long ptr, DefaultConstructorMarker $constructor_marker) {
        this(ptr);
    }

    @JvmStatic
    @NotNull
    public static final Mat2 fromPointer(long ptr, boolean transpose) {
        return Companion.fromPointer(ptr, transpose);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\n\u001a\u00020\u00042\n\u0010\u000b\u001a\u00060\fj\u0002`\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lglm_/mat2x2/Mat2$Companion;", "Lglm_/mat2x2/operators/mat2x2_operators;", "()V", "identity", "Lglm_/mat2x2/Mat2;", "getIdentity", "()Lglm_/mat2x2/Mat2;", "length", "", "size", "fromPointer", "ptr", "", "Lkool/Ptr;", "transpose", "", "glm-jdk8"})
    public static final class Companion
    implements mat2x2_operators {
        @JvmStatic
        @NotNull
        public final Mat2 fromPointer(long ptr, boolean transpose) {
            return transpose ? new Mat2(Float.valueOf(MemoryUtil.memGetFloat((long)ptr)), Float.valueOf(MemoryUtil.memGetFloat((long)(ptr + (long)(UtilsKt.getBYTES(FloatCompanionObject.INSTANCE) * 2)))), Float.valueOf(MemoryUtil.memGetFloat((long)(ptr + (long)UtilsKt.getBYTES(FloatCompanionObject.INSTANCE)))), Float.valueOf(MemoryUtil.memGetFloat((long)(ptr + (long)(UtilsKt.getBYTES(FloatCompanionObject.INSTANCE) * 3))))) : new Mat2(Float.valueOf(MemoryUtil.memGetFloat((long)ptr)), Float.valueOf(MemoryUtil.memGetFloat((long)(ptr + (long)UtilsKt.getBYTES(FloatCompanionObject.INSTANCE)))), Float.valueOf(MemoryUtil.memGetFloat((long)(ptr + (long)(UtilsKt.getBYTES(FloatCompanionObject.INSTANCE) * 2)))), Float.valueOf(MemoryUtil.memGetFloat((long)(ptr + (long)(UtilsKt.getBYTES(FloatCompanionObject.INSTANCE) * 3)))));
        }

        public static /* synthetic */ Mat2 fromPointer$default(Companion companion, long l, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.fromPointer(l, bl);
        }

        @NotNull
        public final Mat2 getIdentity() {
            return new Mat2(Float.valueOf(1.0f));
        }

        private Companion() {
        }

        @Override
        @NotNull
        public Mat2 plus(@NotNull Mat2 res2, @NotNull Mat2 a, float b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return mat2x2_operators.DefaultImpls.plus((mat2x2_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public Mat2 plus(@NotNull Mat2 res2, @NotNull Mat2 a, @NotNull Mat2 b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return mat2x2_operators.DefaultImpls.plus((mat2x2_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public Mat2 plus(@NotNull Mat2 res2, @NotNull Mat2 a, @NotNull Vec2 b0, @NotNull Vec2 b1) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b0, (String)"b0");
            Intrinsics.checkNotNullParameter((Object)b1, (String)"b1");
            return mat2x2_operators.DefaultImpls.plus(this, res2, a, b0, b1);
        }

        @Override
        @NotNull
        public Mat2 plus(@NotNull Mat2 res2, @NotNull Mat2 a, float b00, float b01, float b10, float b11) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return mat2x2_operators.DefaultImpls.plus(this, res2, a, b00, b01, b10, b11);
        }

        @Override
        @NotNull
        public Mat2 minus(@NotNull Mat2 res2, @NotNull Mat2 a, float b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return mat2x2_operators.DefaultImpls.minus((mat2x2_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public Mat2 minus(@NotNull Mat2 res2, float a, @NotNull Mat2 b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return mat2x2_operators.DefaultImpls.minus((mat2x2_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public Mat2 minus(@NotNull Mat2 res2, @NotNull Mat2 a, @NotNull Mat2 b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return mat2x2_operators.DefaultImpls.minus((mat2x2_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public Mat2 minus(@NotNull Mat2 res2, @NotNull Mat2 a, @NotNull Vec2 b0, @NotNull Vec2 b1) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b0, (String)"b0");
            Intrinsics.checkNotNullParameter((Object)b1, (String)"b1");
            return mat2x2_operators.DefaultImpls.minus((mat2x2_operators)this, res2, a, b0, b1);
        }

        @Override
        @NotNull
        public Mat2 minus(@NotNull Mat2 res2, @NotNull Mat2 a, float b00, float b01, float b10, float b11) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return mat2x2_operators.DefaultImpls.minus((mat2x2_operators)this, res2, a, b00, b01, b10, b11);
        }

        @Override
        @NotNull
        public Mat2 minus(@NotNull Mat2 res2, @NotNull Vec2 a0, @NotNull Vec2 a1, @NotNull Mat2 b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a0, (String)"a0");
            Intrinsics.checkNotNullParameter((Object)a1, (String)"a1");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return mat2x2_operators.DefaultImpls.minus((mat2x2_operators)this, res2, a0, a1, b);
        }

        @Override
        @NotNull
        public Mat2 minus(@NotNull Mat2 res2, float a00, float a01, float a10, float a11, @NotNull Mat2 b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return mat2x2_operators.DefaultImpls.minus((mat2x2_operators)this, res2, a00, a01, a10, a11, b);
        }

        @Override
        @NotNull
        public Mat2 times(@NotNull Mat2 res2, @NotNull Mat2 a, float b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return mat2x2_operators.DefaultImpls.times((mat2x2_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public Vec2 times(@NotNull Vec2 res2, @NotNull Mat2 a, @NotNull Vec2 b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return mat2x2_operators.DefaultImpls.times((mat2x2_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public Vec2 times(@NotNull Vec2 res2, @NotNull Mat2 a, float b0, float b1) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return mat2x2_operators.DefaultImpls.times((mat2x2_operators)this, res2, a, b0, b1);
        }

        @Override
        @NotNull
        public Vec2 times(@NotNull Vec2 res2, @NotNull Vec2 a, @NotNull Mat2 b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return mat2x2_operators.DefaultImpls.times((mat2x2_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public Vec2 times(@NotNull Vec2 res2, float a0, float a1, @NotNull Mat2 b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return mat2x2_operators.DefaultImpls.times((mat2x2_operators)this, res2, a0, a1, b);
        }

        @Override
        @NotNull
        public Mat2 times(@NotNull Mat2 res2, @NotNull Mat2 a, @NotNull Mat2 b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return mat2x2_operators.DefaultImpls.times((mat2x2_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public Mat2 times(@NotNull Mat2 res2, @NotNull Mat2 a, @NotNull Vec2 b0, @NotNull Vec2 b1) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b0, (String)"b0");
            Intrinsics.checkNotNullParameter((Object)b1, (String)"b1");
            return mat2x2_operators.DefaultImpls.times((mat2x2_operators)this, res2, a, b0, b1);
        }

        @Override
        @NotNull
        public Mat2 times(@NotNull Mat2 res2, @NotNull Mat2 a, float b00, float b01, float b10, float b11) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return mat2x2_operators.DefaultImpls.times((mat2x2_operators)this, res2, a, b00, b01, b10, b11);
        }

        @Override
        @NotNull
        public Mat3x2 times(@NotNull Mat3x2 res2, @NotNull Mat2 a, @NotNull Mat3x2 b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return mat2x2_operators.DefaultImpls.times((mat2x2_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public Mat3x2 times(@NotNull Mat3x2 res2, @NotNull Mat2 a, @NotNull Vec2 b0, @NotNull Vec2 b1, @NotNull Vec2 b2) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b0, (String)"b0");
            Intrinsics.checkNotNullParameter((Object)b1, (String)"b1");
            Intrinsics.checkNotNullParameter((Object)b2, (String)"b2");
            return mat2x2_operators.DefaultImpls.times(this, res2, a, b0, b1, b2);
        }

        @Override
        @NotNull
        public Mat3x2 times(@NotNull Mat3x2 res2, @NotNull Mat2 a, float b00, float b01, float b10, float b11, float b20, float b21) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return mat2x2_operators.DefaultImpls.times(this, res2, a, b00, b01, b10, b11, b20, b21);
        }

        @Override
        @NotNull
        public Mat4x2 times(@NotNull Mat4x2 res2, @NotNull Mat2 a, @NotNull Mat4x2 b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return mat2x2_operators.DefaultImpls.times((mat2x2_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public Mat4x2 times(@NotNull Mat4x2 res2, @NotNull Mat2 a, @NotNull Vec2 b0, @NotNull Vec2 b1, @NotNull Vec2 b2, @NotNull Vec2 b3) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b0, (String)"b0");
            Intrinsics.checkNotNullParameter((Object)b1, (String)"b1");
            Intrinsics.checkNotNullParameter((Object)b2, (String)"b2");
            Intrinsics.checkNotNullParameter((Object)b3, (String)"b3");
            return mat2x2_operators.DefaultImpls.times((mat2x2_operators)this, res2, a, b0, b1, b2, b3);
        }

        @Override
        @NotNull
        public Mat4x2 times(@NotNull Mat4x2 res2, @NotNull Mat2 a, float b00, float b01, float b10, float b11, float b20, float b21, float b30, float b31) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return mat2x2_operators.DefaultImpls.times(this, res2, a, b00, b01, b10, b11, b20, b21, b30, b31);
        }

        @Override
        @NotNull
        public Mat2 div(@NotNull Mat2 res2, @NotNull Mat2 a, float b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return mat2x2_operators.DefaultImpls.div((mat2x2_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public Mat2 div(@NotNull Mat2 res2, float a, @NotNull Mat2 b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return mat2x2_operators.DefaultImpls.div((mat2x2_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public Mat2 div(@NotNull Mat2 res2, @NotNull Mat2 a, @NotNull Mat2 b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return mat2x2_operators.DefaultImpls.div((mat2x2_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public Mat2 div(@NotNull Mat2 res2, @NotNull Mat2 a, @NotNull Vec2 b0, @NotNull Vec2 b1) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b0, (String)"b0");
            Intrinsics.checkNotNullParameter((Object)b1, (String)"b1");
            return mat2x2_operators.DefaultImpls.div((mat2x2_operators)this, res2, a, b0, b1);
        }

        @Override
        @NotNull
        public Mat2 div(@NotNull Mat2 res2, @NotNull Mat2 a, float b00, float b01, float b10, float b11) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return mat2x2_operators.DefaultImpls.div(this, res2, a, b00, b01, b10, b11);
        }

        @Override
        @NotNull
        public Vec2 div(@NotNull Vec2 res2, @NotNull Mat2 a, @NotNull Vec2 b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return mat2x2_operators.DefaultImpls.div((mat2x2_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public Vec2 div(@NotNull Vec2 res2, @NotNull Mat2 a, float b0, float b1) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return mat2x2_operators.DefaultImpls.div((mat2x2_operators)this, res2, a, b0, b1);
        }

        @Override
        @NotNull
        public Vec2 div(@NotNull Vec2 res2, @NotNull Vec2 a, @NotNull Mat2 b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return mat2x2_operators.DefaultImpls.div((mat2x2_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public Vec2 div(@NotNull Vec2 res2, float a0, float a1, @NotNull Mat2 b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return mat2x2_operators.DefaultImpls.div((mat2x2_operators)this, res2, a0, a1, b);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

