/*
 * Decompiled with CFR 0.152.
 */
package glm_.quat;

import glm_.ExtensionsKt;
import glm_.glm;
import glm_.gtc.gtc_Quaternion;
import glm_.mat3x3.Mat3;
import glm_.mat3x3.Mat3d;
import glm_.mat4x4.Mat4;
import glm_.mat4x4.Mat4d;
import glm_.quat.Quat;
import glm_.quat.QuatT;
import glm_.quat.quatD_operators;
import glm_.vec3.Vec3;
import glm_.vec3.Vec3d;
import glm_.vec4.Vec4bool;
import glm_.vec4.Vec4d;
import glm_.vec4.Vec4t;
import java.io.PrintStream;
import kool.PointersKt;
import kool.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 [2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001[B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u0017\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000eB\u001b\b\u0016\u0012\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00020\u0010\u00a2\u0006\u0002\u0010\u0012B\u000f\b\u0016\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015B\u000f\b\u0016\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0019B'\b\u0016\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001b\u0012\u0006\u0010\u001d\u001a\u00020\u001b\u0012\u0006\u0010\u001e\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001fB\u0013\b\u0016\u0012\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030 \u00a2\u0006\u0002\u0010!B\u0012\b\u0016\u0012\u0006\u0010\"\u001a\u00020#\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$B%\u0012\u0006\u0010\u001a\u001a\u00020\u0002\u0012\u0006\u0010\u001c\u001a\u00020\u0002\u0012\u0006\u0010\u001d\u001a\u00020\u0002\u0012\u0006\u0010\u001e\u001a\u00020\u0002\u00a2\u0006\u0002\u0010%J\u0018\u0010&\u001a\u00020'2\u0006\u0010\u0006\u001a\u00020\u00002\b\b\u0002\u0010(\u001a\u00020\u0002J\u0006\u0010)\u001a\u00020\u0002J\"\u0010*\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u000b2\b\b\u0002\u0010,\u001a\u00020\u0000H\u0007J\u0016\u0010-\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u000bJ\u0018\u0010.\u001a\u00020'2\u0006\u0010\u0006\u001a\u00020\u00002\b\b\u0002\u0010(\u001a\u00020\u0002J\u0012\u0010/\u001a\u00020\u00002\b\b\u0002\u0010,\u001a\u00020\u0000H\u0007J\u0006\u00100\u001a\u00020\u0000J\u0011\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0002H\u0086\u0006J\u0016\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u0000J\u0011\u00103\u001a\u0002042\u0006\u00102\u001a\u00020\u0002H\u0086\u0006J\u0011\u00105\u001a\u00020\u00022\u0006\u00102\u001a\u00020\u0000H\u0086\u0004J\u0013\u00106\u001a\u00020'2\b\u00107\u001a\u0004\u0018\u000108H\u0096\u0002J\u0012\u00109\u001a\u00020\u000b2\b\b\u0002\u0010,\u001a\u00020\u000bH\u0007J\b\u0010:\u001a\u00020\u0011H\u0016J\u0012\u0010;\u001a\u00020\u00002\b\b\u0002\u0010,\u001a\u00020\u0000H\u0007J\u0006\u0010<\u001a\u00020\u0000J\u0006\u0010=\u001a\u00020\u0002J\u0011\u0010>\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0000H\u0086\u0002J\u0016\u0010>\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0000J\u0011\u0010?\u001a\u0002042\u0006\u00102\u001a\u00020\u0000H\u0086\u0006J\u0012\u0010@\u001a\u00020\u00002\b\b\u0002\u0010,\u001a\u00020\u0000H\u0007J\u0006\u0010A\u001a\u00020\u0000J\u0011\u0010B\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0000H\u0086\u0006J\u0016\u0010B\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0000J\u0011\u0010C\u001a\u0002042\u0006\u00102\u001a\u00020\u0000H\u0086\u0006J\u001c\u0010D\u001a\u0002042\b\b\u0002\u0010E\u001a\u00020F2\b\b\u0002\u0010G\u001a\u00020HH\u0007J\u001c\u0010I\u001a\u0002042\b\b\u0002\u0010E\u001a\u00020F2\b\b\u0002\u0010G\u001a\u00020HH\u0007J\u0011\u0010J\u001a\u00020\u00002\u0006\u0010K\u001a\u00020\u0000H\u0086\u0004J&\u0010J\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0002J\u0019\u0010L\u001a\u0002042\u0006\u0010M\u001a\u00020\u00112\u0006\u0010N\u001a\u00020\u001bH\u0096\u0002J\"\u0010O\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u00002\u0006\u0010P\u001a\u00020\u00022\b\b\u0002\u0010,\u001a\u00020\u0000H\u0007J\u0016\u0010Q\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u00002\u0006\u0010P\u001a\u00020\u0002J\u0011\u0010R\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0000H\u0086\u0006J\u0016\u0010R\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u0000J\u0011\u0010R\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u000bH\u0086\u0006J\u0016\u0010R\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u000bJ\u0011\u0010R\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0017H\u0086\u0006J\u0016\u0010R\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u0000J\u0011\u0010R\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0002H\u0086\u0006J\u0016\u0010R\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u0000J\u0011\u0010S\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0000H\u0086\u0004J\u0011\u0010S\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u000bH\u0086\u0004J\u0011\u0010S\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0017H\u0086\u0004J\u0011\u0010S\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0002H\u0086\u0004J\u0015\u0010T\u001a\u0002042\n\u0010\"\u001a\u00060Uj\u0002`VH\u0086\u0004J\b\u0010W\u001a\u00020FH\u0016J\t\u0010X\u001a\u00020\u0000H\u0086\u0002J\t\u0010Y\u001a\u00020\u0000H\u0086\u0002J\u0012\u0010Z\u001a\u0002042\b\b\u0002\u0010,\u001a\u00020\u0017H\u0007\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\\"}, d2={"Lglm_/quat/QuatD;", "Lglm_/quat/QuatT;", "", "()V", "d", "(D)V", "q", "Lglm_/quat/Quat;", "(Lglm_/quat/Quat;)V", "s", "v", "Lglm_/vec3/Vec3d;", "(DLglm_/vec3/Vec3d;)V", "u", "(Lglm_/vec3/Vec3d;Lglm_/vec3/Vec3d;)V", "block", "Lkotlin/Function1;", "", "(Lkotlin/jvm/functions/Function1;)V", "eulerAngle", "Lglm_/vec3/Vec3;", "(Lglm_/vec3/Vec3;)V", "vec4", "Lglm_/vec4/Vec4d;", "(Lglm_/vec4/Vec4d;)V", "(Lglm_/quat/QuatD;)V", "w", "", "x", "y", "z", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "Lglm_/vec4/Vec4t;", "(Lglm_/vec4/Vec4t;)V", "ptr", "Lkool/DoublePtr;", "(JLkotlin/jvm/internal/DefaultConstructorMarker;)V", "(DDDD)V", "allEqual", "", "epsilon", "angle", "angleAxis", "axis", "res", "angleAxisAssign", "anyNotEqual", "conjugate", "conjugateAssign", "div", "b", "divAssign", "", "dot", "equals", "other", "", "eulerAngles", "hashCode", "inverse", "inverseAssign", "length", "minus", "minusAssign", "normalize", "normalizeAssign", "plus", "plusAssign", "print", "name", "", "stream", "Ljava/io/PrintStream;", "println", "put", "quat", "set", "index", "value", "slerp", "interp", "slerpAssign", "times", "timesAssign", "to", "", "Lkool/Ptr;", "toString", "unaryMinus", "unaryPlus", "vectorize", "Companion", "glm-jdk8"})
public final class QuatD
extends QuatT<Double> {
    @JvmField
    public static final int length;
    @JvmField
    public static final int size;
    public static final Companion Companion;

    @NotNull
    public final QuatD put(double w, double x, double y, double z) {
        this.w = w;
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    @NotNull
    public final QuatD put(@NotNull QuatD quat) {
        Intrinsics.checkNotNullParameter((Object)quat, (String)"quat");
        return this.put(quat.w.doubleValue(), quat.x.doubleValue(), quat.y.doubleValue(), quat.z.doubleValue());
    }

    public final void to(long ptr) {
        MemoryUtil.memPutDouble((long)ptr, (double)this.w.doubleValue());
        MemoryUtil.memPutDouble((long)(ptr + (long)UtilsKt.getBYTES(DoubleCompanionObject.INSTANCE)), (double)this.x.doubleValue());
        MemoryUtil.memPutDouble((long)(ptr + (long)(UtilsKt.getBYTES(DoubleCompanionObject.INSTANCE) * 2)), (double)this.y.doubleValue());
        MemoryUtil.memPutDouble((long)(ptr + (long)(UtilsKt.getBYTES(DoubleCompanionObject.INSTANCE) * 3)), (double)this.z.doubleValue());
    }

    @Override
    public void set(int index, @NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (index) {
            case 0: {
                this.x = ExtensionsKt.getD(value);
                break;
            }
            case 1: {
                this.y = ExtensionsKt.getD(value);
                break;
            }
            case 2: {
                this.z = ExtensionsKt.getD(value);
                break;
            }
            case 3: {
                this.w = ExtensionsKt.getD(value);
                break;
            }
            default: {
                throw (Throwable)new ArrayIndexOutOfBoundsException();
            }
        }
    }

    @NotNull
    public final QuatD unaryPlus() {
        return this;
    }

    @NotNull
    public final QuatD unaryMinus() {
        return new QuatD(-this.w.doubleValue(), -this.x.doubleValue(), -this.y.doubleValue(), -this.z.doubleValue());
    }

    @NotNull
    public final QuatD plus(@NotNull QuatD b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.plus(new QuatD(), this, b);
    }

    @NotNull
    public final QuatD plus(@NotNull QuatD b, @NotNull QuatD res2) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return Companion.plus(res2, this, b);
    }

    public final void plusAssign(@NotNull QuatD b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Companion.plus(this, this, b);
    }

    @NotNull
    public final QuatD minus(@NotNull QuatD b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.minus(new QuatD(), this, b);
    }

    @NotNull
    public final QuatD minus(@NotNull QuatD b, @NotNull QuatD res2) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return Companion.minus(res2, this, b);
    }

    public final void minusAssign(@NotNull QuatD b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Companion.minus(this, this, b);
    }

    @NotNull
    public final QuatD times(@NotNull QuatD b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.times(new QuatD(), this, b);
    }

    @NotNull
    public final QuatD times(double b) {
        return Companion.times(new QuatD(), this, b);
    }

    @NotNull
    public final Vec3d times(@NotNull Vec3d b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.times(new Vec3d(), this, b);
    }

    @NotNull
    public final QuatD times(@NotNull Vec4d b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.times(new QuatD(), this, b);
    }

    @NotNull
    public final QuatD times(@NotNull QuatD b, @NotNull QuatD res2) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return Companion.times(res2, this, b);
    }

    @NotNull
    public final QuatD times(double b, @NotNull QuatD res2) {
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return Companion.times(res2, this, b);
    }

    @NotNull
    public final Vec3d times(@NotNull Vec3d b, @NotNull Vec3d res2) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return Companion.times(res2, this, b);
    }

    @NotNull
    public final QuatD times(@NotNull Vec4d b, @NotNull QuatD res2) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return Companion.times(res2, this, b);
    }

    @NotNull
    public final QuatD timesAssign(@NotNull QuatD b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.times(this, this, b);
    }

    @NotNull
    public final QuatD timesAssign(double b) {
        return Companion.times(this, this, b);
    }

    @NotNull
    public final Vec3d timesAssign(@NotNull Vec3d b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.times(b, this, b);
    }

    @NotNull
    public final QuatD timesAssign(@NotNull Vec4d b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return Companion.times(this, this, b);
    }

    @NotNull
    public final QuatD div(double b) {
        return Companion.div(new QuatD(), this, b);
    }

    @NotNull
    public final QuatD div(double b, @NotNull QuatD res2) {
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return Companion.div(res2, this, b);
    }

    public final void divAssign(double b) {
        Companion.div(this, this, b);
    }

    public final double length() {
        return glm.INSTANCE.length(this);
    }

    @JvmOverloads
    @NotNull
    public final QuatD normalize(@NotNull QuatD res2) {
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return glm.INSTANCE.normalize(this, res2);
    }

    public static /* synthetic */ QuatD normalize$default(QuatD quatD, QuatD quatD2, int n, Object object) {
        if ((n & 1) != 0) {
            quatD2 = new QuatD();
        }
        return quatD.normalize(quatD2);
    }

    @JvmOverloads
    @NotNull
    public final QuatD normalize() {
        return QuatD.normalize$default(this, null, 1, null);
    }

    @NotNull
    public final QuatD normalizeAssign() {
        return glm.INSTANCE.normalize(this, this);
    }

    public final double dot(@NotNull QuatD b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return glm.INSTANCE.dot(this, b);
    }

    @JvmOverloads
    @NotNull
    public final QuatD angleAxis(double angle, @NotNull Vec3d axis, @NotNull QuatD res2) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return glm.INSTANCE.angleAxis(angle, axis, res2);
    }

    public static /* synthetic */ QuatD angleAxis$default(QuatD quatD, double d, Vec3d vec3d, QuatD quatD2, int n, Object object) {
        if ((n & 4) != 0) {
            quatD2 = new QuatD();
        }
        return quatD.angleAxis(d, vec3d, quatD2);
    }

    @JvmOverloads
    @NotNull
    public final QuatD angleAxis(double angle, @NotNull Vec3d axis) {
        return QuatD.angleAxis$default(this, angle, axis, null, 4, null);
    }

    @NotNull
    public final QuatD angleAxisAssign(double angle, @NotNull Vec3d axis) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        return glm.INSTANCE.angleAxis(angle, axis, this);
    }

    @JvmOverloads
    @NotNull
    public final QuatD conjugate(@NotNull QuatD res2) {
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return glm.INSTANCE.conjugate(this, res2);
    }

    public static /* synthetic */ QuatD conjugate$default(QuatD quatD, QuatD quatD2, int n, Object object) {
        if ((n & 1) != 0) {
            quatD2 = new QuatD();
        }
        return quatD.conjugate(quatD2);
    }

    @JvmOverloads
    @NotNull
    public final QuatD conjugate() {
        return QuatD.conjugate$default(this, null, 1, null);
    }

    @NotNull
    public final QuatD conjugateAssign() {
        return glm.INSTANCE.conjugate(this, this);
    }

    @JvmOverloads
    @NotNull
    public final QuatD inverse(@NotNull QuatD res2) {
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return glm.INSTANCE.inverse(this, res2);
    }

    public static /* synthetic */ QuatD inverse$default(QuatD quatD, QuatD quatD2, int n, Object object) {
        if ((n & 1) != 0) {
            quatD2 = new QuatD();
        }
        return quatD.inverse(quatD2);
    }

    @JvmOverloads
    @NotNull
    public final QuatD inverse() {
        return QuatD.inverse$default(this, null, 1, null);
    }

    @NotNull
    public final QuatD inverseAssign() {
        return glm.INSTANCE.inverse(this, this);
    }

    public final double angle() {
        return glm.INSTANCE.angle(this);
    }

    @JvmOverloads
    @NotNull
    public final Vec3d eulerAngles(@NotNull Vec3d res2) {
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return glm.INSTANCE.eulerAngles(this, res2);
    }

    public static /* synthetic */ Vec3d eulerAngles$default(QuatD quatD, Vec3d vec3d, int n, Object object) {
        if ((n & 1) != 0) {
            vec3d = new Vec3d();
        }
        return quatD.eulerAngles(vec3d);
    }

    @JvmOverloads
    @NotNull
    public final Vec3d eulerAngles() {
        return QuatD.eulerAngles$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final QuatD slerp(@NotNull QuatD b, double interp, @NotNull QuatD res2) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        return glm.INSTANCE.slerp(this, b, interp, res2);
    }

    public static /* synthetic */ QuatD slerp$default(QuatD quatD, QuatD quatD2, double d, QuatD quatD3, int n, Object object) {
        if ((n & 4) != 0) {
            quatD3 = new QuatD();
        }
        return quatD.slerp(quatD2, d, quatD3);
    }

    @JvmOverloads
    @NotNull
    public final QuatD slerp(@NotNull QuatD b, double interp) {
        return QuatD.slerp$default(this, b, interp, null, 4, null);
    }

    @NotNull
    public final QuatD slerpAssign(@NotNull QuatD b, double interp) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return glm.INSTANCE.slerp(this, b, interp, this);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof QuatD && ((Number)this.get(0)).doubleValue() == ((Number)((QuatD)other).get(0)).doubleValue() && ((Number)this.get(1)).doubleValue() == ((Number)((QuatD)other).get(1)).doubleValue() && ((Number)this.get(2)).doubleValue() == ((Number)((QuatD)other).get(2)).doubleValue() && ((Number)this.get(3)).doubleValue() == ((Number)((QuatD)other).get(3)).doubleValue();
    }

    public int hashCode() {
        return 31 * (31 * (31 * Double.hashCode(this.w.doubleValue()) + Double.hashCode(this.x.doubleValue())) + Double.hashCode(this.y.doubleValue())) + Double.hashCode(this.z.doubleValue());
    }

    @JvmOverloads
    public final void print(@NotNull String name, @NotNull PrintStream stream) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        stream.print(name + this);
    }

    public static /* synthetic */ void print$default(QuatD quatD, String string, PrintStream printStream, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            PrintStream printStream2 = System.out;
            Intrinsics.checkNotNullExpressionValue((Object)printStream2, (String)"System.out");
            printStream = printStream2;
        }
        quatD.print(string, printStream);
    }

    @JvmOverloads
    public final void print(@NotNull String name) {
        QuatD.print$default(this, name, null, 2, null);
    }

    @JvmOverloads
    public final void print() {
        QuatD.print$default(this, null, null, 3, null);
    }

    @JvmOverloads
    public final void println(@NotNull String name, @NotNull PrintStream stream) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        stream.println(name + this);
    }

    public static /* synthetic */ void println$default(QuatD quatD, String string, PrintStream printStream, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            PrintStream printStream2 = System.out;
            Intrinsics.checkNotNullExpressionValue((Object)printStream2, (String)"System.out");
            printStream = printStream2;
        }
        quatD.println(string, printStream);
    }

    @JvmOverloads
    public final void println(@NotNull String name) {
        QuatD.println$default(this, name, null, 2, null);
    }

    @JvmOverloads
    public final void println() {
        QuatD.println$default(this, null, null, 3, null);
    }

    @NotNull
    public String toString() {
        return "" + '(' + this.w.doubleValue() + ", {" + this.x.doubleValue() + ", " + this.y.doubleValue() + ", " + this.z.doubleValue() + "})";
    }

    @JvmOverloads
    public final void vectorize(@NotNull Vec4d res2) {
        Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
        res2.put(this.x.doubleValue(), this.y.doubleValue(), this.z.doubleValue(), this.w.doubleValue());
    }

    public static /* synthetic */ void vectorize$default(QuatD quatD, Vec4d vec4d, int n, Object object) {
        if ((n & 1) != 0) {
            vec4d = new Vec4d();
        }
        quatD.vectorize(vec4d);
    }

    @JvmOverloads
    public final void vectorize() {
        QuatD.vectorize$default(this, null, 1, null);
    }

    public final boolean allEqual(@NotNull QuatD q, double epsilon2) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        return this.x.doubleValue() - q.x.doubleValue() < epsilon2 && this.y.doubleValue() - q.y.doubleValue() < epsilon2 && this.z.doubleValue() - q.z.doubleValue() < epsilon2 && this.w.doubleValue() - q.w.doubleValue() < epsilon2;
    }

    public static /* synthetic */ boolean allEqual$default(QuatD quatD, QuatD quatD2, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = glm.INSTANCE.get\u03b5();
        }
        return quatD.allEqual(quatD2, d);
    }

    public final boolean anyNotEqual(@NotNull QuatD q, double epsilon2) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        return this.x.doubleValue() - q.x.doubleValue() >= epsilon2 || this.y.doubleValue() - q.y.doubleValue() >= epsilon2 || this.z.doubleValue() - q.z.doubleValue() >= epsilon2 || this.w.doubleValue() - q.w.doubleValue() >= epsilon2;
    }

    public static /* synthetic */ boolean anyNotEqual$default(QuatD quatD, QuatD quatD2, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = glm.INSTANCE.get\u03b5();
        }
        return quatD.anyNotEqual(quatD2, d);
    }

    public QuatD(double w, double x, double y, double z) {
        super(w, x, y, z);
    }

    public QuatD() {
        this(1.0, 0.0, 0.0, 0.0);
    }

    public QuatD(double d) {
        this(d, d, d, d);
    }

    public QuatD(@NotNull Quat q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        this(q.w, q.x, q.y, q.z);
    }

    public QuatD(double s, @NotNull Vec3d v2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        this(s, v2.getX(), v2.getY(), v2.getZ());
    }

    public QuatD(@NotNull Vec3d u, @NotNull Vec3d v2) {
        Vec3d vec3d;
        Intrinsics.checkNotNullParameter((Object)u, (String)"u");
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v");
        this();
        double d = u.dot(u) * v2.dot(v2);
        boolean bl = false;
        double normUnormV = Math.sqrt(d);
        double realPart = normUnormV + u.dot(v2);
        if (realPart < (double)1.0E-6f * normUnormV) {
            realPart = 0.0;
            double d2 = u.getX();
            boolean bl2 = false;
            double d3 = Math.abs(d2);
            d2 = u.getZ();
            bl2 = false;
            vec3d = d3 > Math.abs(d2) ? new Vec3d(-u.getY().doubleValue(), u.getX(), 0.0) : new Vec3d(0.0, -u.getZ().doubleValue(), u.getY());
        } else {
            vec3d = u.cross(v2);
        }
        Vec3d w = vec3d;
        this.put(realPart, w.getX(), w.getY(), w.getZ()).normalizeAssign();
    }

    public QuatD(@NotNull Function1<? super Integer, Double> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this(((Number)block.invoke((Object)0)).doubleValue(), ((Number)block.invoke((Object)1)).doubleValue(), ((Number)block.invoke((Object)2)).doubleValue(), ((Number)block.invoke((Object)3)).doubleValue());
    }

    public QuatD(@NotNull Vec3 eulerAngle) {
        Intrinsics.checkNotNullParameter((Object)eulerAngle, (String)"eulerAngle");
        this();
        double eX = (double)eulerAngle.getX().floatValue() * 0.5;
        double eY = (double)eulerAngle.getY().floatValue() * 0.5;
        double eZ = (double)eulerAngle.getZ().floatValue() * 0.5;
        double cX = glm.INSTANCE.cos(eX);
        double cY = glm.INSTANCE.cos(eY);
        double cZ = glm.INSTANCE.cos(eZ);
        double sX = glm.INSTANCE.sin(eX);
        double sY = glm.INSTANCE.sin(eY);
        double sZ = glm.INSTANCE.sin(eZ);
        this.w = cX * cY * cZ + sX * sY * sZ;
        this.x = sX * cY * cZ - cX * sY * sZ;
        this.y = cX * sY * cZ + sX * cY * sZ;
        this.z = cX * cY * sZ - sX * sY * cZ;
    }

    public QuatD(@NotNull Vec4d vec42) {
        Intrinsics.checkNotNullParameter((Object)vec42, (String)"vec4");
        this(vec42.getW(), vec42.getX(), vec42.getY(), vec42.getZ());
    }

    public QuatD(@NotNull QuatD q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        this(ExtensionsKt.getD(q.w), ExtensionsKt.getD(q.x), ExtensionsKt.getD(q.y), ExtensionsKt.getD(q.z));
    }

    public QuatD(@NotNull Number w, @NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkNotNullParameter((Object)w, (String)"w");
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        this(ExtensionsKt.getD(w), ExtensionsKt.getD(x), ExtensionsKt.getD(y), ExtensionsKt.getD(z));
    }

    public QuatD(@NotNull Vec4t<?> vec42) {
        Intrinsics.checkNotNullParameter(vec42, (String)"vec4");
        this(ExtensionsKt.getD(vec42.getW()), ExtensionsKt.getD(vec42.getX()), ExtensionsKt.getD(vec42.getY()), ExtensionsKt.getD(vec42.getZ()));
    }

    private QuatD(final long ptr) {
        this((Function1<? super Integer, Double>)((Function1)new Function1<Integer, Double>(){

            public final double invoke(int i2) {
                long $this$iv = ptr;
                boolean $i$f$get = false;
                return PointersKt.getUNSAFE().getDouble(null, $this$iv + (long)(i2 * UtilsKt.getBYTES(DoubleCompanionObject.INSTANCE)));
            }
        }));
    }

    static {
        Companion = new Companion(null);
        length = 4;
        size = length * UtilsKt.getBYTES(DoubleCompanionObject.INSTANCE);
    }

    public /* synthetic */ QuatD(long ptr, DefaultConstructorMarker $constructor_marker) {
        this(ptr);
    }

    @JvmStatic
    @NotNull
    public static final Quat fromPointer(long ptr) {
        return Companion.fromPointer(ptr);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fH\u0007R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lglm_/quat/QuatD$Companion;", "Lglm_/quat/quatD_operators;", "Lglm_/gtc/gtc_Quaternion;", "()V", "identity", "Lglm_/quat/QuatD;", "getIdentity", "()Lglm_/quat/QuatD;", "length", "", "size", "fromPointer", "Lglm_/quat/Quat;", "ptr", "", "Lkool/Ptr;", "glm-jdk8"})
    public static final class Companion
    implements quatD_operators,
    gtc_Quaternion {
        @JvmStatic
        @NotNull
        public final Quat fromPointer(long ptr) {
            return new Quat(MemoryUtil.memGetDouble((long)ptr), MemoryUtil.memGetDouble((long)(ptr + (long)UtilsKt.getBYTES(DoubleCompanionObject.INSTANCE))), MemoryUtil.memGetDouble((long)(ptr + (long)(UtilsKt.getBYTES(DoubleCompanionObject.INSTANCE) * 2))), MemoryUtil.memGetDouble((long)(ptr + (long)(UtilsKt.getBYTES(DoubleCompanionObject.INSTANCE) * 3))));
        }

        @NotNull
        public final QuatD getIdentity() {
            return new QuatD(1.0, 0.0, 0.0, 0.0);
        }

        private Companion() {
        }

        @Override
        @NotNull
        public QuatD plus(@NotNull QuatD res2, @NotNull QuatD a, @NotNull QuatD b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return quatD_operators.DefaultImpls.plus(this, res2, a, b);
        }

        @Override
        @NotNull
        public QuatD minus(@NotNull QuatD res2, @NotNull QuatD a, @NotNull QuatD b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return quatD_operators.DefaultImpls.minus(this, res2, a, b);
        }

        @Override
        @NotNull
        public QuatD times(@NotNull QuatD res2, @NotNull QuatD a, @NotNull QuatD b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return quatD_operators.DefaultImpls.times((quatD_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public QuatD times(@NotNull QuatD res2, @NotNull QuatD a, double b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return quatD_operators.DefaultImpls.times((quatD_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public Vec3d times(@NotNull Vec3d res2, @NotNull QuatD a, @NotNull Vec3d b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return quatD_operators.DefaultImpls.times((quatD_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public Vec3d times(@NotNull Vec3d res2, @NotNull Vec3d a, @NotNull QuatD b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return quatD_operators.DefaultImpls.times((quatD_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public QuatD times(@NotNull QuatD res2, @NotNull QuatD a, @NotNull Vec4d b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return quatD_operators.DefaultImpls.times((quatD_operators)this, res2, a, b);
        }

        @Override
        @NotNull
        public QuatD div(@NotNull QuatD res2, @NotNull QuatD a, double b) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            return quatD_operators.DefaultImpls.div(this, res2, a, b);
        }

        @Override
        @NotNull
        public Mat3 mat3_cast(@NotNull Quat q, @NotNull Mat3 res2) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.mat3_cast(this, q, res2);
        }

        @Override
        @NotNull
        public Mat3 mat3_cast(@NotNull Quat q) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            return gtc_Quaternion.DefaultImpls.mat3_cast(this, q);
        }

        @Override
        @NotNull
        public Mat3 mat3d_cast(@NotNull QuatD q, @NotNull Mat3 m) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            return gtc_Quaternion.DefaultImpls.mat3d_cast(this, q, m);
        }

        @Override
        @NotNull
        public Mat4 mat4_cast(@NotNull Quat q, @NotNull Mat4 res2) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.mat4_cast(this, q, res2);
        }

        @Override
        @NotNull
        public Mat4 mat4_cast(@NotNull Quat q) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            return gtc_Quaternion.DefaultImpls.mat4_cast(this, q);
        }

        @Override
        @NotNull
        public Mat4 mat4d_cast(@NotNull Mat4 res2, @NotNull QuatD q) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            return gtc_Quaternion.DefaultImpls.mat4d_cast(this, res2, q);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat3 m, @NotNull Quat res2) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.quat_cast((gtc_Quaternion)this, m, res2);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat3 m) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            return gtc_Quaternion.DefaultImpls.quat_cast((gtc_Quaternion)this, m);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat4 m, @NotNull Quat res2) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.quat_cast((gtc_Quaternion)this, m, res2);
        }

        @Override
        @NotNull
        public Quat quat_cast(@NotNull Mat4 m) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            return gtc_Quaternion.DefaultImpls.quat_cast((gtc_Quaternion)this, m);
        }

        @Override
        @NotNull
        public Quat quat_cast(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22, @NotNull Quat res2) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.quat_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22, res2);
        }

        @Override
        @NotNull
        public Quat quat_cast(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
            return gtc_Quaternion.DefaultImpls.quat_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat3d m, @NotNull QuatD res2) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.quatD_cast((gtc_Quaternion)this, m, res2);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat3d m) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            return gtc_Quaternion.DefaultImpls.quatD_cast((gtc_Quaternion)this, m);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat4d m, @NotNull QuatD res2) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.quatD_cast((gtc_Quaternion)this, m, res2);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(@NotNull Mat4d m) {
            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
            return gtc_Quaternion.DefaultImpls.quatD_cast((gtc_Quaternion)this, m);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22, @NotNull QuatD res2) {
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.quatD_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22, res2);
        }

        @Override
        @NotNull
        public QuatD quatD_cast(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
            return gtc_Quaternion.DefaultImpls.quatD_cast(this, m00, m01, m02, m10, m11, m12, m20, m21, m22);
        }

        @Override
        @NotNull
        public Vec4bool lessThan(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res2) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.lessThan(this, a, b, res2);
        }

        @Override
        @NotNull
        public Vec4bool lessThan(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return gtc_Quaternion.DefaultImpls.lessThan(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool lessThanEqual(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res2) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.lessThanEqual(this, a, b, res2);
        }

        @Override
        @NotNull
        public Vec4bool lessThanEqual(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return gtc_Quaternion.DefaultImpls.lessThanEqual(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool greater(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res2) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.greater(this, a, b, res2);
        }

        @Override
        @NotNull
        public Vec4bool greater(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return gtc_Quaternion.DefaultImpls.greater(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool greaterThan(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res2) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.greaterThan(this, a, b, res2);
        }

        @Override
        @NotNull
        public Vec4bool greaterThan(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return gtc_Quaternion.DefaultImpls.greaterThan(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool equal(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res2) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.equal(this, a, b, res2);
        }

        @Override
        @NotNull
        public Vec4bool equal(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return gtc_Quaternion.DefaultImpls.equal(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool notEqual(@NotNull Quat a, @NotNull Quat b, @NotNull Vec4bool res2) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.notEqual(this, a, b, res2);
        }

        @Override
        @NotNull
        public Vec4bool notEqual(@NotNull Quat a, @NotNull Quat b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return gtc_Quaternion.DefaultImpls.notEqual(this, a, b);
        }

        @Override
        @NotNull
        public Vec4bool isNan(@NotNull Quat q, @NotNull Vec4bool res2) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.isNan(this, q, res2);
        }

        @Override
        @NotNull
        public Vec4bool isNan(@NotNull Quat q) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            return gtc_Quaternion.DefaultImpls.isNan(this, q);
        }

        @Override
        @NotNull
        public Vec4bool isInf(@NotNull Quat q, @NotNull Vec4bool res2) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Intrinsics.checkNotNullParameter((Object)res2, (String)"res");
            return gtc_Quaternion.DefaultImpls.isInf(this, q, res2);
        }

        @Override
        @NotNull
        public Vec4bool isInf(@NotNull Quat q) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            return gtc_Quaternion.DefaultImpls.isInf(this, q);
        }

        @Override
        @NotNull
        public Quat quatLookAt(@NotNull Vec3 direction, @NotNull Vec3 up) {
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Intrinsics.checkNotNullParameter((Object)up, (String)"up");
            return gtc_Quaternion.DefaultImpls.quatLookAt((gtc_Quaternion)this, direction, up);
        }

        @Override
        @NotNull
        public QuatD quatLookAt(@NotNull Vec3d direction, @NotNull Vec3d up) {
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Intrinsics.checkNotNullParameter((Object)up, (String)"up");
            return gtc_Quaternion.DefaultImpls.quatLookAt((gtc_Quaternion)this, direction, up);
        }

        @Override
        @NotNull
        public Quat quatLookAtRH(@NotNull Vec3 direction, @NotNull Vec3 up) {
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Intrinsics.checkNotNullParameter((Object)up, (String)"up");
            return gtc_Quaternion.DefaultImpls.quatLookAtRH((gtc_Quaternion)this, direction, up);
        }

        @Override
        @NotNull
        public QuatD quatLookAtRH(@NotNull Vec3d direction, @NotNull Vec3d up) {
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Intrinsics.checkNotNullParameter((Object)up, (String)"up");
            return gtc_Quaternion.DefaultImpls.quatLookAtRH((gtc_Quaternion)this, direction, up);
        }

        @Override
        @NotNull
        public Quat quatLookAtLH(@NotNull Vec3 direction, @NotNull Vec3 up) {
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Intrinsics.checkNotNullParameter((Object)up, (String)"up");
            return gtc_Quaternion.DefaultImpls.quatLookAtLH((gtc_Quaternion)this, direction, up);
        }

        @Override
        @NotNull
        public QuatD quatLookAtLH(@NotNull Vec3d direction, @NotNull Vec3d up) {
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            Intrinsics.checkNotNullParameter((Object)up, (String)"up");
            return gtc_Quaternion.DefaultImpls.quatLookAtLH((gtc_Quaternion)this, direction, up);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

