/*
 * Decompiled with CFR 0.152.
 */
package observable.mixin;

import java.util.function.Consumer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import observable.Observable;
import observable.Props;
import observable.server.Profiler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Level.class})
public class LevelMixin {
    @Overwrite
    public void m_46653_(Consumer<Entity> consumer, Entity entity) {
        try {
            if (Props.notProcessing) {
                consumer.accept(entity);
            } else {
                if (Props.entityDepth < 0) {
                    Props.entityDepth = Thread.currentThread().getStackTrace().length - 1;
                }
                if (this instanceof ServerLevel) {
                    Profiler.TimingData data2 = Observable.INSTANCE.getPROFILER().process(entity);
                    Props.currentTarget.set(data2);
                    long start = System.nanoTime();
                    consumer.accept(entity);
                    data2.setTime(System.nanoTime() - start + data2.getTime());
                    Props.currentTarget.set(null);
                    data2.setTicks(data2.getTicks() + 1);
                } else {
                    consumer.accept(entity);
                }
            }
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.m_127521_((Throwable)throwable, (String)"Ticking entity");
            CrashReportCategory crashReportCategory = crashReport.m_127514_("Entity being ticked");
            entity.m_7976_(crashReportCategory);
            throw new ReportedException(crashReport);
        }
    }

    @Redirect(method={"tickBlockEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/TickingBlockEntity;tick()V"))
    public final void redirectTick(TickingBlockEntity blockEntity) {
        if (Props.notProcessing) {
            blockEntity.m_142224_();
        } else {
            if (Props.blockEntityDepth < 0) {
                Props.blockEntityDepth = Thread.currentThread().getStackTrace().length - 1;
            }
            if (this instanceof ServerLevel) {
                Profiler.TimingData data2 = Observable.INSTANCE.getPROFILER().processBlockEntity(blockEntity, (Level)this);
                Props.currentTarget.set(data2);
                long start = System.nanoTime();
                blockEntity.m_142224_();
                data2.setTime(System.nanoTime() - start + data2.getTime());
                Props.currentTarget.set(null);
                data2.setTicks(data2.getTicks() + 1);
            } else {
                blockEntity.m_142224_();
            }
        }
    }
}

