/*
 * Decompiled with CFR 0.152.
 */
package observable.mixin;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import observable.Observable;
import observable.Props;
import observable.server.Profiler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ServerLevel.class})
public class ServerLevelMixin {
    @Redirect(method={"tickFluid"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/material/FluidState;tick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V"))
    public final void onTickLiquid(FluidState state, Level level, BlockPos pos5) {
        if (Props.notProcessing) {
            state.m_76163_(level, pos5);
        } else {
            if (Props.fluidDepth < 0) {
                Props.fluidDepth = Thread.currentThread().getStackTrace().length - 1;
            }
            Profiler.TimingData data2 = Observable.INSTANCE.getPROFILER().processFluid(state, pos5, level);
            Props.currentTarget.set(data2);
            long start = System.nanoTime();
            state.m_76163_(level, pos5);
            data2.setTime(System.nanoTime() - start + data2.getTime());
            Props.currentTarget.set(null);
            data2.setTicks(data2.getTicks() + 1);
        }
    }

    @Redirect(method={"tickBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;tick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Ljava/util/Random;)V"))
    public final void onTickBlock(BlockState state, ServerLevel level, BlockPos pos5, Random random2) {
        if (Props.notProcessing) {
            state.m_60616_(level, pos5, random2);
        } else {
            if (Props.blockDepth < 0) {
                Props.blockDepth = Thread.currentThread().getStackTrace().length - 1;
            }
            Profiler.TimingData data2 = Observable.INSTANCE.getPROFILER().processBlock(state, pos5, (Level)level);
            Props.currentTarget.set(data2);
            long start = System.nanoTime();
            state.m_60616_(level, pos5, random2);
            data2.setTime(System.nanoTime() - start + data2.getTime());
            Props.currentTarget.set(null);
            data2.setTicks(data2.getTicks() + 1);
        }
    }
}

