/*
 * Decompiled with CFR 0.152.
 */
package observable.server;

import dev.architectury.networking.NetworkChannel;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.GameInstance;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KType;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.modules.SerializersModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import observable.Observable;
import observable.Props;
import observable.net.BetterChannel;
import observable.net.S2CPacket;
import observable.server.ProfilingData;
import observable.server.ServerSettingsKt;
import observable.server.TaggedSampler;
import observable.server.TraceMap;
import observable.shadow.kotlinx.serialization.protobuf.ProtoBuf;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001HB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u00103\u001a\u00020\b2\u0006\u00104\u001a\u000200J\u001e\u00105\u001a\u00020\b2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u0006J\u0016\u0010:\u001a\u00020\b2\u0006\u0010;\u001a\u00020<2\u0006\u00109\u001a\u00020\u0006J\u001e\u0010=\u001a\u00020\b2\u0006\u0010>\u001a\u00020?2\u0006\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u0006J)\u0010@\u001a\u00020A2\n\b\u0002\u0010B\u001a\u0004\u0018\u00010*2\b\b\u0002\u0010C\u001a\u00020\u000e2\u0006\u0010D\u001a\u00020E\u00a2\u0006\u0002\u0010FJ\u0006\u0010G\u001a\u00020AR8\u0010\u0003\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00040\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u001bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR\u001a\u0010#\u001a\u00020$X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R&\u0010/\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\b0\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\n\"\u0004\b2\u0010\f\u00a8\u0006I"}, d2={"Lobservable/server/Profiler;", "", "()V", "blockTimingsMap", "Ljava/util/HashMap;", "Lnet/minecraft/resources/ResourceKey;", "Lnet/minecraft/world/level/Level;", "Lnet/minecraft/core/BlockPos;", "Lobservable/server/Profiler$TimingData;", "getBlockTimingsMap", "()Ljava/util/HashMap;", "setBlockTimingsMap", "(Ljava/util/HashMap;)V", "v", "", "notProcessing", "getNotProcessing", "()Z", "setNotProcessing", "(Z)V", "player", "Lnet/minecraft/server/level/ServerPlayer;", "getPlayer", "()Lnet/minecraft/server/level/ServerPlayer;", "setPlayer", "(Lnet/minecraft/server/level/ServerPlayer;)V", "samplerThread", "Ljava/lang/Thread;", "getSamplerThread", "()Ljava/lang/Thread;", "setSamplerThread", "(Ljava/lang/Thread;)V", "serverThread", "getServerThread", "setServerThread", "serverTraceMap", "Lobservable/server/TraceMap;", "getServerTraceMap", "()Lobservable/server/TraceMap;", "setServerTraceMap", "(Lobservable/server/TraceMap;)V", "startingTicks", "", "getStartingTicks", "()I", "setStartingTicks", "(I)V", "timingsMap", "Lnet/minecraft/world/entity/Entity;", "getTimingsMap", "setTimingsMap", "process", "entity", "processBlock", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "pos", "level", "processBlockEntity", "blockEntity", "Lnet/minecraft/world/level/block/entity/TickingBlockEntity;", "processFluid", "fluidState", "Lnet/minecraft/world/level/material/FluidState;", "startRunning", "", "duration", "sample", "ctx", "Ldev/architectury/networking/NetworkManager$PacketContext;", "(Ljava/lang/Integer;ZLdev/architectury/networking/NetworkManager$PacketContext;)V", "stopRunning", "TimingData", "observable"})
public final class Profiler {
    @NotNull
    private HashMap<Entity, TimingData> timingsMap = new HashMap();
    public TraceMap serverTraceMap;
    public Thread serverThread;
    public Thread samplerThread;
    @NotNull
    private HashMap<ResourceKey<Level>, HashMap<BlockPos, TimingData>> blockTimingsMap = new HashMap();
    @Nullable
    private ServerPlayer player;
    private int startingTicks;

    @NotNull
    public final HashMap<Entity, TimingData> getTimingsMap() {
        return this.timingsMap;
    }

    public final void setTimingsMap(@NotNull HashMap<Entity, TimingData> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.timingsMap = hashMap;
    }

    @NotNull
    public final TraceMap getServerTraceMap() {
        TraceMap traceMap = this.serverTraceMap;
        if (traceMap != null) {
            return traceMap;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"serverTraceMap");
        return null;
    }

    public final void setServerTraceMap(@NotNull TraceMap traceMap) {
        Intrinsics.checkNotNullParameter((Object)traceMap, (String)"<set-?>");
        this.serverTraceMap = traceMap;
    }

    @NotNull
    public final Thread getServerThread() {
        Thread thread = this.serverThread;
        if (thread != null) {
            return thread;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"serverThread");
        return null;
    }

    public final void setServerThread(@NotNull Thread thread) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"<set-?>");
        this.serverThread = thread;
    }

    @NotNull
    public final Thread getSamplerThread() {
        Thread thread = this.samplerThread;
        if (thread != null) {
            return thread;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"samplerThread");
        return null;
    }

    public final void setSamplerThread(@NotNull Thread thread) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"<set-?>");
        this.samplerThread = thread;
    }

    @NotNull
    public final HashMap<ResourceKey<Level>, HashMap<BlockPos, TimingData>> getBlockTimingsMap() {
        return this.blockTimingsMap;
    }

    public final void setBlockTimingsMap(@NotNull HashMap<ResourceKey<Level>, HashMap<BlockPos, TimingData>> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.blockTimingsMap = hashMap;
    }

    public final boolean getNotProcessing() {
        return Props.notProcessing;
    }

    public final void setNotProcessing(boolean v2) {
        Props.notProcessing = v2;
    }

    @Nullable
    public final ServerPlayer getPlayer() {
        return this.player;
    }

    public final void setPlayer(@Nullable ServerPlayer serverPlayer) {
        this.player = serverPlayer;
    }

    public final int getStartingTicks() {
        return this.startingTicks;
    }

    public final void setStartingTicks(int n) {
        this.startingTicks = n;
    }

    @NotNull
    public final TimingData process(@NotNull Entity entity) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Map $this$getOrPut$iv = this.timingsMap;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(entity);
        if (value$iv == null) {
            boolean bl = false;
            TimingData answer$iv = new TimingData(0L, 0, new TraceMap(Reflection.getOrCreateKotlinClass(entity.getClass())), null, 8, null);
            $this$getOrPut$iv.put(entity, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (TimingData)object;
    }

    @NotNull
    public final TimingData processBlockEntity(@NotNull TickingBlockEntity blockEntity, @NotNull Level level) {
        Object object;
        Object object2;
        Map $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Map map2 = this.blockTimingsMap;
        ResourceKey resourceKey = level.m_46472_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"level.dimension()");
        ResourceKey key$iv = resourceKey;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            HashMap answer$iv = new HashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        $this$getOrPut$iv = (Map)object2;
        key$iv = blockEntity.m_142689_();
        Intrinsics.checkNotNullExpressionValue((Object)key$iv, (String)"blockEntity.pos");
        $i$f$getOrPut = false;
        value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            TraceMap traceMap = new TraceMap(Reflection.getOrCreateKotlinClass(blockEntity.getClass()));
            String string = blockEntity.m_142280_();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"blockEntity.type");
            TimingData answer$iv = new TimingData(0L, 0, traceMap, string);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (TimingData)object;
    }

    @NotNull
    public final TimingData processBlock(@NotNull BlockState blockState, @NotNull BlockPos pos5, @NotNull Level level) {
        Object object;
        Object object2;
        Map $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)pos5, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Map map2 = this.blockTimingsMap;
        ResourceKey resourceKey = level.m_46472_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"level.dimension()");
        ResourceKey key$iv = resourceKey;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            HashMap answer$iv = new HashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        $this$getOrPut$iv = (Map)object2;
        boolean $i$f$getOrPut2 = false;
        Object value$iv2 = $this$getOrPut$iv.get(pos5);
        if (value$iv2 == null) {
            boolean bl = false;
            TraceMap traceMap = new TraceMap(Reflection.getOrCreateKotlinClass(blockState.getClass()));
            String string = blockState.m_60734_().m_7705_();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"blockState.block.descriptionId");
            TimingData answer$iv = new TimingData(0L, 0, traceMap, string);
            $this$getOrPut$iv.put(pos5, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv2;
        }
        return (TimingData)object;
    }

    @NotNull
    public final TimingData processFluid(@NotNull FluidState fluidState, @NotNull BlockPos pos5, @NotNull Level level) {
        Object object;
        Object object2;
        Map $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)fluidState, (String)"fluidState");
        Intrinsics.checkNotNullParameter((Object)pos5, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Map map2 = this.blockTimingsMap;
        ResourceKey resourceKey = level.m_46472_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"level.dimension()");
        ResourceKey key$iv = resourceKey;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            HashMap answer$iv = new HashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        $this$getOrPut$iv = (Map)object2;
        boolean $i$f$getOrPut2 = false;
        Object value$iv2 = $this$getOrPut$iv.get(pos5);
        if (value$iv2 == null) {
            boolean bl = false;
            TraceMap traceMap = new TraceMap(Reflection.getOrCreateKotlinClass(fluidState.getClass()));
            String string = Registry.f_122822_.m_7981_((Object)fluidState.m_76152_()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FLUID.getKey(fluidState.type).toString()");
            TimingData answer$iv = new TimingData(0L, 0, traceMap, string);
            $this$getOrPut$iv.put(pos5, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv2;
        }
        return (TimingData)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startRunning(@Nullable Integer duration, boolean sample, @NotNull NetworkManager.PacketContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Player player = ctx.getPlayer();
        this.player = player instanceof ServerPlayer ? (ServerPlayer)player : null;
        this.timingsMap.clear();
        this.blockTimingsMap.clear();
        this.setServerTraceMap(new TraceMap(null, null, null, 0, 15, null));
        long start = System.currentTimeMillis();
        Boolean bl = Props.notProcessing;
        synchronized (bl) {
            boolean bl2 = false;
            this.setNotProcessing(false);
            MinecraftServer minecraftServer = GameInstance.getServer();
            Intrinsics.checkNotNull((Object)minecraftServer);
            this.setStartingTicks(minecraftServer.m_129921_());
            Unit unit = Unit.INSTANCE;
        }
        if (sample) {
            this.setSamplerThread(new Thread(new TaggedSampler(this.getServerThread())));
            this.getSamplerThread().start();
            new Thread(() -> Profiler.startRunning$lambda-8(this)).start();
        }
        Integer n = duration;
        Long l = n == null ? null : Long.valueOf(n.intValue());
        if (l == null) {
            return;
        }
        long durMs = l * 1000L;
        BetterChannel betterChannel = Observable.INSTANCE.getCHANNEL();
        MinecraftServer minecraftServer = GameInstance.getServer();
        Intrinsics.checkNotNull((Object)minecraftServer);
        Object object = minecraftServer.m_6846_().m_11314_();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getServer()!!.playerList.players");
        betterChannel.sendToPlayers((List<? extends ServerPlayer>)object, new S2CPacket.ProfilingStarted(start + durMs));
        Component component = ctx.getPlayer().m_7755_();
        if (component == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.minecraft.network.chat.TextComponent");
        }
        Observable.INSTANCE.getLOGGER().info(((TextComponent)component).m_131292_() + " started profiler for " + duration + " s");
        object = new Timer("Profiler", false);
        TimerTask timerTask = new TimerTask(this){
            final /* synthetic */ Profiler this$0;
            {
                this.this$0 = profiler;
            }

            public void run() {
                TimerTask $this$startRunning_u24lambda_u2d9 = this;
                boolean bl = false;
                this.this$0.stopRunning();
            }
        };
        ((Timer)object).schedule(timerTask, durMs);
    }

    public static /* synthetic */ void startRunning$default(Profiler profiler, Integer n, boolean bl, NetworkManager.PacketContext packetContext, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        profiler.startRunning(n, bl, packetContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void stopRunning() {
        void players$iv;
        void this_$iv;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        BetterChannel $this$map$iv;
        ServerPlayer it;
        List list2;
        int ticks = 0;
        Boolean bl = Props.notProcessing;
        synchronized (bl) {
            boolean $i$a$-synchronized-Profiler$stopRunning$22 = false;
            this.setNotProcessing(true);
            MinecraftServer minecraftServer = GameInstance.getServer();
            Intrinsics.checkNotNull((Object)minecraftServer);
            ticks = minecraftServer.m_129921_() - this.getStartingTicks();
            Unit $i$a$-synchronized-Profiler$stopRunning$22 = Unit.INSTANCE;
        }
        ServerPlayer serverPlayer = this.player;
        if (serverPlayer == null) {
            list2 = null;
        } else {
            it = serverPlayer;
            boolean bl2 = false;
            list2 = CollectionsKt.listOf((Object)it);
        }
        List list3 = list2;
        if (list2 == null) {
            MinecraftServer minecraftServer = GameInstance.getServer();
            Intrinsics.checkNotNull((Object)minecraftServer);
            list3 = minecraftServer.m_6846_().m_11314_();
        }
        List players = list3;
        BetterChannel betterChannel = Observable.INSTANCE.getCHANNEL();
        Intrinsics.checkNotNullExpressionValue((Object)players, (String)"players");
        betterChannel.sendToPlayers(players, S2CPacket.ProfilingCompleted.INSTANCE);
        ProfilingData data2 = ProfilingData.Companion.create((Map<Entity, TimingData>)this.timingsMap, (Map<ResourceKey<Level>, ? extends Map<BlockPos, TimingData>>)this.blockTimingsMap, ticks, this.getServerTraceMap());
        Observable.INSTANCE.getLOGGER().info("Profiler ran for " + ticks + " ticks, sending data");
        Iterable iterable = players;
        String string = "Sending to ";
        Logger logger = Observable.INSTANCE.getLOGGER();
        boolean $i$f$map22 = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            ServerPlayer serverPlayer2 = (ServerPlayer)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            Component component = it2.m_7755_();
            if (component == null) {
                throw new NullPointerException("null cannot be cast to non-null type net.minecraft.network.chat.TextComponent");
            }
            collection.add(((TextComponent)component).m_131292_());
        }
        collection = (List)destination$iv$iv;
        logger.info(Intrinsics.stringPlus((String)string, (Object)collection));
        $this$map$iv = Observable.INSTANCE.getCHANNEL();
        List $i$f$map22 = players;
        S2CPacket.ProfilingResult msg$iv = new S2CPacket.ProfilingResult(data2);
        boolean $i$f$sendToPlayersSplit = false;
        BinaryFormat $this$encodeToByteArray$iv$iv = ProtoBuf.Default;
        boolean $i$f$encodeToByteArray = false;
        Object $this$serializer$iv$iv$iv = $this$encodeToByteArray$iv$iv.getSerializersModule();
        boolean $i$f$serializer22 = false;
        KSerializer $this$cast$iv$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv$iv, (KType)Reflection.typeOf(S2CPacket.ProfilingResult.class));
        boolean $i$f$cast = false;
        byte[] data$iv = $this$encodeToByteArray$iv$iv.encodeToByteArray((SerializationStrategy)$this$cast$iv$iv$iv$iv, (Object)msg$iv);
        ByteArrayInputStream bs$iv = new ByteArrayInputStream(data$iv);
        long id$iv = UUID.randomUUID().getLeastSignificantBits();
        NetworkChannel networkChannel = this_$iv.getRawChannel();
        Iterable iterable2 = (Iterable)players$iv;
        String $i$f$serializer22 = S2CPacket.ProfilingResult.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$serializer22, (String)"T::class.java.name");
        networkChannel.sendToPlayers(iterable2, (Object)new BetterChannel.PartialPacketBegin(id$iv, $i$f$serializer22));
        int size$iv = bs$iv.available() / BetterChannel.PartialPacketAssembler.Companion.getPACKET_SIZE() + RangesKt.coerceAtMost((int)(bs$iv.available() % BetterChannel.PartialPacketAssembler.Companion.getPACKET_SIZE()), (int)1);
        int idx$iv = 0;
        while (bs$iv.available() > 0) {
            byte[] arr$iv = new byte[RangesKt.coerceAtMost((int)bs$iv.available(), (int)BetterChannel.PartialPacketAssembler.Companion.getPACKET_SIZE())];
            bs$iv.read(arr$iv);
            this_$iv.getRawChannel().sendToPlayers((Iterable)players$iv, (Object)new BetterChannel.PartialPacketData(id$iv, arr$iv, idx$iv, size$iv));
            int n = idx$iv;
            idx$iv = n + 1;
        }
        Observable.INSTANCE.getLOGGER().info("Data transfer complete!");
        MinecraftServer minecraftServer = GameInstance.getServer();
        if (minecraftServer != null) {
            PlayerList playerList = minecraftServer.m_6846_();
            if (playerList != null) {
                List list4 = playerList.m_11314_();
                if (list4 != null) {
                    List list5;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = list4;
                    boolean $i$f$filter = false;
                    $this$serializer$iv$iv$iv = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        ServerPlayer it3 = (ServerPlayer)element$iv$iv;
                        boolean bl4 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it3, (String)"it");
                        if (!Observable.INSTANCE.hasPermission((Player)it3)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    List it4 = list5 = (List)destination$iv$iv2;
                    boolean bl5 = false;
                    Observable.INSTANCE.getCHANNEL().sendToPlayers(it4, S2CPacket.ProfilerInactive.INSTANCE);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void startRunning$lambda-8(Profiler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        while (!Props.notProcessing) {
            long interval = ServerSettingsKt.getServerSettings().getTraceInterval();
            long deviation = ServerSettingsKt.getServerSettings().getDeviation();
            TraceMap traceMap = this$0.getServerTraceMap();
            StackTraceElement[] stackTraceElementArray = this$0.getServerThread().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"serverThread.stackTrace");
            Iterator traces$iv = ArraysKt.reversed((Object[])stackTraceElementArray).iterator();
            boolean $i$f$add = false;
            if (traces$iv.hasNext()) {
                void this_$iv;
                this_$iv.setCount(this_$iv.getCount() + 1);
                StackTraceElement tr$iv = (StackTraceElement)traces$iv.next();
                String string = tr$iv.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tr.className");
                this_$iv.setClassName(string);
                string = tr$iv.getMethodName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tr.methodName");
                this_$iv.setMethodName(string);
                TraceMap target$iv = this_$iv;
                while (traces$iv.hasNext()) {
                    TraceMap traceMap2;
                    StackTraceElement el$iv = (StackTraceElement)traces$iv.next();
                    String string2 = el$iv.getMethodName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"el.methodName");
                    this_$iv.setMethodName(string2);
                    String string3 = el$iv.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"el.className");
                    String string4 = string3;
                    string3 = el$iv.getMethodName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"el.methodName");
                    TraceMap.MapKey key$iv = new TraceMap.MapKey(string4, string3);
                    Map<TraceMap.MapKey, TraceMap> $this$getOrPut$iv$iv = target$iv.getChildren();
                    boolean $i$f$getOrPut = false;
                    TraceMap value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
                    if (value$iv$iv == null) {
                        boolean bl = false;
                        String string5 = el$iv.getClassName();
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"el.className");
                        String string6 = string5;
                        string5 = el$iv.getMethodName();
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"el.methodName");
                        TraceMap answer$iv$iv = new TraceMap(string6, string5, null, 0, 12, null);
                        $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
                        traceMap2 = answer$iv$iv;
                    } else {
                        traceMap2 = value$iv$iv;
                    }
                    TraceMap traceMap$iv = traceMap2;
                    traceMap$iv.setCount(traceMap$iv.getCount() + 1);
                    target$iv = traceMap$iv;
                }
            }
            Thread.sleep(interval + Random.Default.nextLong(-deviation, deviation));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J1\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020\u0005H\u00d6\u0001J\t\u0010$\u001a\u00020\tH\u00d6\u0001R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006%"}, d2={"Lobservable/server/Profiler$TimingData;", "", "time", "", "ticks", "", "traces", "Lobservable/server/TraceMap;", "name", "", "(JILobservable/server/TraceMap;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getTicks", "()I", "setTicks", "(I)V", "getTime", "()J", "setTime", "(J)V", "getTraces", "()Lobservable/server/TraceMap;", "setTraces", "(Lobservable/server/TraceMap;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "observable"})
    public static final class TimingData {
        private long time;
        private int ticks;
        @NotNull
        private TraceMap traces;
        @NotNull
        private String name;

        public TimingData(long time, int ticks, @NotNull TraceMap traces, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)traces, (String)"traces");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.time = time;
            this.ticks = ticks;
            this.traces = traces;
            this.name = name;
        }

        public /* synthetic */ TimingData(long l, int n, TraceMap traceMap, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                string = "";
            }
            this(l, n, traceMap, string);
        }

        public final long getTime() {
            return this.time;
        }

        public final void setTime(long l) {
            this.time = l;
        }

        public final int getTicks() {
            return this.ticks;
        }

        public final void setTicks(int n) {
            this.ticks = n;
        }

        @NotNull
        public final TraceMap getTraces() {
            return this.traces;
        }

        public final void setTraces(@NotNull TraceMap traceMap) {
            Intrinsics.checkNotNullParameter((Object)traceMap, (String)"<set-?>");
            this.traces = traceMap;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.name = string;
        }

        public final long component1() {
            return this.time;
        }

        public final int component2() {
            return this.ticks;
        }

        @NotNull
        public final TraceMap component3() {
            return this.traces;
        }

        @NotNull
        public final String component4() {
            return this.name;
        }

        @NotNull
        public final TimingData copy(long time, int ticks, @NotNull TraceMap traces, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)traces, (String)"traces");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new TimingData(time, ticks, traces, name);
        }

        public static /* synthetic */ TimingData copy$default(TimingData timingData, long l, int n, TraceMap traceMap, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                l = timingData.time;
            }
            if ((n2 & 2) != 0) {
                n = timingData.ticks;
            }
            if ((n2 & 4) != 0) {
                traceMap = timingData.traces;
            }
            if ((n2 & 8) != 0) {
                string = timingData.name;
            }
            return timingData.copy(l, n, traceMap, string);
        }

        @NotNull
        public String toString() {
            return "TimingData(time=" + this.time + ", ticks=" + this.ticks + ", traces=" + this.traces + ", name=" + this.name + ')';
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.time);
            result2 = result2 * 31 + Integer.hashCode(this.ticks);
            result2 = result2 * 31 + this.traces.hashCode();
            result2 = result2 * 31 + this.name.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TimingData)) {
                return false;
            }
            TimingData timingData = (TimingData)other;
            if (this.time != timingData.time) {
                return false;
            }
            if (this.ticks != timingData.ticks) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.traces, (Object)timingData.traces)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)timingData.name);
        }
    }
}

