/*
 * Decompiled with CFR 0.152.
 */
package observable.shadow.imgui.font;

import glm_.ExtensionsKt;
import glm_.glm;
import glm_.vec1.Vec1i;
import glm_.vec2.Vec2;
import glm_.vec4.Vec4;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import observable.shadow.imgui.GenericMathKt;
import observable.shadow.imgui.HelpersKt;
import observable.shadow.imgui.ImGui;
import observable.shadow.imgui.TmpKt;
import observable.shadow.imgui.api.ContextKt;
import observable.shadow.imgui.classes.DrawList;
import observable.shadow.imgui.classes.DrawVert_Buffer;
import observable.shadow.imgui.font.Font$Companion$WhenMappings;
import observable.shadow.imgui.font.FontAtlas;
import observable.shadow.imgui.font.FontConfig;
import observable.shadow.imgui.font.FontGlyph;
import observable.shadow.imgui.internal.DrawCmd;
import observable.shadow.imgui.internal.DrawVert;
import observable.shadow.imgui.internal.Generic_helpersKt;
import observable.shadow.imgui.internal.classes.Window;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.Platform;
import uno.kotlin.UtilKt;
import unsigned.ByteKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u008b\u00012\u00020\u0001:\u0002\u008b\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J`\u0010W\u001a\u00020X2\b\u0010Y\u001a\u0004\u0018\u00010\u000f2\u0006\u0010Z\u001a\u00020\u00042\u0006\u0010[\u001a\u00020\b2\u0006\u0010\\\u001a\u00020\b2\u0006\u0010]\u001a\u00020\b2\u0006\u0010^\u001a\u00020\b2\u0006\u0010_\u001a\u00020\b2\u0006\u0010`\u001a\u00020\b2\u0006\u0010a\u001a\u00020\b2\u0006\u0010b\u001a\u00020\b2\u0006\u0010c\u001a\u00020\bJ \u0010d\u001a\u00020X2\u0006\u0010e\u001a\u00020\u00042\u0006\u0010f\u001a\u00020\u00042\b\b\u0002\u0010g\u001a\u00020%J\u0006\u0010h\u001a\u00020XJF\u0010i\u001a\u00020+2\u0006\u0010j\u001a\u00020\b2\u0006\u0010k\u001a\u00020\b2\u0006\u0010l\u001a\u00020\b2\u0006\u0010m\u001a\u00020T2\b\b\u0002\u0010n\u001a\u00020\u00042\b\b\u0002\u0010o\u001a\u00020\u00042\n\b\u0002\u0010p\u001a\u0004\u0018\u00010qJ.\u0010r\u001a\u00020\u00042\u0006\u0010P\u001a\u00020\b2\u0006\u0010m\u001a\u00020T2\u0006\u0010n\u001a\u00020\u00042\u0006\u0010o\u001a\u00020\u00042\u0006\u0010s\u001a\u00020\bJ\u0006\u0010t\u001a\u00020XJ\u0010\u0010u\u001a\u0004\u0018\u00010>2\u0006\u0010v\u001a\u000201J\u0010\u0010u\u001a\u0004\u0018\u00010>2\u0006\u0010v\u001a\u00020\u0004J\u0010\u0010w\u001a\u0004\u0018\u00010>2\u0006\u0010v\u001a\u000201J\u0010\u0010w\u001a\u0004\u0018\u00010>2\u0006\u0010v\u001a\u00020\u0004J\u000e\u0010x\u001a\u00020\b2\u0006\u0010v\u001a\u000201J\u0010\u0010y\u001a\u00020X2\u0006\u0010z\u001a\u00020\u0004H\u0002J\u0016\u0010{\u001a\u00020%2\u0006\u0010|\u001a\u00020\u00042\u0006\u0010}\u001a\u00020\u0004J1\u0010~\u001a\u00020X2\u0007\u0010\u007f\u001a\u00030\u0080\u00012\u0006\u0010j\u001a\u00020\b2\u0007\u0010\u0081\u0001\u001a\u00020+2\u0007\u0010\u0082\u0001\u001a\u00020\u00042\u0006\u0010v\u001a\u000201Jd\u0010\u0083\u0001\u001a\u00020X2\u0007\u0010\u007f\u001a\u00030\u0080\u00012\u0006\u0010j\u001a\u00020\b2\u0007\u0010\u0081\u0001\u001a\u00020+2\u0007\u0010\u0082\u0001\u001a\u00020\u00042\b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\u0006\u0010m\u001a\u00020T2\u0006\u0010n\u001a\u00020\u00042\t\b\u0002\u0010\u0086\u0001\u001a\u00020\u00042\b\b\u0002\u0010l\u001a\u00020\b2\t\b\u0002\u0010\u0087\u0001\u001a\u00020%J\u0007\u0010\u0088\u0001\u001a\u00020XJ\u001a\u0010\u0089\u0001\u001a\u00020X2\u0006\u0010v\u001a\u0002012\t\b\u0002\u0010\u008a\u0001\u001a\u00020%R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR!\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0006\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\n\"\u0004\b#\u0010\fR\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u000201X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001a\u00106\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\n\"\u0004\b8\u0010\fR$\u0010:\u001a\u0002012\u0006\u00109\u001a\u000201@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u00103\"\u0004\b<\u00105R\u001c\u0010=\u001a\u0004\u0018\u00010>X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010@\"\u0004\bA\u0010BR\u001a\u0010C\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010\n\"\u0004\bE\u0010\fR!\u0010F\u001a\u0012\u0012\u0004\u0012\u00020>0\u000ej\b\u0012\u0004\u0012\u00020>`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010\u0012R!\u0010H\u001a\u0012\u0012\u0004\u0012\u00020\b0\u000ej\b\u0012\u0004\u0012\u00020\b`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010\u0012R!\u0010J\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u000ej\b\u0012\u0004\u0012\u00020\u0004`\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010\u0012R\u0011\u0010L\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\bL\u0010'R\u001a\u0010M\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010\u0006\"\u0004\bO\u0010\u0016R\u001a\u0010P\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010\n\"\u0004\bR\u0010\fR\u0011\u0010S\u001a\u00020T\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010V\u00a8\u0006\u008c\u0001"}, d2={"Lobservable/shadow/imgui/font/Font;", "", "()V", "TABSIZE", "", "getTABSIZE", "()I", "ascent", "", "getAscent", "()F", "setAscent", "(F)V", "configData", "Ljava/util/ArrayList;", "Lobservable/shadow/imgui/font/FontConfig;", "Lkotlin/collections/ArrayList;", "getConfigData", "()Ljava/util/ArrayList;", "configDataCount", "getConfigDataCount", "setConfigDataCount", "(I)V", "containerAtlas", "Lobservable/shadow/imgui/font/FontAtlas;", "getContainerAtlas", "()Limgui/font/FontAtlas;", "setContainerAtlas", "(Limgui/font/FontAtlas;)V", "debugName", "", "getDebugName", "()Ljava/lang/String;", "descent", "getDescent", "setDescent", "dirtyLookupTables", "", "getDirtyLookupTables", "()Z", "setDirtyLookupTables", "(Z)V", "displayOffset", "Lglm_/vec2/Vec2;", "getDisplayOffset", "()Lglm_/vec2/Vec2;", "setDisplayOffset", "(Lglm_/vec2/Vec2;)V", "ellipsisChar", "", "getEllipsisChar", "()C", "setEllipsisChar", "(C)V", "fallbackAdvanceX", "getFallbackAdvanceX", "setFallbackAdvanceX", "value", "fallbackChar", "getFallbackChar", "setFallbackChar", "fallbackGlyph", "Lobservable/shadow/imgui/font/FontGlyph;", "getFallbackGlyph", "()Limgui/font/FontGlyph;", "setFallbackGlyph", "(Limgui/font/FontGlyph;)V", "fontSize", "getFontSize", "setFontSize", "glyphs", "getGlyphs", "indexAdvanceX", "getIndexAdvanceX", "indexLookup", "getIndexLookup", "isLoaded", "metricsTotalSurface", "getMetricsTotalSurface", "setMetricsTotalSurface", "scale", "getScale", "setScale", "used4kPagesMap", "", "getUsed4kPagesMap", "()[B", "addGlyph", "", "cfg", "codepoint", "x0_", "y0", "x1_", "y1", "u0", "v0", "u1", "v1", "advanceX_", "addRemapChar", "dst", "src", "overwriteDst", "buildLookupTable", "calcTextSizeA", "size", "maxWidth", "wrapWidth", "text", "textBegin", "textEnd", "remaining", "Lglm_/vec1/Vec1i;", "calcWordWrapPositionA", "wrapWidth_", "clearOutputData", "findGlyph", "c", "findGlyphNoFallback", "getCharAdvance", "growIndex", "newSize", "isGlyphRangeUnused", "cBegin", "cLast", "renderChar", "drawList", "Lobservable/shadow/imgui/classes/DrawList;", "pos", "col", "renderText", "clipRect", "Lglm_/vec4/Vec4;", "textEnd_", "cpuFineClip", "setCurrent", "setGlyphVisible", "visible", "Companion", "core"})
public final class Font {
    @NotNull
    private final ArrayList<Float> indexAdvanceX = new ArrayList();
    private float fallbackAdvanceX;
    private float fontSize;
    @NotNull
    private final ArrayList<Integer> indexLookup = new ArrayList();
    @NotNull
    private final ArrayList<FontGlyph> glyphs = new ArrayList();
    @Nullable
    private FontGlyph fallbackGlyph;
    @NotNull
    private Vec2 displayOffset = new Vec2();
    @NotNull
    public FontAtlas containerAtlas;
    @NotNull
    private final ArrayList<FontConfig> configData = new ArrayList();
    private int configDataCount;
    private char fallbackChar = (char)63;
    private char ellipsisChar = (char)65535;
    private boolean dirtyLookupTables = true;
    private float scale = 1.0f;
    private float ascent;
    private float descent;
    private int metricsTotalSurface;
    @NotNull
    private final byte[] used4kPagesMap = new byte[2];
    private final int TABSIZE;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ArrayList<Float> getIndexAdvanceX() {
        return this.indexAdvanceX;
    }

    public final float getFallbackAdvanceX() {
        return this.fallbackAdvanceX;
    }

    public final void setFallbackAdvanceX(float f2) {
        this.fallbackAdvanceX = f2;
    }

    public final float getFontSize() {
        return this.fontSize;
    }

    public final void setFontSize(float f2) {
        this.fontSize = f2;
    }

    @NotNull
    public final ArrayList<Integer> getIndexLookup() {
        return this.indexLookup;
    }

    @NotNull
    public final ArrayList<FontGlyph> getGlyphs() {
        return this.glyphs;
    }

    @Nullable
    public final FontGlyph getFallbackGlyph() {
        return this.fallbackGlyph;
    }

    public final void setFallbackGlyph(@Nullable FontGlyph fontGlyph) {
        this.fallbackGlyph = fontGlyph;
    }

    @NotNull
    public final Vec2 getDisplayOffset() {
        return this.displayOffset;
    }

    public final void setDisplayOffset(@NotNull Vec2 vec2) {
        Intrinsics.checkNotNullParameter((Object)vec2, (String)"<set-?>");
        this.displayOffset = vec2;
    }

    @NotNull
    public final FontAtlas getContainerAtlas() {
        FontAtlas fontAtlas = this.containerAtlas;
        if (fontAtlas == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerAtlas");
        }
        return fontAtlas;
    }

    public final void setContainerAtlas(@NotNull FontAtlas fontAtlas) {
        Intrinsics.checkNotNullParameter((Object)fontAtlas, (String)"<set-?>");
        this.containerAtlas = fontAtlas;
    }

    @NotNull
    public final ArrayList<FontConfig> getConfigData() {
        return this.configData;
    }

    public final int getConfigDataCount() {
        return this.configDataCount;
    }

    public final void setConfigDataCount(int n) {
        this.configDataCount = n;
    }

    public final char getFallbackChar() {
        return this.fallbackChar;
    }

    public final void setFallbackChar(char value) {
        this.fallbackChar = value;
        this.buildLookupTable();
    }

    public final char getEllipsisChar() {
        return this.ellipsisChar;
    }

    public final void setEllipsisChar(char c) {
        this.ellipsisChar = c;
    }

    public final boolean getDirtyLookupTables() {
        return this.dirtyLookupTables;
    }

    public final void setDirtyLookupTables(boolean bl) {
        this.dirtyLookupTables = bl;
    }

    public final float getScale() {
        return this.scale;
    }

    public final void setScale(float f2) {
        this.scale = f2;
    }

    public final float getAscent() {
        return this.ascent;
    }

    public final void setAscent(float f2) {
        this.ascent = f2;
    }

    public final float getDescent() {
        return this.descent;
    }

    public final void setDescent(float f2) {
        this.descent = f2;
    }

    public final int getMetricsTotalSurface() {
        return this.metricsTotalSurface;
    }

    public final void setMetricsTotalSurface(int n) {
        this.metricsTotalSurface = n;
    }

    @NotNull
    public final byte[] getUsed4kPagesMap() {
        return this.used4kPagesMap;
    }

    @Nullable
    public final FontGlyph findGlyph(char c) {
        return this.findGlyph(Companion.remapCodepointIfProblematic$core(c));
    }

    @Nullable
    public final FontGlyph findGlyph(int c) {
        Object object;
        block3: {
            block2: {
                object = (Integer)CollectionsKt.getOrNull((List)this.indexLookup, (int)c);
                if (object == null) break block2;
                Integer n = object;
                boolean bl = false;
                boolean bl2 = false;
                int it = ((Number)n).intValue();
                boolean bl3 = false;
                object = (FontGlyph)CollectionsKt.getOrNull((List)this.glyphs, (int)it);
                if (object != null) break block3;
            }
            object = this.fallbackGlyph;
        }
        return object;
    }

    @Nullable
    public final FontGlyph findGlyphNoFallback(char c) {
        return this.findGlyphNoFallback(ExtensionsKt.getI(c));
    }

    @Nullable
    public final FontGlyph findGlyphNoFallback(int c) {
        FontGlyph fontGlyph;
        Integer n = (Integer)CollectionsKt.getOrNull((List)this.indexLookup, (int)c);
        if (n != null) {
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n2).intValue();
            boolean bl3 = false;
            fontGlyph = (FontGlyph)CollectionsKt.getOrNull((List)this.glyphs, (int)it);
        } else {
            fontGlyph = null;
        }
        return fontGlyph;
    }

    public final float getCharAdvance(char c) {
        float f2;
        if (ExtensionsKt.compareTo(c, this.indexAdvanceX.size()) < 0) {
            Float f3 = this.indexAdvanceX.get(ExtensionsKt.getI(c));
            Intrinsics.checkNotNullExpressionValue((Object)f3, (String)"indexAdvanceX[c.i]");
            f2 = ((Number)f3).floatValue();
        } else {
            f2 = this.fallbackAdvanceX;
        }
        return f2;
    }

    public final boolean isLoaded() {
        return this.containerAtlas != null;
    }

    @NotNull
    public final String getDebugName() {
        Object object = (FontConfig)CollectionsKt.getOrNull((List)this.configData, (int)0);
        if (object == null || (object = ((FontConfig)object).getName()) == null) {
            object = "<unknown>";
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Vec2 calcTextSizeA(float size2, float maxWidth, float wrapWidth, @NotNull byte[] text, int textBegin, int textEnd, @Nullable Vec1i remaining) {
        Vec2 textSize;
        block16: {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            float lineHeight = size2;
            float scale = size2 / this.fontSize;
            textSize = new Vec2((Number)0, null, 2, null);
            float lineWidth = 0.0f;
            boolean wordWrapEnabled = wrapWidth > 0.0f;
            int wordWrapEol = -1;
            int s = textBegin;
            block0: while (s < textEnd) {
                Object object;
                if (wordWrapEnabled) {
                    if (wordWrapEol == -1 && (wordWrapEol = this.calcWordWrapPositionA(scale, text, s, textEnd, wrapWidth - lineWidth)) == s) {
                        ++wordWrapEol;
                    }
                    if (s >= wordWrapEol) {
                        if (textSize.getX().floatValue() < lineWidth) {
                            textSize.setX(lineWidth);
                        }
                        Vec2 vec2 = textSize;
                        vec2.setY(vec2.getY().floatValue() + lineHeight);
                        lineWidth = 0.0f;
                        wordWrapEol = -1;
                        while (s < textEnd) {
                            int c = ByteKt.toUInt(text[s]);
                            if (Generic_helpersKt.charIsBlankA(c)) {
                                ++s;
                                continue;
                            }
                            if (c != ExtensionsKt.getI('\n')) continue block0;
                            ++s;
                            continue block0;
                        }
                        continue;
                    }
                }
                int prevS = s;
                int c = ByteKt.toUInt(text[s]);
                if (c < 128) {
                    ++s;
                } else {
                    void char_;
                    Pair<Integer, Integer> pair = Generic_helpersKt.textCharFromUtf8(text, s, textEnd);
                    int n = ((Number)pair.component1()).intValue();
                    int bytes2 = ((Number)pair.component2()).intValue();
                    c = char_;
                    s += bytes2;
                    if (c == 0) break;
                }
                if (c < 32) {
                    if (c == ExtensionsKt.getI('\n')) {
                        textSize.setX(glm.INSTANCE.max(textSize.getX().floatValue(), lineWidth));
                        Vec2 vec2 = textSize;
                        vec2.setY(vec2.getY().floatValue() + lineHeight);
                        lineWidth = 0.0f;
                        continue;
                    }
                    if (c == ExtensionsKt.getI('\r')) continue;
                }
                List list2 = this.indexAdvanceX;
                boolean bl = false;
                if (c >= 0 && c <= CollectionsKt.getLastIndex((List)list2)) {
                    object = list2.get(c);
                } else {
                    int it = c;
                    boolean bl2 = false;
                    object = Float.valueOf(this.fallbackAdvanceX);
                }
                float charWidth = ((Number)object).floatValue() * scale;
                if (lineWidth + charWidth >= maxWidth) {
                    s = prevS;
                    break;
                }
                lineWidth += charWidth;
            }
            if (textSize.getX().floatValue() < lineWidth) {
                textSize.setX(lineWidth);
            }
            if (lineWidth > 0.0f || textSize.getY().floatValue() == 0.0f) {
                Vec2 vec2 = textSize;
                vec2.setY(vec2.getY().floatValue() + lineHeight);
            }
            Vec1i vec1i = remaining;
            if (vec1i == null) break block16;
            vec1i.put(s);
        }
        return textSize;
    }

    public static /* synthetic */ Vec2 calcTextSizeA$default(Font font2, float f2, float f3, float f4, byte[] byArray, int n, int n2, Vec1i vec1i, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            n = 0;
        }
        if ((n3 & 0x20) != 0) {
            n2 = HelpersKt.strlen$default(byArray, 0, 1, null);
        }
        if ((n3 & 0x40) != 0) {
            vec1i = null;
        }
        return font2.calcTextSizeA(f2, f3, f4, byArray, n, n2, vec1i);
    }

    /*
     * WARNING - void declaration
     */
    public final int calcWordWrapPositionA(float scale, @NotNull byte[] text, int textBegin, int textEnd, float wrapWidth_) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        float lineWidth = 0.0f;
        float wordWidth = 0.0f;
        float blankWidth = 0.0f;
        float wrapWidth = wrapWidth_ / scale;
        int wordEnd = textBegin;
        int prevWordEnd = -1;
        boolean insideWord = true;
        int s = textBegin;
        while (s < textEnd) {
            Object object;
            int n;
            int c = ByteKt.toUInt(text[s]);
            if (c < 128) {
                n = 1;
            } else {
                void char_;
                Pair<Integer, Integer> pair = Generic_helpersKt.textCharFromUtf8(text, s, textEnd);
                int n2 = ((Number)pair.component1()).intValue();
                int bytes2 = ((Number)pair.component2()).intValue();
                c = char_;
                n = bytes2;
            }
            int nextS = s + n;
            if (c == 0) break;
            if (c < 32) {
                if (c == ExtensionsKt.getI('\n')) {
                    lineWidth = 0.0f;
                    wordWidth = 0.0f;
                    blankWidth = 0.0f;
                    insideWord = true;
                    s = nextS;
                    continue;
                }
                if (c == ExtensionsKt.getI('\r')) {
                    s = nextS;
                    continue;
                }
            }
            List list2 = this.indexAdvanceX;
            boolean bl = false;
            if (c >= 0 && c <= CollectionsKt.getLastIndex((List)list2)) {
                object = list2.get(c);
            } else {
                int it = c;
                boolean bl2 = false;
                object = Float.valueOf(this.fallbackAdvanceX);
            }
            float charWidth = ((Number)object).floatValue();
            if (Generic_helpersKt.charIsBlankW(c)) {
                if (insideWord) {
                    lineWidth += blankWidth;
                    blankWidth = 0.0f;
                    wordEnd = s;
                }
                blankWidth += charWidth;
                insideWord = false;
            } else {
                wordWidth += charWidth;
                if (insideWord) {
                    wordEnd = nextS;
                } else {
                    prevWordEnd = wordEnd;
                    lineWidth += wordWidth + blankWidth;
                    wordWidth = 0.0f;
                    blankWidth = 0.0f;
                }
                boolean bl3 = insideWord = c != ExtensionsKt.getI('.') && c != ExtensionsKt.getI(',') && c != ExtensionsKt.getI(';') && c != ExtensionsKt.getI('!') && c != ExtensionsKt.getI('?') && c != ExtensionsKt.getI('\"');
            }
            if (lineWidth + wordWidth > wrapWidth) {
                if (!(wordWidth < wrapWidth)) break;
                s = prevWordEnd != -1 ? prevWordEnd : wordEnd;
                break;
            }
            s = nextS;
        }
        return s;
    }

    public final void renderChar(@NotNull DrawList drawList, float size2, @NotNull Vec2 pos5, int col, char c) {
        Intrinsics.checkNotNullParameter((Object)drawList, (String)"drawList");
        Intrinsics.checkNotNullParameter((Object)pos5, (String)"pos");
        FontGlyph glyph = this.findGlyph(c);
        if (glyph == null || !glyph.getVisible()) {
            return;
        }
        float scale = size2 >= 0.0f ? size2 / this.fontSize : 1.0f;
        float f2 = pos5.getX().floatValue() + this.displayOffset.getX().floatValue();
        boolean bl = false;
        float x = (float)Math.floor(f2);
        float f3 = pos5.getY().floatValue() + this.displayOffset.getY().floatValue();
        boolean bl2 = false;
        float y = (float)Math.floor(f3);
        drawList.primReserve(6, 4);
        drawList.primRectUV(new Vec2(x + glyph.getX0() * scale, y + glyph.getY0() * scale), new Vec2(x + glyph.getX1() * scale, y + glyph.getY1() * scale), new Vec2(glyph.getU0(), glyph.getV0()), new Vec2(glyph.getU1(), glyph.getV1()), col);
    }

    /*
     * WARNING - void declaration
     */
    public final void renderText(@NotNull DrawList drawList, float size2, @NotNull Vec2 pos5, int col, @NotNull Vec4 clipRect, @NotNull byte[] text, int textBegin, int textEnd_, float wrapWidth, boolean cpuFineClip) {
        int value$iv$iv;
        int value$iv;
        void value$iv$iv2;
        int value$iv2;
        Intrinsics.checkNotNullParameter((Object)drawList, (String)"drawList");
        Intrinsics.checkNotNullParameter((Object)pos5, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)clipRect, (String)"clipRect");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int textEnd = textEnd_;
        float f2 = pos5.getX().floatValue();
        boolean bl = false;
        float f3 = (float)Math.floor(f2) + this.displayOffset.getX().floatValue();
        f2 = pos5.getY().floatValue();
        bl = false;
        Vec2 vec2 = pos5.invoke(f3, (float)Math.floor(f2) + this.displayOffset.getY().floatValue());
        float f4 = ((Number)vec2.component1()).floatValue();
        float y = ((Number)vec2.component2()).floatValue();
        if (y > clipRect.getW().floatValue()) {
            return;
        }
        float scale = size2 / this.fontSize;
        float lineHeight = this.fontSize * scale;
        boolean wordWrapEnabled = wrapWidth > 0.0f;
        int wordWrapEol = 0;
        int s = textBegin;
        if (y + lineHeight < clipRect.getY().floatValue() && !wordWrapEnabled) {
            while (y + lineHeight < clipRect.getY().floatValue() && s < textEnd) {
                s = (s = HelpersKt.memchr$default(text, s, '\n', 0, 4, null)) == -1 ? s + 1 : textEnd;
                y += lineHeight;
            }
        }
        if (textEnd - s > 10000 && !wordWrapEnabled) {
            int sEnd = s;
            for (float yEnd = y; yEnd < clipRect.getW().floatValue() && s < textEnd; yEnd += lineHeight) {
                sEnd = (sEnd = HelpersKt.memchr$default(text, sEnd, '\n', 0, 4, null)) == -1 ? sEnd + 1 : textEnd;
            }
            textEnd = sEnd;
        }
        if (s == textEnd) {
            return;
        }
        int vtxCountMax = (textEnd - s) * 4;
        int idxCountMax = (textEnd - s) * 6;
        Buffer $this$lim$iv = drawList.getIdxBuffer();
        int $i$f$getLim = 0;
        int idxExpectedSize = $this$lim$iv.limit() + idxCountMax;
        drawList.primReserve(idxCountMax, vtxCountMax);
        $i$f$getLim = drawList.get_vtxWritePtr();
        ByteBuffer $this$iv = drawList.getVtxBuffer-sdVSLMk();
        boolean $i$f$setPos = false;
        void var25_28 = value$iv2 * DrawVert.Companion.getSize();
        Buffer $this$pos$iv$iv2 = $this$iv;
        boolean $i$f$setPos2 = false;
        $this$pos$iv$iv2.position((int)value$iv$iv2);
        value$iv2 = drawList.get_idxWritePtr();
        Buffer $this$pos$iv = drawList.getIdxBuffer();
        $i$f$setPos = false;
        $this$pos$iv.position(value$iv2);
        int vtxWrite = drawList.get_vtxWritePtr();
        int idxWrite = drawList.get_idxWritePtr();
        int vtxCurrentIdx = drawList.get_vtxCurrentIdx();
        block2: while (s < textEnd) {
            FontGlyph glyph;
            int c;
            float x;
            if (wordWrapEnabled) {
                if (wordWrapEol == 0 && (wordWrapEol = this.calcWordWrapPositionA(scale, text, s, textEnd, wrapWidth - (x - pos5.getX().floatValue()))) == s) {
                    ++wordWrapEol;
                }
                if (s >= wordWrapEol) {
                    x = pos5.getX().floatValue();
                    y += lineHeight;
                    wordWrapEol = 0;
                    while (s < textEnd) {
                        c = ByteKt.toUInt(text[s]);
                        if (Generic_helpersKt.charIsBlankA(c)) {
                            ++s;
                            continue;
                        }
                        if (c != ExtensionsKt.getI('\n')) continue block2;
                        ++s;
                        continue block2;
                    }
                    continue;
                }
            }
            if ((c = ByteKt.toUInt(text[s])) < 128) {
                ++s;
            } else {
                void char_;
                Pair<Integer, Integer> pair = Generic_helpersKt.textCharFromUtf8(text, s, textEnd);
                int $this$pos$iv$iv2 = ((Number)pair.component1()).intValue();
                int bytes2 = ((Number)pair.component2()).intValue();
                c = char_;
                s += bytes2;
                if (c == 0) break;
            }
            if (c < 32) {
                if (c == ExtensionsKt.getI('\n')) {
                    x = pos5.getX().floatValue();
                    if (!((y += lineHeight) > clipRect.getW().floatValue())) continue;
                    break;
                }
                if (c == ExtensionsKt.getI('\r')) continue;
            }
            if (this.findGlyph(c) == null) {
                continue;
            }
            float charWidth = glyph.getAdvanceX() * scale;
            if (glyph.getVisible()) {
                float x1 = x + glyph.getX0() * scale;
                float x2 = x + glyph.getX1() * scale;
                float y1 = y + glyph.getY0() * scale;
                float y2 = y + glyph.getY1() * scale;
                if (x1 <= clipRect.getZ().floatValue() && x2 >= clipRect.getX().floatValue()) {
                    float u1 = glyph.getU0();
                    float v1 = glyph.getV0();
                    float u2 = glyph.getU1();
                    float v2 = glyph.getV1();
                    if (cpuFineClip) {
                        if (x1 < clipRect.getX().floatValue()) {
                            u1 += (1.0f - (x2 - clipRect.getX().floatValue()) / (x2 - x1)) * (u2 - u1);
                            x1 = clipRect.getX().floatValue();
                        }
                        if (y1 < clipRect.getY().floatValue()) {
                            v1 += (1.0f - (y2 - clipRect.getY().floatValue()) / (y2 - y1)) * (v2 - v1);
                            y1 = clipRect.getY().floatValue();
                        }
                        if (x2 > clipRect.getZ().floatValue()) {
                            u2 = u1 + (clipRect.getZ().floatValue() - x1) / (x2 - x1) * (u2 - u1);
                            x2 = clipRect.getZ().floatValue();
                        }
                        if (y2 > clipRect.getW().floatValue()) {
                            v2 = v1 + (clipRect.getW().floatValue() - y1) / (y2 - y1) * (v2 - v1);
                            y2 = clipRect.getW().floatValue();
                        }
                        if (y1 >= y2) {
                            x += charWidth;
                            continue;
                        }
                    }
                    DrawList drawList2 = drawList;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    DrawList $this$apply = drawList2;
                    boolean bl4 = false;
                    Buffer buffer2 = $this$apply.getIdxBuffer();
                    boolean bl5 = false;
                    boolean bl6 = false;
                    IntBuffer it = buffer2;
                    boolean bl7 = false;
                    UtilKt.plusAssign(it, vtxCurrentIdx);
                    UtilKt.plusAssign(it, vtxCurrentIdx + 1);
                    UtilKt.plusAssign(it, vtxCurrentIdx + 2);
                    UtilKt.plusAssign(it, vtxCurrentIdx);
                    UtilKt.plusAssign(it, vtxCurrentIdx + 2);
                    UtilKt.plusAssign(it, vtxCurrentIdx + 3);
                    buffer2 = $this$apply.getVtxBuffer-sdVSLMk();
                    bl5 = false;
                    bl6 = false;
                    it = buffer2;
                    boolean bl8 = false;
                    DrawVert_Buffer.plusAssign-impl((ByteBuffer)((Object)it), x1);
                    DrawVert_Buffer.plusAssign-impl((ByteBuffer)((Object)it), y1);
                    DrawVert_Buffer.plusAssign-impl((ByteBuffer)((Object)it), u1);
                    DrawVert_Buffer.plusAssign-impl((ByteBuffer)((Object)it), v1);
                    DrawVert_Buffer.plusAssign-impl((ByteBuffer)((Object)it), col);
                    DrawVert_Buffer.plusAssign-impl((ByteBuffer)((Object)it), x2);
                    DrawVert_Buffer.plusAssign-impl((ByteBuffer)((Object)it), y1);
                    DrawVert_Buffer.plusAssign-impl((ByteBuffer)((Object)it), u2);
                    DrawVert_Buffer.plusAssign-impl((ByteBuffer)((Object)it), v1);
                    DrawVert_Buffer.plusAssign-impl((ByteBuffer)((Object)it), col);
                    DrawVert_Buffer.plusAssign-impl((ByteBuffer)((Object)it), x2);
                    DrawVert_Buffer.plusAssign-impl((ByteBuffer)((Object)it), y2);
                    DrawVert_Buffer.plusAssign-impl((ByteBuffer)((Object)it), u2);
                    DrawVert_Buffer.plusAssign-impl((ByteBuffer)((Object)it), v2);
                    DrawVert_Buffer.plusAssign-impl((ByteBuffer)((Object)it), col);
                    DrawVert_Buffer.plusAssign-impl((ByteBuffer)((Object)it), x1);
                    DrawVert_Buffer.plusAssign-impl((ByteBuffer)((Object)it), y2);
                    DrawVert_Buffer.plusAssign-impl((ByteBuffer)((Object)it), u1);
                    DrawVert_Buffer.plusAssign-impl((ByteBuffer)((Object)it), v2);
                    DrawVert_Buffer.plusAssign-impl((ByteBuffer)((Object)it), col);
                    vtxWrite += 4;
                    vtxCurrentIdx += 4;
                    idxWrite += 6;
                }
            }
            x += charWidth;
        }
        boolean glyph = false;
        ByteBuffer $this$iv2 = drawList.getVtxBuffer-sdVSLMk();
        $i$f$setPos2 = false;
        void x1 = value$iv * DrawVert.Companion.getSize();
        Buffer $this$pos$iv$iv3 = $this$iv2;
        boolean $i$f$setPos3 = false;
        $this$pos$iv$iv3.position(value$iv$iv);
        value$iv = 0;
        Buffer $this$pos$iv2 = drawList.getIdxBuffer();
        $i$f$setPos2 = false;
        $this$pos$iv2.position(value$iv);
        value$iv = vtxWrite;
        $this$iv2 = drawList.getVtxBuffer-sdVSLMk();
        boolean $i$f$setLim = false;
        value$iv$iv = value$iv * DrawVert.Companion.getSize();
        Buffer $this$lim$iv$iv = $this$iv2;
        boolean $i$f$setLim2 = false;
        $this$lim$iv$iv.limit(value$iv$iv);
        value$iv = idxWrite;
        Buffer $this$lim$iv2 = drawList.getIdxBuffer();
        $i$f$setLim = false;
        $this$lim$iv2.limit(value$iv);
        DrawCmd drawCmd = (DrawCmd)CollectionsKt.last((List)drawList.getCmdBuffer());
        $this$lim$iv2 = drawList.getIdxBuffer();
        boolean $i$f$getLim2 = false;
        drawCmd.setElemCount(drawCmd.getElemCount() - (idxExpectedSize - $this$lim$iv2.limit()));
        drawList.set_vtxWritePtr(vtxWrite);
        drawList.set_idxWritePtr(idxWrite);
        drawList.set_vtxCurrentIdx(vtxCurrentIdx);
    }

    public static /* synthetic */ void renderText$default(Font font2, DrawList drawList, float f2, Vec2 vec2, int n, Vec4 vec42, byte[] byArray, int n2, int n3, float f3, boolean bl, int n4, Object object) {
        if ((n4 & 0x80) != 0) {
            n3 = HelpersKt.strlen(byArray, n2);
        }
        if ((n4 & 0x100) != 0) {
            f3 = 0.0f;
        }
        if ((n4 & 0x200) != 0) {
            bl = false;
        }
        font2.renderText(drawList, f2, vec2, n, vec42, byArray, n2, n3, f3, bl);
    }

    public final int getTABSIZE() {
        return this.TABSIZE;
    }

    /*
     * WARNING - void declaration
     */
    public final void buildLookupTable() {
        FontGlyph it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv22 = this.glyphs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv22;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FontGlyph fontGlyph = (FontGlyph)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer n = ExtensionsKt.getI(it.getCodepoint());
            collection.add(n);
        }
        Comparable comparable = CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNull((Object)comparable);
        int maxCodepoint = ((Number)((Object)comparable)).intValue();
        boolean $this$map$iv22 = this.glyphs.size() < 65535;
        $i$f$map = false;
        if (_Assertions.ENABLED && !$this$map$iv22) {
            boolean $i$a$-assert-Font$buildLookupTable$22 = false;
            String $i$a$-assert-Font$buildLookupTable$22 = "-1 is reserved";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-Font$buildLookupTable$22));
        }
        this.indexAdvanceX.clear();
        this.indexLookup.clear();
        this.dirtyLookupTables = false;
        ArraysKt.fill$default((byte[])this.used4kPagesMap, (byte)0, (int)0, (int)0, (int)6, null);
        this.growIndex(maxCodepoint + 1);
        Iterable $this$forEachIndexed$iv = this.glyphs;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void g;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            it = (FontGlyph)item$iv;
            int i2 = n;
            boolean bl2 = false;
            this.indexAdvanceX.set(ExtensionsKt.getI(g.getCodepoint()), Float.valueOf(g.getAdvanceX()));
            this.indexLookup.set(ExtensionsKt.getI(g.getCodepoint()), i2);
            int pageN = ExtensionsKt.getI(g.getCodepoint()) / 4096;
            this.used4kPagesMap[pageN >> 3] = ExtensionsKt.or(this.used4kPagesMap[pageN >> 3], 1 << (pageN & 7));
        }
        if (this.findGlyph(' ') != null) {
            if (((FontGlyph)CollectionsKt.last((List)this.glyphs)).getCodepoint() != '\t') {
                $this$forEachIndexed$iv = this.glyphs;
                FontGlyph fontGlyph = new FontGlyph();
                boolean bl = false;
                $this$forEachIndexed$iv.add(fontGlyph);
            }
            FontGlyph tabGlyph = (FontGlyph)CollectionsKt.last((List)this.glyphs);
            FontGlyph fontGlyph = this.findGlyph(' ');
            Intrinsics.checkNotNull((Object)fontGlyph);
            tabGlyph.put(fontGlyph);
            tabGlyph.setCodepoint('\t');
            FontGlyph fontGlyph2 = tabGlyph;
            fontGlyph2.setAdvanceX(fontGlyph2.getAdvanceX() * (float)this.TABSIZE);
            this.indexAdvanceX.set(ExtensionsKt.getI(tabGlyph.getCodepoint()), Float.valueOf(tabGlyph.getAdvanceX()));
            this.indexLookup.set(ExtensionsKt.getI(tabGlyph.getCodepoint()), CollectionsKt.getLastIndex((List)this.glyphs));
        }
        this.setGlyphVisible(' ', false);
        this.setGlyphVisible('\t', false);
        FontGlyph fontGlyph = this.fallbackGlyph = this.findGlyphNoFallback(this.fallbackChar);
        this.fallbackAdvanceX = fontGlyph != null ? fontGlyph.getAdvanceX() : 0.0f;
        int tabGlyph = 0;
        int n = maxCodepoint + 1;
        while (tabGlyph < n) {
            void i3;
            if (Float.compare(((Number)this.indexAdvanceX.get((int)i3)).floatValue(), 0.0f) < 0) {
                this.indexAdvanceX.set((int)i3, Float.valueOf(this.fallbackAdvanceX));
            }
            ++i3;
        }
    }

    public final void clearOutputData() {
        this.fontSize = 0.0f;
        this.fallbackAdvanceX = 0.0f;
        this.glyphs.clear();
        this.indexAdvanceX.clear();
        this.indexLookup.clear();
        this.fallbackGlyph = null;
        this.dirtyLookupTables = true;
        this.fallbackAdvanceX = 0.0f;
        this.configDataCount = 0;
        this.configData.clear();
        FontAtlas fontAtlas = this.containerAtlas;
        if (fontAtlas == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerAtlas");
        }
        fontAtlas.clearInputData();
        FontAtlas fontAtlas2 = this.containerAtlas;
        if (fontAtlas2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerAtlas");
        }
        fontAtlas2.clearTexData();
        this.ascent = 0.0f;
        this.descent = 0.0f;
        this.metricsTotalSurface = 0;
    }

    /*
     * WARNING - void declaration
     */
    private final void growIndex(int newSize) {
        int n = this.indexAdvanceX.size() == this.indexLookup.size() ? 1 : 0;
        int n2 = 0;
        boolean bl = false;
        if (_Assertions.ENABLED && n == 0) {
            boolean bl2 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (newSize <= this.indexLookup.size()) {
            return;
        }
        n = this.indexLookup.size();
        n2 = newSize;
        while (n < n2) {
            void i2;
            Collection collection = this.indexAdvanceX;
            Number number = Float.valueOf(-1.0f);
            boolean bl3 = false;
            collection.add(number);
            collection = this.indexLookup;
            number = -1;
            bl3 = false;
            collection.add(number);
            ++i2;
        }
    }

    public final void addGlyph(@Nullable FontConfig cfg, int codepoint, float x0_, float y0, float x1_, float y1, float u0, float v0, float u1, float v1, float advanceX_) {
        float x0 = x0_;
        float x1 = x1_;
        float advanceX = advanceX_;
        if (cfg != null) {
            float advanceXOriginal = advanceX;
            if ((advanceX = GenericMathKt.clamp((Number)Float.valueOf(advanceX), (Number)Float.valueOf(cfg.getGlyphMinAdvanceX()), (Number)Float.valueOf(cfg.getGlyphMaxAdvanceX())).floatValue()) != advanceXOriginal) {
                float f2;
                if (cfg.getPixelSnapH()) {
                    float f3 = (advanceX - advanceXOriginal) * 0.5f;
                    boolean bl = false;
                    f2 = (float)Math.floor(f3);
                } else {
                    f2 = (advanceX - advanceXOriginal) * 0.5f;
                }
                float charOffX = f2;
                x0 += charOffX;
                x1 += charOffX;
            }
            if (cfg.getPixelSnapH()) {
                advanceX = Generic_helpersKt.round(advanceX);
            }
            advanceX += cfg.getGlyphExtraSpacing().getX().floatValue();
        }
        FontGlyph glyph = new FontGlyph();
        Collection charOffX = this.glyphs;
        boolean bl = false;
        charOffX.add(glyph);
        glyph.setCodepoint(ExtensionsKt.getC(codepoint));
        glyph.setVisible(x0 != x1 && y0 != y1);
        glyph.setX0(x0);
        glyph.setY0(y0);
        glyph.setX1(x1);
        glyph.setY1(y1);
        glyph.setU0(u0);
        glyph.setV0(v0);
        glyph.setU1(u1);
        glyph.setV1(v1);
        glyph.setAdvanceX(advanceX);
        if (this.configData.get(0).getPixelSnapH()) {
            glyph.setAdvanceX(Generic_helpersKt.round(glyph.getAdvanceX()));
        }
        FontAtlas fontAtlas = this.containerAtlas;
        if (fontAtlas == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerAtlas");
        }
        float pad = (float)fontAtlas.getTexGlyphPadding() + 0.99f;
        this.dirtyLookupTables = true;
        float f4 = glyph.getU1() - glyph.getU0();
        FontAtlas fontAtlas2 = this.containerAtlas;
        if (fontAtlas2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerAtlas");
        }
        int n = ExtensionsKt.getI(Float.valueOf(f4 * (float)fontAtlas2.getTexSize().getX().intValue() + pad));
        float f5 = glyph.getV1() - glyph.getV0();
        FontAtlas fontAtlas3 = this.containerAtlas;
        if (fontAtlas3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerAtlas");
        }
        this.metricsTotalSurface += n * ExtensionsKt.getI(Float.valueOf(f5 * (float)fontAtlas3.getTexSize().getY().intValue() + pad));
    }

    public final void addRemapChar(int dst, int src, boolean overwriteDst) {
        Object object;
        Number number;
        ArrayList<Number> arrayList;
        int n;
        Object object2;
        Collection collection = this.indexLookup;
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        int indexSize = this.indexLookup.size();
        if (dst < indexSize) {
            Integer n2 = this.indexLookup.get(dst);
            if (n2 != null && n2 == -1 && !overwriteDst) {
                return;
            }
        }
        if (src >= indexSize && dst >= indexSize) {
            return;
        }
        this.growIndex(dst + 1);
        ArrayList<Integer> arrayList2 = this.indexLookup;
        int n3 = dst;
        List list2 = this.indexLookup;
        bl3 = false;
        if (src >= 0 && src <= CollectionsKt.getLastIndex((List)list2)) {
            object2 = list2.get(src);
        } else {
            int n4 = src;
            n = n3;
            arrayList = arrayList2;
            boolean bl5 = false;
            number = -1;
            arrayList2 = arrayList;
            n3 = n;
            object2 = number;
        }
        arrayList2.set(n3, (Integer)object2);
        ArrayList<Number> arrayList3 = this.indexAdvanceX;
        int n5 = dst;
        list2 = this.indexAdvanceX;
        bl3 = false;
        if (src >= 0 && src <= CollectionsKt.getLastIndex((List)list2)) {
            object = list2.get(src);
        } else {
            int it = src;
            n = n5;
            arrayList = arrayList3;
            boolean bl6 = false;
            number = Float.valueOf(1.0f);
            arrayList3 = arrayList;
            n5 = n;
            object = number;
        }
        arrayList3.set(n5, (Float)object);
    }

    public static /* synthetic */ void addRemapChar$default(Font font2, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = true;
        }
        font2.addRemapChar(n, n2, bl);
    }

    public final void setGlyphVisible(char c, boolean visible2) {
        block0: {
            FontGlyph fontGlyph = this.findGlyph(c);
            if (fontGlyph == null) break block0;
            fontGlyph.setVisible(visible2);
        }
    }

    public static /* synthetic */ void setGlyphVisible$default(Font font2, char c, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        font2.setGlyphVisible(c, bl);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isGlyphRangeUnused(int cBegin, int cLast) {
        int pageBegin = cBegin / 4096;
        int n = pageBegin;
        int pageLast = cLast / 4096;
        int n2 = pageLast;
        if (n <= n2) {
            while (true) {
                void pageN;
                if (pageN >>> 3 < this.used4kPagesMap.length && TmpKt.has(this.used4kPagesMap[pageN >>> 3], 1 << (pageN & 7))) {
                    return false;
                }
                if (pageN == n2) break;
                ++pageN;
            }
        }
        return true;
    }

    public final void setCurrent() {
        boolean bl = this.isLoaded();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Font Atlas not created. Did you call io.Fonts->GetTexDataAsRGBA32 / GetTexDataAsAlpha8 ?";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        bl = this.scale > 0.0f;
        bl2 = false;
        boolean bl4 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ContextKt.getG().setFont(this);
        ContextKt.getG().setFontBaseSize(ImGui.INSTANCE.getIo().getFontGlobalScale() * ContextKt.getG().getFont().fontSize * ContextKt.getG().getFont().scale);
        Window window = ContextKt.getG().getCurrentWindow();
        ContextKt.getG().setFontSize(window != null ? window.calcFontSize() : 0.0f);
        FontAtlas fontAtlas = ContextKt.getG().getFont().containerAtlas;
        if (fontAtlas == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"containerAtlas");
        }
        FontAtlas atlas = fontAtlas;
        ContextKt.getG().getDrawListSharedData().getTexUvWhitePixel().put(atlas.getTexUvWhitePixel());
        ContextKt.getG().getDrawListSharedData().setTexUvLines(atlas.getTexUvLines());
        ContextKt.getG().getDrawListSharedData().setFont(ContextKt.getG().getFont());
        ContextKt.getG().getDrawListSharedData().setFontSize(ContextKt.getG().getFontSize());
    }

    public Font() {
        this.TABSIZE = 4;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\f\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lobservable/shadow/imgui/font/Font$Companion;", "", "()V", "remapCodepointIfProblematic", "", "", "remapCodepointIfProblematic$core", "core"})
    public static final class Companion {
        /*
         * Enabled aggressive block sorting
         */
        public final int remapCodepointIfProblematic$core(char $this$remapCodepointIfProblematic) {
            int n;
            int i2 = $this$remapCodepointIfProblematic;
            Platform platform = Platform.get();
            if (platform != null) {
                switch (Font$Companion$WhenMappings.$EnumSwitchMapping$0[platform.ordinal()]) {
                    case 1: {
                        switch (i2) {
                            case 8364: {
                                return 128;
                            }
                            case 8218: {
                                return 130;
                            }
                            case 402: {
                                return 131;
                            }
                            case 8222: {
                                return 132;
                            }
                            case 8230: {
                                return 133;
                            }
                            case 8224: {
                                return 134;
                            }
                            case 8225: {
                                return 135;
                            }
                            case 710: {
                                return 136;
                            }
                            case 8240: {
                                return 137;
                            }
                            case 352: {
                                return 138;
                            }
                            case 8249: {
                                return 139;
                            }
                            case 338: {
                                return 140;
                            }
                            case 381: {
                                return 142;
                            }
                            case 8216: {
                                return 145;
                            }
                            case 8217: {
                                return 146;
                            }
                            case 8220: {
                                return 147;
                            }
                            case 8221: {
                                return 148;
                            }
                            case 8226: {
                                return 149;
                            }
                            case 8211: {
                                return 150;
                            }
                            case 8212: {
                                return 151;
                            }
                            case 732: {
                                return 152;
                            }
                            case 8482: {
                                return 153;
                            }
                            case 353: {
                                return 154;
                            }
                            case 8250: {
                                return 155;
                            }
                            case 339: {
                                return 156;
                            }
                            case 382: {
                                return 158;
                            }
                            case 376: {
                                return 159;
                            }
                        }
                        n = i2;
                        return n;
                    }
                }
            }
            n = i2;
            return n;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

