/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.blocks.whiteholes;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.roguelogix.phosphophyllite.energy.EnergyStorageWrapper;
import net.roguelogix.phosphophyllite.energy.IPhosphophylliteEnergyStorage;
import net.roguelogix.phosphophyllite.modular.tile.PhosphophylliteTile;
import net.roguelogix.phosphophyllite.registry.RegisterTileEntity;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@RegisterTileEntity(name="power_white_hole")
public class PowerWhiteHoleTile
extends PhosphophylliteTile
implements IEnergyStorage {
    @RegisterTileEntity.Type
    public static BlockEntityType<?> TYPE;
    @RegisterTileEntity.Supplier
    public static final BlockEntityType.BlockEntitySupplier<PowerWhiteHoleTile> SUPPLIER;
    private final IEnergyStorage[] lastCapability = new IEnergyStorage[6];
    private final IPhosphophylliteEnergyStorage[] wrapped = new IPhosphophylliteEnergyStorage[6];

    public PowerWhiteHoleTile(BlockPos pos, BlockState state) {
        super(TYPE, pos, state);
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> capability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.capability(cap, side);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return 0;
    }

    public int getMaxEnergyStored() {
        return 0;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return false;
    }

    public void tick() {
        assert (this.f_58857_ != null);
        for (Direction direction : Direction.values()) {
            BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_142300_(direction));
            if (te == null) continue;
            te.getCapability(CapabilityEnergy.ENERGY, direction.m_122424_()).ifPresent(c -> {
                int directionIndex = direction.m_122411_();
                if (c != this.lastCapability[directionIndex]) {
                    this.lastCapability[directionIndex] = c;
                    this.wrapped[directionIndex] = EnergyStorageWrapper.wrap(c);
                }
                this.wrapped[directionIndex].insertEnergy(Long.MAX_VALUE, false);
            });
        }
    }

    static {
        SUPPLIER = PowerWhiteHoleTile::new;
    }
}

