/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.roguelogix.phosphophyllite.Phosphophyllite;
import net.roguelogix.phosphophyllite.registry.OnModLoad;
import net.roguelogix.phosphophyllite.robn.ROBN;

public class GuiSync {
    private static final HashMap<Player, IGUIPacketProvider> playerGUIs = new HashMap();
    private static IGUIPacketProvider currentGUI;
    private static final String PROTOCOL_VERSION = "0";
    public static final SimpleChannel INSTANCE;

    public static synchronized void onContainerOpen(@Nonnull PlayerContainerEvent.Open e) {
        AbstractContainerMenu container = e.getContainer();
        if (container instanceof IGUIPacketProvider) {
            playerGUIs.put(e.getPlayer(), (IGUIPacketProvider)container);
        }
    }

    public static synchronized void onContainerClose(@Nonnull PlayerContainerEvent.Close e) {
        playerGUIs.remove(e.getPlayer());
    }

    public static synchronized void GuiOpenEvent(@Nonnull ScreenOpenEvent e) {
        Screen gui = e.getScreen();
        if (gui instanceof AbstractContainerScreen) {
            AbstractContainerMenu container = ((AbstractContainerScreen)gui).m_6262_();
            if (container instanceof IGUIPacketProvider) {
                currentGUI = (IGUIPacketProvider)container;
            }
        } else {
            currentGUI = null;
        }
    }

    @OnModLoad
    public static void onModLoad() {
        INSTANCE.registerMessage(1, GUIPacketMessage.class, GuiSync::encodePacket, GuiSync::decodePacket, GuiSync::handler);
        MinecraftForge.EVENT_BUS.addListener(GuiSync::onContainerClose);
        MinecraftForge.EVENT_BUS.addListener(GuiSync::onContainerOpen);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            MinecraftForge.EVENT_BUS.addListener(GuiSync::GuiOpenEvent);
        }
        Thread updateThread = new Thread(() -> {
            while (true) {
                Class<GuiSync> clazz = GuiSync.class;
                // MONITORENTER : net.roguelogix.phosphophyllite.client.gui.GuiSync.class
                playerGUIs.forEach((player, gui) -> {
                    try {
                        ArrayList<Byte> buf;
                        assert (player instanceof ServerPlayer);
                        IGUIPacket packet = gui.getGuiPacket();
                        if (packet == null) {
                            return;
                        }
                        Map<?, ?> packetMap = packet.write();
                        if (packetMap == null) {
                            return;
                        }
                        try {
                            buf = ROBN.toROBN(packetMap);
                        }
                        catch (IllegalStateException e) {
                            e.printStackTrace();
                            return;
                        }
                        GUIPacketMessage message = new GUIPacketMessage();
                        message.bytes = new byte[buf.size()];
                        for (int i = 0; i < buf.size(); ++i) {
                            message.bytes[i] = buf.get(i);
                        }
                        INSTANCE.sendTo((Object)message, ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                // MONITOREXIT : clazz
                try {
                    Thread.sleep(Phosphophyllite.CONFIG.gui.UpdateIntervalMS);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        });
        updateThread.setName("Phosphophyllite-GuiSync");
        updateThread.setDaemon(true);
        updateThread.start();
    }

    private static void encodePacket(@Nonnull GUIPacketMessage packet, @Nonnull FriendlyByteBuf buf) {
        buf.writeBytes(packet.bytes);
    }

    private static GUIPacketMessage decodePacket(@Nonnull FriendlyByteBuf buf) {
        byte[] byteBuf = new byte[buf.readableBytes()];
        buf.readBytes(byteBuf);
        return new GUIPacketMessage(byteBuf);
    }

    private static void handler(@Nonnull GUIPacketMessage packet, @Nonnull Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            NetworkDirection direction = ((NetworkEvent.Context)ctx.get()).getDirection();
            ArrayList<Byte> buf = new ArrayList<Byte>();
            for (byte aByte : packet.bytes) {
                buf.add(aByte);
            }
            Map map = (Map)ROBN.fromROBN(buf);
            if (direction == NetworkDirection.PLAY_TO_CLIENT) {
                IGUIPacket guiPacket;
                IGUIPacketProvider currentGUI = currentGUI;
                if (currentGUI != null && (guiPacket = currentGUI.getGuiPacket()) != null) {
                    guiPacket.read(map);
                }
            } else {
                IGUIPacketProvider currentGUI = playerGUIs.get(((NetworkEvent.Context)ctx.get()).getSender());
                if (currentGUI != null) {
                    currentGUI.executeRequest((String)map.get("request"), map.get("data"));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    static {
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("phosphophyllite", "multiblock/guisync"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
    }

    public static interface IGUIPacketProvider {
        @Nullable
        public IGUIPacket getGuiPacket();

        default public void runRequest(@Nonnull String requestName, @Nullable Object requestData) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("request", requestName);
            if (requestData != null) {
                map.put("data", requestData);
            }
            ArrayList<Byte> buf = ROBN.toROBN(map);
            GUIPacketMessage message = new GUIPacketMessage();
            message.bytes = new byte[buf.size()];
            for (int i = 0; i < buf.size(); ++i) {
                message.bytes[i] = buf.get(i);
            }
            INSTANCE.sendToServer((Object)message);
        }

        default public void executeRequest(String requestName, Object requestData) {
        }
    }

    private static class GUIPacketMessage {
        public byte[] bytes;

        public GUIPacketMessage() {
        }

        public GUIPacketMessage(@Nonnull byte[] readByteArray) {
            this.bytes = readByteArray;
        }
    }

    public static interface IGUIPacket {
        public void read(@Nonnull Map<?, ?> var1);

        @Nullable
        public Map<?, ?> write();
    }
}

