/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.roguelogix.phosphophyllite.Phosphophyllite;
import net.roguelogix.phosphophyllite.repack.tnjson.ParseException;
import net.roguelogix.phosphophyllite.repack.tnjson.TnJson;

public class DataLoader<T> {
    private final Map<String, DataElement> dataMap = new HashMap<String, DataElement>();
    private final Constructor<T> constructor;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataLoader(@Nonnull Class<T> clazz) {
        try {
            this.constructor = clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("no default constructor");
        }
        this.constructor.setAccessible(true);
        for (Field declaredField : clazz.getDeclaredFields()) {
            void var7_8;
            declaredField.setAccessible(true);
            String name = declaredField.getName();
            Class<?> fieldType = declaredField.getType();
            if (fieldType == Long.TYPE || fieldType == Double.TYPE) {
                NumberDataElement numberElement = new NumberDataElement();
                if (declaredField.isAnnotationPresent(Range.class)) {
                    Range rangeAnnotation = declaredField.getAnnotation(Range.class);
                    String range = rangeAnnotation.value();
                    if ((range = range.trim()).length() < 3) {
                        throw new IllegalArgumentException("Incomplete range given");
                    }
                    char lowerInclusiveChar = range.charAt(0);
                    char higherInclusiveChar = range.charAt(range.length() - 1);
                    boolean lowerInclusive = switch (lowerInclusiveChar) {
                        case '(' -> false;
                        case '[' -> true;
                        default -> throw new IllegalArgumentException("Unknown lower bound inclusivity");
                    };
                    boolean higherInclusive = switch (higherInclusiveChar) {
                        case ')' -> false;
                        case ']' -> true;
                        default -> throw new IllegalArgumentException("Unknown higher bound inclusivity");
                    };
                    range = range.substring(1, range.length() - 1).trim();
                    String[] bounds = range.split(",");
                    if (bounds.length > 2) {
                        throw new IllegalArgumentException("Range cannot have more than two bounds");
                    }
                    String lowerBoundStr = "";
                    String higherBoundStr = "";
                    if (bounds.length == 2) {
                        lowerBoundStr = bounds[0].trim();
                        higherBoundStr = bounds[1].trim();
                    } else {
                        if (range.length() == 0) {
                            throw new IllegalArgumentException("Incomplete range given");
                        }
                        if (range.length() != 1) {
                            if (bounds.length != 1) {
                                throw new IllegalArgumentException("Incomplete range given");
                            }
                            if (range.charAt(0) == ',') {
                                higherBoundStr = bounds[0];
                            } else {
                                if (range.charAt(range.length() - 1) != ',') throw new IllegalArgumentException("Incomplete range given");
                                lowerBoundStr = bounds[0];
                            }
                        } else if (range.charAt(0) != ',') {
                            throw new IllegalArgumentException("Incomplete range given");
                        }
                    }
                    double lowerBound = Double.MIN_VALUE;
                    if (lowerBoundStr.length() != 0) {
                        lowerBound = Double.parseDouble(lowerBoundStr);
                    }
                    double higherBound = Double.MAX_VALUE;
                    if (higherBoundStr.length() != 0) {
                        higherBound = Double.parseDouble(higherBoundStr);
                    }
                    if (lowerBound > higherBound) {
                        throw new IllegalArgumentException("Higher bound must be greater or equal to lower bound");
                    }
                    numberElement.lowerInclusive = lowerInclusive;
                    numberElement.upperInclusive = higherInclusive;
                    numberElement.lowerBound = lowerBound;
                    numberElement.upperBound = higherBound;
                }
                numberElement.type = fieldType == Long.TYPE ? ElementType.LONG : ElementType.Double;
                NumberDataElement numberDataElement = numberElement;
            } else {
                if (fieldType != String.class && fieldType != ResourceLocation.class) throw new IllegalArgumentException("Invalid type used");
                StringDataElement stringElement = new StringDataElement();
                if (declaredField.isAnnotationPresent(Values.class)) {
                    stringElement.allowedValues = declaredField.getAnnotation(Values.class).value();
                }
                stringElement.type = fieldType == ResourceLocation.class ? ElementType.ResourceLocation : ElementType.String;
                StringDataElement stringDataElement = stringElement;
            }
            var7_8.field = declaredField;
            this.dataMap.put(name, (DataElement)var7_8);
        }
    }

    @Nonnull
    public List<T> loadAll(ResourceLocation location) {
        if (Phosphophyllite.dataPackRegistries == null) {
            return new ArrayList();
        }
        ArrayList<T> elements = new ArrayList<T>();
        ResourceManager resourceManager = Phosphophyllite.dataPackRegistries.m_136178_();
        Collection resourceLocations = resourceManager.m_6540_(location.m_135815_(), s -> s.contains(".json"));
        for (ResourceLocation resourceLocation : resourceLocations) {
            T t;
            if (!resourceLocation.m_135827_().equals(location.m_135827_()) || (t = this.load(resourceLocation, resourceManager)) == null) continue;
            elements.add(t);
        }
        return elements;
    }

    @Nullable
    public T load(ResourceLocation location) {
        if (Phosphophyllite.dataPackRegistries == null) {
            return null;
        }
        return this.load(location, Phosphophyllite.dataPackRegistries.m_136178_());
    }

    @Nullable
    private T load(ResourceLocation location, ResourceManager resourceManager) {
        T newT;
        Map<String, Object> map;
        String json;
        try {
            Resource resource = resourceManager.m_142591_(location);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.m_6679_()));){
                String line;
                StringBuilder builder = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                    builder.append("\n");
                }
                json = builder.toString();
            }
        }
        catch (IOException e) {
            Phosphophyllite.LOGGER.error("Error reading json at " + location.toString());
            e.printStackTrace();
            return null;
        }
        try {
            map = TnJson.parse(json);
        }
        catch (ParseException e) {
            Phosphophyllite.LOGGER.error("Error parsing json at " + location.toString());
            e.printStackTrace();
            return null;
        }
        try {
            newT = this.constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            Phosphophyllite.LOGGER.error("Failed to create object instance");
            e.printStackTrace();
            return null;
        }
        for (Map.Entry<String, DataElement> dataElementEntry : this.dataMap.entrySet()) {
            StringDataElement stringDataElement;
            String name = dataElementEntry.getKey();
            DataElement dataElement = dataElementEntry.getValue();
            Object object = map.get(name);
            if (object == null) {
                Phosphophyllite.LOGGER.error("Data member \"" + name + "\" not found in json at " + location.toString());
                return null;
            }
            if (dataElement.type == ElementType.LONG || dataElement.type == ElementType.Double) {
                NumberDataElement numberDataElement = (NumberDataElement)dataElement;
                if (!(object instanceof Number)) {
                    Phosphophyllite.LOGGER.error("Data member \"" + name + "\" required to be a number given as " + object.getClass().getSimpleName() + " in json at " + location.toString());
                    return null;
                }
                double val = ((Number)object).doubleValue();
                if (dataElement.type == ElementType.LONG) {
                    long realVal = Math.round(val);
                    if ((double)realVal < numberDataElement.lowerBound || (double)realVal > numberDataElement.upperBound || (double)realVal <= numberDataElement.lowerBound && !numberDataElement.lowerInclusive || (double)realVal >= numberDataElement.upperBound && !numberDataElement.upperInclusive) {
                        Phosphophyllite.LOGGER.error("Data member \"" + name + "\" given out of range value " + val + " in json at " + location.toString() + ". Valid range is " + (String)(numberDataElement.lowerInclusive ? "[" : "(" + (Serializable)(numberDataElement.lowerBound == Double.MIN_VALUE ? "" : Double.valueOf(numberDataElement.lowerBound))) + "," + (Serializable)(numberDataElement.upperBound == Double.MAX_VALUE ? "" : Double.valueOf(numberDataElement.upperBound)) + (numberDataElement.upperInclusive ? "]" : ")") + ". Clamping to range");
                        if ((double)realVal <= numberDataElement.lowerBound) {
                            realVal = Math.round(numberDataElement.lowerBound);
                            if (!numberDataElement.lowerInclusive) {
                                ++realVal;
                            }
                        } else if ((double)realVal >= numberDataElement.upperBound) {
                            realVal = Math.round(numberDataElement.upperBound);
                            if (!numberDataElement.upperInclusive) {
                                --realVal;
                            }
                        }
                    }
                    try {
                        dataElement.field.setLong(newT, realVal);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        Phosphophyllite.LOGGER.error("Illegal access while setting field");
                        e.printStackTrace();
                        return null;
                    }
                }
                if (val < numberDataElement.lowerBound || val > numberDataElement.upperBound || val <= numberDataElement.lowerBound && !numberDataElement.lowerInclusive || val >= numberDataElement.upperBound && !numberDataElement.upperInclusive) {
                    Phosphophyllite.LOGGER.error("Data member \"" + name + "\" given out of range value " + val + " in json at " + location.toString() + ". Valid range is " + (String)(numberDataElement.lowerInclusive ? "[" : "(" + (Serializable)(numberDataElement.lowerBound == Double.MIN_VALUE ? "" : Double.valueOf(numberDataElement.lowerBound))) + "," + (Serializable)(numberDataElement.upperBound == Double.MAX_VALUE ? "" : Double.valueOf(numberDataElement.upperBound)) + (numberDataElement.upperInclusive ? "]" : ")") + ". Clamping to range");
                    if (val <= numberDataElement.lowerBound) {
                        val = numberDataElement.lowerBound;
                        if (!numberDataElement.lowerInclusive) {
                            val = Math.nextAfter(val, Double.POSITIVE_INFINITY);
                        }
                    } else if (val >= numberDataElement.upperBound) {
                        val = numberDataElement.upperBound;
                        if (!numberDataElement.upperInclusive) {
                            val = Math.nextAfter(val, Double.NEGATIVE_INFINITY);
                        }
                    }
                }
                try {
                    dataElement.field.setDouble(newT, val);
                    continue;
                }
                catch (IllegalAccessException e) {
                    Phosphophyllite.LOGGER.error("Illegal access while setting field");
                    e.printStackTrace();
                    return null;
                }
            }
            if (dataElement.type == ElementType.String) {
                stringDataElement = (StringDataElement)dataElement;
                if (!(object instanceof String)) {
                    Phosphophyllite.LOGGER.error("Data member \"" + name + "\" required to be a string given as " + object.getClass().getSimpleName() + " in json at " + location.toString());
                    return null;
                }
                String data = (String)object;
                try {
                    stringDataElement.field.set(newT, data);
                }
                catch (IllegalAccessException e) {
                    Phosphophyllite.LOGGER.error("Illegal access while setting field");
                    e.printStackTrace();
                    return null;
                }
                if (stringDataElement.allowedValues == null) continue;
                boolean allowed = false;
                for (String allowedValue : stringDataElement.allowedValues) {
                    if (!data.equals(allowedValue)) continue;
                    allowed = true;
                    break;
                }
                if (allowed) continue;
                Phosphophyllite.LOGGER.error("Invalid value for member \"" + name + "\" given in json at " + location.toString());
                return null;
            }
            if (dataElement.type == ElementType.ResourceLocation) {
                stringDataElement = (StringDataElement)dataElement;
                if (!(object instanceof String)) {
                    Phosphophyllite.LOGGER.error("Data member \"" + name + "\" required to be a resource location string given as " + object.getClass().getSimpleName() + " in json at " + location.toString());
                    return null;
                }
                String data = (String)object;
                try {
                    stringDataElement.field.set(newT, new ResourceLocation(data));
                    continue;
                }
                catch (ResourceLocationException e) {
                    Phosphophyllite.LOGGER.error("Invalid resource location given for \"" + name + "\" in json at " + location.toString());
                    Phosphophyllite.LOGGER.error(e.getMessage());
                    return null;
                }
                catch (IllegalAccessException e) {
                    Phosphophyllite.LOGGER.error("Illegal access while setting field");
                    e.printStackTrace();
                    return null;
                }
            }
            Phosphophyllite.LOGGER.error("Unknown data element type");
            return null;
        }
        return newT;
    }

    private static class NumberDataElement
    extends DataElement {
        double lowerBound = Double.MIN_VALUE;
        boolean lowerInclusive = true;
        double upperBound = Double.MAX_VALUE;
        boolean upperInclusive = true;

        private NumberDataElement() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Range {
        public String value();
    }

    private static enum ElementType {
        String,
        ResourceLocation,
        LONG,
        Double;

    }

    private static class StringDataElement
    extends DataElement {
        String[] allowedValues;

        private StringDataElement() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Values {
        public String[] value();
    }

    private static class DataElement {
        Field field;
        ElementType type;

        private DataElement() {
        }
    }
}

