/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.fluids;

import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IRegistryDelegate;

public class PhosphophylliteFluidStack
extends FluidStack {
    private static final Field delegateField;
    Fluid fluid;
    IRegistryDelegate<Fluid> delegateWrapper = new IRegistryDelegate<Fluid>(){

        public Fluid get() {
            return PhosphophylliteFluidStack.this.fluid;
        }

        public ResourceLocation name() {
            return PhosphophylliteFluidStack.this.fluid.delegate.name();
        }

        public Class<Fluid> type() {
            return PhosphophylliteFluidStack.this.fluid.delegate.type();
        }
    };
    private long amount = 0L;
    private CompoundTag tag;

    private void setDelegate(IRegistryDelegate<Fluid> delegate) {
        try {
            delegateField.set((Object)this, delegate);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    public PhosphophylliteFluidStack() {
        super((Fluid)Fluids.f_76193_, 0);
        this.setDelegate(this.delegateWrapper);
        this.setFluid(Fluids.f_76191_);
    }

    public PhosphophylliteFluidStack(Fluid fluid, int amount) {
        super((Fluid)Fluids.f_76193_, 0);
        this.setDelegate(this.delegateWrapper);
        this.setFluid(fluid);
        this.setAmount(amount);
    }

    public PhosphophylliteFluidStack(Fluid fluid, int amount, CompoundTag nbt) {
        super((Fluid)Fluids.f_76193_, 0, nbt);
        this.setDelegate(this.delegateWrapper);
        this.setFluid(fluid);
        this.setAmount(amount);
    }

    public PhosphophylliteFluidStack(Fluid fluid, long amount, CompoundTag nbt) {
        super((Fluid)Fluids.f_76193_, 0, nbt);
        this.setDelegate(this.delegateWrapper);
        this.setFluid(fluid);
        this.setAmount(amount);
    }

    public PhosphophylliteFluidStack(FluidStack stack, int amount) {
        this(stack, (long)amount);
    }

    public PhosphophylliteFluidStack(FluidStack stack, long amount) {
        super((Fluid)Fluids.f_76193_, 0, stack.getTag());
        this.setDelegate(this.delegateWrapper);
        this.setFluid(stack.getRawFluid());
        this.setAmount(amount);
    }

    public PhosphophylliteFluidStack(PhosphophylliteFluidStack stack) {
        this((FluidStack)stack, stack.getLongAmount());
    }

    public PhosphophylliteFluidStack(FluidStack stack) {
        this(stack, stack instanceof PhosphophylliteFluidStack ? ((PhosphophylliteFluidStack)stack).getLongAmount() : (long)stack.getAmount());
    }

    public void setFluid(Fluid fluid) {
        this.fluid = fluid;
    }

    public static FluidStack loadFromNBT(CompoundTag nbt) {
        if (nbt == null) {
            return EMPTY;
        }
        if (!nbt.m_128425_("FluidName", 8)) {
            return EMPTY;
        }
        ResourceLocation fluidName = new ResourceLocation(nbt.m_128461_("FluidName"));
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidName);
        if (fluid == null) {
            return EMPTY;
        }
        PhosphophylliteFluidStack stack = new PhosphophylliteFluidStack(fluid, nbt.m_128451_("Amount"));
        if (nbt.m_128441_("LongAmount")) {
            stack.amount = nbt.m_128454_("LongAmount");
        }
        if (nbt.m_128425_("Tag", 8)) {
            stack.setTag(nbt.m_128469_("Tag"));
        }
        return stack;
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.m_128359_("FluidName", this.getFluid().getRegistryName().toString());
        nbt.m_128405_("Amount", (int)Math.min(this.amount, Integer.MAX_VALUE));
        nbt.m_128356_("LongAmount", this.amount);
        if (this.getTag() != null) {
            nbt.m_128365_("Tag", (Tag)this.getTag());
        }
        return nbt;
    }

    public void writeToPacket(FriendlyByteBuf buf) {
        buf.writeRegistryId((IForgeRegistryEntry)this.getFluid());
        buf.m_130130_(this.getAmount());
        buf.m_130079_(this.getTag());
    }

    public void writeToLongPacket(FriendlyByteBuf buf) {
        buf.writeRegistryId((IForgeRegistryEntry)this.getFluid());
        buf.m_130103_((long)this.getAmount());
        buf.m_130079_(this.getTag());
    }

    public static FluidStack readFromPacket(FriendlyByteBuf buf) {
        Fluid fluid = (Fluid)buf.readRegistryId();
        long amount = buf.m_130258_();
        CompoundTag tag = buf.m_130260_();
        if (fluid == Fluids.f_76191_) {
            return EMPTY;
        }
        return new PhosphophylliteFluidStack(fluid, amount, tag);
    }

    public boolean isEmpty() {
        return this.amount == 0L;
    }

    public int getAmount() {
        return (int)Math.min(this.amount, Integer.MAX_VALUE);
    }

    public long getLongAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.setAmount((long)amount);
    }

    public void setAmount(long amount) {
        this.amount = amount;
        super.setAmount((int)amount);
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    public CompoundTag getTag() {
        return this.tag;
    }

    public void setTag(CompoundTag tag) {
        this.tag = tag;
    }

    public CompoundTag getOrCreateTag() {
        if (this.tag == null) {
            this.setTag(new CompoundTag());
        }
        return this.tag;
    }

    public CompoundTag getChildTag(String childName) {
        if (this.tag == null) {
            return null;
        }
        return this.tag.m_128469_(childName);
    }

    public CompoundTag getOrCreateChildTag(String childName) {
        this.getOrCreateTag();
        CompoundTag child = this.tag.m_128469_(childName);
        if (!this.tag.m_128425_(childName, 8)) {
            this.tag.m_128365_(childName, (Tag)child);
        }
        return child;
    }

    public void removeChildTag(String childName) {
        if (this.tag != null) {
            this.tag.m_128473_(childName);
        }
    }

    public void grow(int amount) {
        this.setAmount(this.amount + (long)amount);
    }

    public void grow(long amount) {
        this.setAmount(this.amount + amount);
    }

    public void shrink(int amount) {
        this.setAmount(this.amount - (long)amount);
    }

    public void shrink(long amount) {
        this.setAmount(this.amount - amount);
    }

    public boolean isFluidStackIdentical(FluidStack other) {
        if (other instanceof PhosphophylliteFluidStack) {
            return this.isFluidEqual(other) && this.amount == ((PhosphophylliteFluidStack)other).getLongAmount();
        }
        return this.isFluidEqual(other) && this.amount == (long)other.getAmount();
    }

    public boolean containsFluid(@Nonnull FluidStack other) {
        if (other instanceof PhosphophylliteFluidStack) {
            return this.isFluidEqual(other) && this.amount >= ((PhosphophylliteFluidStack)other).getLongAmount();
        }
        return this.isFluidEqual(other) && this.amount >= (long)other.getAmount();
    }

    public FluidStack copy() {
        return new PhosphophylliteFluidStack(this);
    }

    static {
        try {
            delegateField = FluidStack.class.getDeclaredField("fluidDelegate");
            delegateField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }
}

