/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.modular.block;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.phys.BlockHitResult;
import net.roguelogix.phosphophyllite.modular.api.BlockModule;
import net.roguelogix.phosphophyllite.modular.api.IModularBlock;
import net.roguelogix.phosphophyllite.modular.api.ModuleRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PhosphophylliteBlock
extends Block
implements IModularBlock {
    public static final Logger LOGGER = LogManager.getLogger((String)"Phosphophyllite/ModularBlock");
    private Int2ObjectMap<BlockModule<?>> modules;
    private List<BlockModule<?>> moduleList;

    private void buildModules() {
        if (this.modules != null) {
            return;
        }
        Int2ObjectOpenHashMap modules = new Int2ObjectOpenHashMap();
        ArrayList moduleList = new ArrayList();
        Class<?> thisClazz = this.getClass();
        ModuleRegistry.forEachBlockModule((arg_0, arg_1) -> this.lambda$buildModules$0(thisClazz, (Int2ObjectMap)modules, moduleList, arg_0, arg_1));
        this.modules = modules;
        this.moduleList = Collections.unmodifiableList(moduleList);
    }

    @Override
    public BlockModule<?> module(Class<? extends IModularBlock> interfaceClazz) {
        return (BlockModule)this.modules.get(interfaceClazz.hashCode());
    }

    @Override
    public List<BlockModule<?>> modules() {
        return this.moduleList;
    }

    public PhosphophylliteBlock(BlockBehaviour.Properties properties) {
        super(properties);
        BlockState state = this.buildDefaultState(this.m_49966_());
        for (BlockModule<?> module : this.moduleList) {
            state = module.buildDefaultState(state);
        }
        this.m_49959_(state);
    }

    protected BlockState buildDefaultState(BlockState state) {
        return state;
    }

    protected final void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        this.buildModules();
        this.buildStateDefinition(builder);
        for (BlockModule<?> module : this.moduleList) {
            module.buildStateDefinition(builder);
        }
    }

    protected void buildStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
    }

    public final void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.onNeighborChange(state, worldIn, pos, blockIn, fromPos, isMoving);
        for (BlockModule<?> module : this.moduleList) {
            module.onNeighborChange(state, worldIn, pos, blockIn, fromPos, isMoving);
        }
    }

    public void onNeighborChange(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
    }

    public final void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.onPlaced(level, pos, state, placer, stack);
        for (BlockModule<?> module : this.moduleList) {
            module.onPlaced(level, pos, state, placer, stack);
        }
    }

    public void onPlaced(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
    }

    public final InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        InteractionResult result = this.onUse(state, level, pos, player, hand, hitResult);
        for (BlockModule<?> module : this.moduleList) {
            InteractionResult moduleResult = module.onUse(state, level, pos, player, hand, hitResult);
            if (result == InteractionResult.PASS) {
                result = moduleResult;
                continue;
            }
            if (moduleResult == InteractionResult.PASS) continue;
            LOGGER.warn("Multiple modules using same onUse for block type \"" + this.getClass().getSimpleName() + "\" at " + pos);
        }
        return result;
    }

    public InteractionResult onUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return InteractionResult.PASS;
    }

    private /* synthetic */ void lambda$buildModules$0(Class thisClazz, Int2ObjectMap modules, List moduleList, Class clazz, Function constructor) {
        if (clazz.isAssignableFrom(thisClazz)) {
            BlockModule module = (BlockModule)constructor.apply(this);
            modules.put(clazz.hashCode(), (Object)module);
            moduleList.add(module);
        }
    }
}

