/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.phosphophyllite.serialization;

import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.roguelogix.phosphophyllite.robn.ROBNObject;
import net.roguelogix.phosphophyllite.util.MethodsReturnNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PhosphophylliteCompound
implements ROBNObject {
    private final Map<String, Object> data = new Object2ObjectOpenHashMap();

    public PhosphophylliteCompound() {
    }

    public PhosphophylliteCompound(byte[] ROBNbuffer) {
        this((List<Byte>)ByteArrayList.wrap((byte[])ROBNbuffer));
    }

    public PhosphophylliteCompound(List<Byte> ROBNbuffer) {
        if (ROBNbuffer.isEmpty()) {
            return;
        }
        this.fromROBN(ROBNbuffer);
    }

    public void put(String key, @Nullable PhosphophylliteCompound compound) {
        if (compound == null) {
            return;
        }
        this.data.put(key, compound);
    }

    public void put(String key, @Nullable String value) {
        if (value == null) {
            return;
        }
        this.data.put(key, value);
    }

    public void put(String key, boolean value) {
        this.data.put(key, value);
    }

    public void put(String key, byte value) {
        this.data.put(key, value);
    }

    public void put(String key, short value) {
        this.data.put(key, value);
    }

    public void put(String key, int value) {
        this.data.put(key, value);
    }

    public void put(String key, long value) {
        this.data.put(key, value);
    }

    public void put(String key, float value) {
        this.data.put(key, Float.valueOf(value));
    }

    public void put(String key, double value) {
        this.data.put(key, value);
    }

    public void put(String key, List<?> value) {
        this.data.put(key, value);
    }

    public void put(String key, Map<?, ?> value) {
        this.data.put(key, value);
    }

    public Object get(String key) {
        return this.data.get(key);
    }

    public PhosphophylliteCompound getCompound(String key) {
        Object val = this.data.get(key);
        if (!(val instanceof PhosphophylliteCompound)) {
            if (val instanceof Map) {
                PhosphophylliteCompound compound = new PhosphophylliteCompound();
                compound.fromROBNMap((Map)val);
                this.data.put(key, compound);
                return compound;
            }
            return new PhosphophylliteCompound();
        }
        return (PhosphophylliteCompound)val;
    }

    public String getString(String key) {
        Object val = this.data.get(key);
        if (!(val instanceof String)) {
            return "";
        }
        return (String)val;
    }

    public boolean getBoolean(String key) {
        Object val = this.data.get(key);
        if (val instanceof Boolean) {
            Boolean bool = (Boolean)val;
            return bool;
        }
        if (val instanceof Number) {
            Number number = (Number)val;
            return number.longValue() != 0L;
        }
        return false;
    }

    public byte getByte(String key) {
        Object val = this.data.get(key);
        if (!(val instanceof Number)) {
            return 0;
        }
        return ((Number)val).byteValue();
    }

    public short getShort(String key) {
        Object val = this.data.get(key);
        if (!(val instanceof Number)) {
            return 0;
        }
        return ((Number)val).shortValue();
    }

    public int getInt(String key) {
        Object val = this.data.get(key);
        if (!(val instanceof Number)) {
            return 0;
        }
        return ((Number)val).intValue();
    }

    public long getLong(String key) {
        Object val = this.data.get(key);
        if (!(val instanceof Number)) {
            return 0L;
        }
        return ((Number)val).longValue();
    }

    public float getFloat(String key) {
        Object val = this.data.get(key);
        if (!(val instanceof Number)) {
            return 0.0f;
        }
        return ((Number)val).floatValue();
    }

    public double getDouble(String key) {
        Object val = this.data.get(key);
        if (!(val instanceof Number)) {
            return 0.0;
        }
        return ((Number)val).doubleValue();
    }

    public List<?> getList(String key) {
        Object obj = this.data.get(key);
        if (obj instanceof List) {
            List list = (List)obj;
            return list;
        }
        return new ArrayList();
    }

    public Map<?, ?> getMap(String key) {
        Object obj = this.data.get(key);
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return map;
        }
        return new HashMap();
    }

    @Override
    public Map<String, Object> toROBNMap() {
        return this.data;
    }

    @Override
    public void fromROBNMap(Map<String, Object> map) {
        this.data.clear();
        this.data.putAll(map);
    }

    public void combine(PhosphophylliteCompound other) {
        other.data.forEach((str, obj) -> {
            if (obj == null) {
                this.data.remove(str);
                return;
            }
            this.data.put((String)str, obj);
        });
    }
}

