/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api;

import com.hollingsworth.arsnouveau.api.enchanting_apparatus.IEnchantingRecipe;
import com.hollingsworth.arsnouveau.api.familiar.AbstractFamiliarHolder;
import com.hollingsworth.arsnouveau.api.recipe.PotionIngredient;
import com.hollingsworth.arsnouveau.api.recipe.VanillaPotionRecipe;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.api.ritual.IScryer;
import com.hollingsworth.arsnouveau.api.ritual.RitualContext;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellValidator;
import com.hollingsworth.arsnouveau.common.block.tile.RitualBrazierTile;
import com.hollingsworth.arsnouveau.common.items.FamiliarScript;
import com.hollingsworth.arsnouveau.common.items.Glyph;
import com.hollingsworth.arsnouveau.common.items.RitualTablet;
import com.hollingsworth.arsnouveau.common.spell.validation.StandardSpellValidator;
import com.hollingsworth.arsnouveau.setup.Config;
import com.hollingsworth.arsnouveau.setup.ItemsRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;

public class ArsNouveauAPI {
    private HashMap<String, AbstractSpellPart> spellpartMap = new HashMap();
    private HashMap<String, AbstractRitual> ritualMap = new HashMap();
    private HashMap<String, AbstractFamiliarHolder> familiarHolderMap = new HashMap();
    private HashMap<String, Glyph> glyphItemMap = new HashMap();
    private HashMap<String, FamiliarScript> familiarScriptMap = new HashMap();
    private HashMap<String, RitualTablet> ritualParchmentMap = new HashMap();
    private HashMap<String, IScryer> scryerMap = new HashMap();
    private ISpellValidator craftingSpellValidator;
    private ISpellValidator castingSpellValidator;
    private List<IEnchantingRecipe> enchantingApparatusRecipes = new ArrayList<IEnchantingRecipe>();
    public List<VanillaPotionRecipe> vanillaPotionRecipes = new ArrayList<VanillaPotionRecipe>();
    private List<BrewingRecipe> brewingRecipes = new ArrayList<BrewingRecipe>();
    private List<AbstractSpellPart> startingSpells = new ArrayList<AbstractSpellPart>();
    private static final ArsNouveauAPI ARS_NOUVEAU_API = new ArsNouveauAPI();

    public List<AbstractSpellPart> getDefaultStartingSpells() {
        return this.spellpartMap.values().stream().filter(Config::isStarterEnabled).collect(Collectors.toList());
    }

    public boolean addStartingSpell(String tag) {
        if (ArsNouveauAPI.getInstance().getSpellpartMap().containsKey(tag)) {
            return this.startingSpells.add(ArsNouveauAPI.getInstance().getSpellpartMap().get(tag));
        }
        throw new IllegalStateException("Attempted to add a starting spell for an unregistered spell. Spells must be added to the Spell Map first!");
    }

    public Item getGlyphItem(String glyphName) {
        for (Item i : ItemsRegistry.RegistrationHandler.ITEMS) {
            if (!i.getRegistryName().equals((Object)new ResourceLocation("ars_nouveau", this.getSpellRegistryName(glyphName)))) continue;
            return i;
        }
        return null;
    }

    public Item getGlyphItem(AbstractSpellPart spell) {
        return this.getGlyphItem(spell.getId());
    }

    public Item getFamiliarItem(String id) {
        return this.familiarScriptMap.get(id);
    }

    public AbstractSpellPart registerSpell(String id, AbstractSpellPart part) {
        this.glyphItemMap.put(id, new Glyph(this.getSpellRegistryName(id), part));
        return this.spellpartMap.put(id, part);
    }

    public AbstractSpellPart registerSpell(AbstractSpellPart part) {
        return this.registerSpell(part.getId(), part);
    }

    public AbstractSpellPart registerSpell(String id, AbstractSpellPart part, int manaCost) {
        Config.addonSpellCosts.put(id, manaCost);
        return this.registerSpell(id, part);
    }

    public AbstractRitual registerRitual(String id, AbstractRitual ritual) {
        this.ritualParchmentMap.put(id, new RitualTablet(this.getRitualRegistryName(id), ritual));
        return this.ritualMap.put(id, ritual);
    }

    public AbstractFamiliarHolder registerFamiliar(AbstractFamiliarHolder familiar) {
        this.familiarScriptMap.put(familiar.id, new FamiliarScript(familiar));
        return this.familiarHolderMap.put(familiar.id, familiar);
    }

    @Nullable
    public AbstractRitual getRitual(String id) {
        if (!this.ritualMap.containsKey(id)) {
            return null;
        }
        try {
            return (AbstractRitual)this.ritualMap.get(id).getClass().newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public AbstractRitual getRitual(String id, RitualBrazierTile tile, RitualContext context) {
        AbstractRitual ritual = this.getRitual(id);
        if (ritual != null) {
            ritual.tile = tile;
            ritual.setContext(context);
        }
        return ritual;
    }

    public String getSpellRegistryName(String id) {
        return "glyph_" + id.toLowerCase();
    }

    public String getRitualRegistryName(String id) {
        return "ritual_" + id.toLowerCase();
    }

    public Map<String, AbstractSpellPart> getSpellpartMap() {
        return this.spellpartMap;
    }

    public Map<String, Glyph> getGlyphItemMap() {
        return this.glyphItemMap;
    }

    public Map<String, AbstractRitual> getRitualMap() {
        return this.ritualMap;
    }

    public Map<String, RitualTablet> getRitualItemMap() {
        return this.ritualParchmentMap;
    }

    public List<IEnchantingRecipe> getEnchantingApparatusRecipes() {
        return this.enchantingApparatusRecipes;
    }

    public Map<String, AbstractFamiliarHolder> getFamiliarHolderMap() {
        return this.familiarHolderMap;
    }

    public Map<String, FamiliarScript> getFamiliarScriptMap() {
        return this.familiarScriptMap;
    }

    public List<IEnchantingRecipe> getEnchantingApparatusRecipes(Level world) {
        ArrayList<IEnchantingRecipe> recipes = new ArrayList<IEnchantingRecipe>(this.enchantingApparatusRecipes);
        RecipeManager manager = world.m_7465_();
        for (Recipe i : manager.m_44051_()) {
            if (!(i instanceof IEnchantingRecipe)) continue;
            recipes.add((IEnchantingRecipe)i);
        }
        return recipes;
    }

    public List<BrewingRecipe> getAllPotionRecipes() {
        if (this.brewingRecipes.isEmpty()) {
            BrewingRecipeRegistry.getRecipes().forEach(ib -> {
                if (ib instanceof BrewingRecipe) {
                    this.brewingRecipes.add((BrewingRecipe)ib);
                }
            });
            this.vanillaPotionRecipes.forEach(vanillaPotionRecipe -> {
                BrewingRecipe recipe = new BrewingRecipe((Ingredient)PotionIngredient.fromPotion(vanillaPotionRecipe.potionIn), Ingredient.m_43929_((ItemLike[])new ItemLike[]{vanillaPotionRecipe.reagent}), PotionIngredient.fromPotion(vanillaPotionRecipe.potionOut).getStack());
                this.brewingRecipes.add(recipe);
            });
        }
        return this.brewingRecipes;
    }

    public ISpellValidator getSpellCraftingSpellValidator() {
        if (this.craftingSpellValidator == null) {
            this.craftingSpellValidator = new StandardSpellValidator(false);
        }
        return this.craftingSpellValidator;
    }

    public ISpellValidator getSpellCastingSpellValidator() {
        if (this.castingSpellValidator == null) {
            this.castingSpellValidator = new StandardSpellValidator(true);
        }
        return this.castingSpellValidator;
    }

    @Nullable
    public IScryer getScryer(String id) {
        return this.scryerMap.get(id);
    }

    public boolean registerScryer(IScryer scryer) {
        this.scryerMap.put(scryer.getID(), scryer);
        return true;
    }

    private ArsNouveauAPI() {
    }

    public static ArsNouveauAPI getInstance() {
        return ARS_NOUVEAU_API;
    }
}

