/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.item;

import com.hollingsworth.arsnouveau.api.client.IDisplayMana;
import com.hollingsworth.arsnouveau.api.item.IScribeable;
import com.hollingsworth.arsnouveau.api.item.ISpellHotkeyListener;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellCaster;
import com.hollingsworth.arsnouveau.api.util.CasterUtil;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.items.SpellParchment;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public interface ICasterTool
extends IScribeable,
IDisplayMana,
ISpellHotkeyListener {
    @Override
    default public boolean onScribe(Level world, BlockPos pos, Player player, InteractionHand handIn, ItemStack stack) {
        ItemStack heldStack = player.m_21120_(handIn);
        ISpellCaster thisCaster = CasterUtil.getCaster(stack);
        if (!(heldStack.m_41720_() instanceof SpellBook) && !(heldStack.m_41720_() instanceof SpellParchment)) {
            return false;
        }
        Spell spell = new Spell();
        if (heldStack.m_41720_() instanceof ICasterTool) {
            ISpellCaster heldCaster = CasterUtil.getCaster(heldStack);
            spell = heldCaster.getSpell();
            thisCaster.setColor(heldCaster.getColor());
            thisCaster.setFlavorText(heldCaster.getFlavorText());
        }
        if (this.isScribedSpellValid(thisCaster, player, handIn, stack, spell)) {
            boolean success = this.setSpell(thisCaster, player, handIn, stack, spell);
            if (success) {
                this.sendSetMessage(player);
                return true;
            }
        } else {
            this.sendInvalidMessage(player);
        }
        return false;
    }

    default public void sendSetMessage(Player player) {
        PortUtil.sendMessageNoSpam((Entity)player, (Component)new TranslatableComponent("ars_nouveau.set_spell"));
    }

    default public void sendInvalidMessage(Player player) {
        PortUtil.sendMessageNoSpam((Entity)player, (Component)new TranslatableComponent("ars_nouveau.invalid_spell"));
    }

    @Nonnull
    default public ISpellCaster getSpellCaster(ItemStack stack) {
        return new SpellCaster(stack);
    }

    default public boolean setSpell(ISpellCaster caster, Player player, InteractionHand hand, ItemStack stack, Spell spell) {
        caster.setSpell(spell);
        return true;
    }

    default public boolean isScribedSpellValid(ISpellCaster caster, Player player, InteractionHand hand, ItemStack stack, Spell spell) {
        return spell.isValid();
    }

    @Override
    default public boolean shouldDisplay(ItemStack stack) {
        return true;
    }

    default public void getInformation(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip2, TooltipFlag flagIn) {
        if (worldIn == null) {
            return;
        }
        ISpellCaster caster = this.getSpellCaster(stack);
        if (caster.getSpell().isEmpty()) {
            tooltip2.add((Component)new TranslatableComponent("ars_nouveau.tooltip.can_inscribe"));
            return;
        }
        Spell spell = caster.getSpell();
        tooltip2.add((Component)new TextComponent(spell.getDisplayString()));
        if (!caster.getFlavorText().isEmpty()) {
            tooltip2.add((Component)new TextComponent(caster.getFlavorText()).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_131140_(ChatFormatting.BLUE)));
        }
    }
}

