/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.ritual;

import com.hollingsworth.arsnouveau.api.ritual.RitualContext;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.tile.RitualBrazierTile;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class AbstractRitual {
    public RitualBrazierTile tile;
    private RitualContext context;
    public Random rand = new Random();

    public AbstractRitual() {
    }

    public AbstractRitual(RitualBrazierTile tile, RitualContext context) {
        this.tile = tile;
        this.setContext(context);
    }

    public void tryTick() {
        if (this.tile == null || !this.getContext().isStarted || this.getContext().isDone) {
            return;
        }
        this.tick();
    }

    @Nullable
    public BlockPos getPos() {
        return this.tile != null ? this.tile.m_58899_() : null;
    }

    @Nullable
    public Level getWorld() {
        return this.tile != null ? this.tile.m_58904_() : null;
    }

    public boolean canStart() {
        return true;
    }

    public List<ItemStack> getConsumedItems() {
        return this.getContext().consumedItems;
    }

    public boolean canConsumeItem(ItemStack stack) {
        return false;
    }

    public void onItemConsumed(ItemStack stack) {
        this.getConsumedItems().add(stack.m_41777_());
        stack.m_41774_(1);
        BlockUtil.safelyUpdateState(this.getWorld(), this.tile.m_58899_());
    }

    public boolean didConsumeItem(Item item) {
        for (ItemStack i : this.getConsumedItems()) {
            if (i.m_41720_() != item) continue;
            return true;
        }
        return false;
    }

    public void incrementProgress() {
        ++this.getContext().progress;
    }

    public int getProgress() {
        return this.getContext().progress;
    }

    public void onStart() {
        this.getContext().isStarted = true;
    }

    public boolean isRunning() {
        return this.getContext().isStarted && !this.getContext().isDone;
    }

    public boolean isDone() {
        return this.getContext().isDone;
    }

    public void setFinished() {
        this.getContext().isDone = true;
    }

    protected abstract void tick();

    public void onEnd() {
        this.getContext().isDone = true;
    }

    public abstract String getID();

    public String getName() {
        return new TranslatableComponent("item.ars_nouveau.ritual_" + this.getID()).getString();
    }

    public String getDescription() {
        return new TranslatableComponent("ars_nouveau.ritual_desc." + this.getID()).getString();
    }

    public int getManaCost() {
        return 0;
    }

    public boolean consumesMana() {
        return this.getManaCost() > 0;
    }

    public void setNeedsMana(boolean needMana) {
        this.getContext().needsManaToRun = needMana;
        BlockUtil.safelyUpdateState(this.getWorld(), this.tile.m_58899_());
    }

    public boolean needsManaNow() {
        return this.getContext().needsManaToRun;
    }

    public void write(CompoundTag tag) {
        CompoundTag contextTag = new CompoundTag();
        this.getContext().write(contextTag);
        tag.m_128365_("context", (Tag)contextTag);
    }

    public void read(CompoundTag tag) {
        this.setContext(RitualContext.read(tag.m_128469_("context")));
    }

    @Nonnull
    public RitualContext getContext() {
        if (this.context == null) {
            this.context = new RitualContext();
        }
        return this.context;
    }

    public void setContext(RitualContext context) {
        this.context = context;
    }

    public ParticleColor getCenterColor() {
        return new ParticleColor(this.rand.nextInt(255), this.rand.nextInt(22), this.rand.nextInt(255));
    }

    public ParticleColor getOuterColor() {
        return this.getCenterColor();
    }

    public int getParticleIntensity() {
        return 50;
    }

    public String getLangName() {
        return "";
    }

    public String getLangDescription() {
        return "";
    }
}

