/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.spell;

import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.event.SpellCastEvent;
import com.hollingsworth.arsnouveau.api.event.SpellResolveEvent;
import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellValidator;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.api.util.ManaUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.capability.CapabilityRegistry;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class SpellResolver {
    public AbstractCastMethod castType;
    public Spell spell;
    public final SpellContext spellContext;
    public boolean silent;
    private final ISpellValidator spellValidator;

    public SpellResolver(SpellContext spellContext) {
        this.spell = spellContext.getSpell();
        this.castType = spellContext.getSpell().getCastMethod();
        this.spellContext = spellContext;
        this.spellValidator = ArsNouveauAPI.getInstance().getSpellCastingSpellValidator();
    }

    public SpellResolver withSilent(boolean isSilent) {
        this.silent = isSilent;
        return this;
    }

    public boolean canCast(LivingEntity entity) {
        List<SpellValidationError> validationErrors = this.spellValidator.validate(this.spell.recipe);
        if (validationErrors.isEmpty()) {
            return this.enoughMana(entity);
        }
        if (!this.silent && !entity.m_20193_().f_46443_) {
            PortUtil.sendMessageNoSpam((Entity)entity, (Component)validationErrors.get(0).makeTextComponentExisting());
        }
        return false;
    }

    boolean enoughMana(LivingEntity entity) {
        boolean canCast;
        int totalCost = this.getCastingCost(this.spell, entity);
        IManaCap manaCap = (IManaCap)CapabilityRegistry.getMana(entity).orElse(null);
        if (manaCap == null) {
            return false;
        }
        boolean bl = canCast = (double)totalCost <= manaCap.getCurrentMana() || entity instanceof Player && ((Player)entity).m_7500_();
        if (!(canCast || entity.m_20193_().f_46443_ || this.silent)) {
            PortUtil.sendMessageNoSpam((Entity)entity, (Component)new TranslatableComponent("ars_nouveau.spell.no_mana"));
        }
        return canCast;
    }

    public boolean postEvent(LivingEntity entity) {
        return SpellUtil.postEvent(new SpellCastEvent(entity, this.spell, this.spellContext));
    }

    public void onCast(ItemStack stack, LivingEntity livingEntity, Level world) {
        if (this.canCast(livingEntity) && !this.postEvent(livingEntity)) {
            SpellStats stats = new SpellStats.Builder().setAugments(this.spell.getAugments(0, livingEntity)).addItemsFromEntity(livingEntity).build(this.castType, null, world, livingEntity, this.spellContext);
            this.castType.onCast(stack, livingEntity, world, stats, this.spellContext, this);
        }
    }

    private SpellStats getCastStats(LivingEntity caster, @Nullable HitResult result) {
        return new SpellStats.Builder().setAugments(this.spell.getAugments(0, caster)).addItemsFromEntity(caster).build(this.castType, result, caster.f_19853_, caster, this.spellContext);
    }

    public void onCastOnBlock(BlockHitResult blockRayTraceResult, LivingEntity caster) {
        if (this.canCast(caster) && !this.postEvent(caster)) {
            this.castType.onCastOnBlock(blockRayTraceResult, caster, this.getCastStats(caster, (HitResult)blockRayTraceResult), this.spellContext, this);
        }
    }

    public void onCastOnBlock(UseOnContext context) {
        if (this.canCast((LivingEntity)context.m_43723_()) && !this.postEvent((LivingEntity)context.m_43723_())) {
            this.castType.onCastOnBlock(context, this.getCastStats((LivingEntity)context.m_43723_(), (HitResult)context.f_43705_), this.spellContext, this);
        }
    }

    public void onCastOnEntity(ItemStack stack, LivingEntity playerIn, Entity target, InteractionHand hand) {
        if (this.canCast(playerIn) && !this.postEvent(playerIn)) {
            this.castType.onCastOnEntity(stack, playerIn, target, hand, this.getCastStats(playerIn, (HitResult)new EntityHitResult(target)), this.spellContext, this);
        }
    }

    public void onResolveEffect(Level world, LivingEntity shooter, HitResult result) {
        SpellResolver.resolveEffects(world, shooter, result, this.spell, this.spellContext);
    }

    public static void resolveEffects(Level world, LivingEntity shooter, HitResult result, Spell spell, SpellContext spellContext) {
        AbstractSpellPart part;
        spellContext.resetCastCounter();
        shooter = SpellResolver.getUnwrappedCaster(world, shooter, spellContext);
        SpellResolveEvent.Pre spellResolveEvent = new SpellResolveEvent.Pre(world, shooter, result, spell, spellContext);
        MinecraftForge.EVENT_BUS.post((Event)spellResolveEvent);
        if (spellResolveEvent.isCanceled()) {
            return;
        }
        while (spellContext.hasNextPart() && (part = spellContext.nextPart()) != null) {
            if (part instanceof AbstractAugment) continue;
            SpellStats.Builder builder = new SpellStats.Builder();
            List<AbstractAugment> augments = spell.getAugments(spellContext.getCurrentIndex() - 1, shooter);
            SpellStats stats = builder.setAugments(augments).addItemsFromEntity(shooter).build(part, result, world, shooter, spellContext);
            if (!(part instanceof AbstractEffect)) continue;
            ((AbstractEffect)part).onResolve(result, world, shooter, stats, spellContext);
        }
        MinecraftForge.EVENT_BUS.post((Event)new SpellResolveEvent.Post(world, shooter, result, spell, spellContext));
    }

    public static LivingEntity getUnwrappedCaster(Level world, LivingEntity shooter, SpellContext spellContext) {
        if (shooter == null && spellContext.castingTile != null) {
            shooter = ANFakePlayer.getPlayer((ServerLevel)world);
            BlockPos pos = spellContext.castingTile.m_58899_();
            shooter.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        }
        shooter = shooter == null ? ANFakePlayer.getPlayer((ServerLevel)world) : shooter;
        return shooter;
    }

    public boolean wouldAllEffectsDoWork(HitResult result, Level world, LivingEntity entity, SpellStats stats) {
        for (AbstractSpellPart spellPart : this.spell.recipe) {
            if (!(spellPart instanceof AbstractEffect) || ((AbstractEffect)spellPart).wouldSucceed(result, world, entity, stats, this.spellContext)) continue;
            return false;
        }
        return true;
    }

    public boolean wouldCastOnBlockSuccessfully(BlockHitResult blockRayTraceResult, LivingEntity caster) {
        return this.castType.wouldCastOnBlockSuccessfully(blockRayTraceResult, caster, this.getCastStats(caster, (HitResult)blockRayTraceResult), this);
    }

    public void expendMana(LivingEntity entity) {
        int totalCost = this.getCastingCost(this.spell, entity);
        CapabilityRegistry.getMana(entity).ifPresent(mana -> mana.removeMana(totalCost));
    }

    public int getCastingCost(Spell spell, LivingEntity e) {
        int cost = spell.getCastingCost() - ManaUtil.getPlayerDiscounts(e);
        return Math.max(cost, 0);
    }
}

